/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.SparseVector;
import jsat.linear.Vec;
import jsat.utils.SystemInfo;

public class LUPDecomposition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -149659693838168048L;
    private static final int threads = SystemInfo.LogicalCores;
    private final Matrix L;
    private final Matrix U;
    private final Matrix P;

    public LUPDecomposition(Matrix L, Matrix U, Matrix P) {
        this.L = L;
        this.U = U;
        this.P = P;
    }

    public LUPDecomposition(Matrix A2) {
        Matrix[] lup = A2.clone().lup();
        this.L = lup[0];
        this.U = lup[1];
        this.P = lup[2];
    }

    public LUPDecomposition(Matrix A2, ExecutorService threadpool) {
        Matrix[] lup = A2.clone().lup(threadpool);
        this.L = lup[0];
        this.U = lup[1];
        this.P = lup[2];
    }

    public boolean isSquare() {
        return this.L.isSquare() && this.U.isSquare();
    }

    public double det() {
        if (!this.isSquare()) {
            throw new ArithmeticException("Rectangual matricies do not have a determinat");
        }
        double det = 1.0;
        for (int i = 0; i < Math.min(this.U.rows(), this.U.cols()); ++i) {
            det *= this.U.get(i, i);
        }
        int rowSwaps = 0;
        Matrix pCopy = this.P.clone();
        for (int i = 0; i < pCopy.cols(); ++i) {
            if (pCopy.get(i, i) == 1.0) continue;
            ++rowSwaps;
            int j = i + 1;
            while (pCopy.get(j, i) == 0.0) {
                ++j;
            }
            pCopy.swapRows(i, j);
        }
        return rowSwaps % 2 != 0 ? -det : det;
    }

    public Vec solve(Vec b) {
        Vec y = LUPDecomposition.forwardSub(this.L, this.P.multiply(b));
        Vec x = LUPDecomposition.backSub(this.U, y);
        return x;
    }

    public Matrix solve(Matrix B) {
        Matrix y = LUPDecomposition.forwardSub(this.L, this.P.multiply(B));
        Matrix x = LUPDecomposition.backSub(this.U, y);
        return x;
    }

    public Matrix solve(Matrix B, ExecutorService threadpool) {
        Matrix y = LUPDecomposition.forwardSub(this.L, this.P.multiply(B), threadpool);
        Matrix x = LUPDecomposition.backSub(this.U, y, threadpool);
        return x;
    }

    public LUPDecomposition clone() {
        return new LUPDecomposition(this.L.clone(), this.U.clone(), this.P.clone());
    }

    public static Vec forwardSub(Matrix L, Vec b) {
        if (b.length() != L.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        Vec y = b instanceof SparseVector ? new SparseVector(b.length()) : new DenseVector(b.length());
        for (int i = 0; i < b.length(); ++i) {
            double y_i = b.get(i);
            for (int j = 0; j < i; ++j) {
                y_i -= L.get(i, j) * y.get(j);
            }
            y.set(i, y_i /= L.get(i, i));
        }
        return y;
    }

    public static Matrix forwardSub(Matrix L, Matrix b) {
        if (b.rows() != L.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        DenseMatrix y = new DenseMatrix(b.rows(), b.cols());
        double[] y_col_k = new double[b.rows()];
        for (int k = 0; k < b.cols(); ++k) {
            for (int i = 0; i < b.rows(); ++i) {
                y_col_k[i] = b.get(i, k);
                for (int j = 0; j < i; ++j) {
                    int n = i;
                    y_col_k[n] = y_col_k[n] - L.get(i, j) * y_col_k[j];
                }
                int n = i;
                y_col_k[n] = y_col_k[n] / L.get(i, i);
            }
            for (int z = 0; z < y_col_k.length; ++z) {
                ((Matrix)y).set(z, k, y_col_k[z]);
            }
        }
        return y;
    }

    public static Matrix forwardSub(final Matrix L, final Matrix b, ExecutorService threadpool) {
        if (b.rows() != L.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        final CountDownLatch latch = new CountDownLatch(threads);
        final DenseMatrix y = new DenseMatrix(b.rows(), b.cols());
        int threadNum = 0;
        while (threadNum < threads) {
            final int threadID = threadNum++;
            threadpool.submit(new Runnable(){

                @Override
                public void run() {
                    double[] y_col_k = new double[b.rows()];
                    for (int k = threadID; k < b.cols(); k += threads) {
                        for (int i = 0; i < b.rows(); ++i) {
                            y_col_k[i] = b.get(i, k);
                            for (int j = 0; j < i; ++j) {
                                int n = i;
                                y_col_k[n] = y_col_k[n] - L.get(i, j) * y_col_k[j];
                            }
                            int n = i;
                            y_col_k[n] = y_col_k[n] / L.get(i, i);
                        }
                        for (int z = 0; z < y_col_k.length; ++z) {
                            y.set(z, k, y_col_k[z]);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LUPDecomposition.class.getName()).log(Level.SEVERE, null, ex);
            return LUPDecomposition.forwardSub(L, b);
        }
        return y;
    }

    public static Vec backSub(Matrix U, Vec y) {
        int start;
        if (y.length() != U.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        Vec x = y instanceof SparseVector ? new SparseVector(U.cols()) : new DenseVector(U.cols());
        for (int i = start = Math.min(U.rows(), U.cols()) - 1; i >= 0; --i) {
            double x_i = y.get(i);
            for (int j = i + 1; j <= start; ++j) {
                x_i -= U.get(i, j) * x.get(j);
            }
            if (Double.isInfinite(x_i /= U.get(i, i))) {
                x_i = 0.0;
            }
            x.set(i, x_i);
        }
        return x;
    }

    public static Matrix backSub(Matrix U, Matrix y) {
        if (y.rows() != U.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        DenseMatrix x = new DenseMatrix(U.cols(), y.cols());
        double[] x_col_k = new double[y.rows()];
        int start = Math.min(U.rows(), U.cols()) - 1;
        for (int k = 0; k < y.cols(); ++k) {
            int i;
            for (i = start; i >= 0; --i) {
                x_col_k[i] = y.get(i, k);
                for (int j = i + 1; j <= start; ++j) {
                    int n = i;
                    x_col_k[n] = x_col_k[n] - U.get(i, j) * x_col_k[j];
                }
                int n = i;
                x_col_k[n] = x_col_k[n] / U.get(i, i);
            }
            for (i = 0; i < x_col_k.length; ++i) {
                if (Double.isInfinite(x_col_k[i])) {
                    ((Matrix)x).set(i, k, 0.0);
                    continue;
                }
                ((Matrix)x).set(i, k, x_col_k[i]);
            }
        }
        return x;
    }

    public static Matrix backSub(final Matrix U, final Matrix y, ExecutorService threadpool) {
        if (y.rows() != U.rows()) {
            throw new ArithmeticException("Vector and matrix sizes do not agree");
        }
        final DenseMatrix x = new DenseMatrix(U.cols(), y.cols());
        final CountDownLatch latch = new CountDownLatch(threads);
        final int start = Math.min(U.rows(), U.cols()) - 1;
        int threadNum = 0;
        while (threadNum < threads) {
            final int threadID = threadNum++;
            threadpool.submit(new Runnable(){

                @Override
                public void run() {
                    double[] x_col_k = new double[y.rows()];
                    for (int k = threadID; k < y.cols(); k += threads) {
                        int i;
                        for (i = start; i >= 0; --i) {
                            x_col_k[i] = y.get(i, k);
                            for (int j = i + 1; j <= start; ++j) {
                                int n = i;
                                x_col_k[n] = x_col_k[n] - U.get(i, j) * x_col_k[j];
                            }
                            int n = i;
                            x_col_k[n] = x_col_k[n] / U.get(i, i);
                        }
                        for (i = 0; i < x_col_k.length; ++i) {
                            if (Double.isInfinite(x_col_k[i])) {
                                x.set(i, k, 0.0);
                                continue;
                            }
                            x.set(i, k, x_col_k[i]);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LUPDecomposition.class.getName()).log(Level.SEVERE, null, ex);
            return LUPDecomposition.backSub(U, y);
        }
        return x;
    }
}

