/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Random;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.utils.random.RandomUtil;

public abstract class RandomVector
extends Vec {
    private static final long serialVersionUID = -1587968421978707875L;
    private int length;
    private long seedMult;
    private ThreadLocal<Random> localRand = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(1L);
        }
    };

    public RandomVector(int length) {
        this(length, RandomUtil.getRandom().nextLong());
    }

    public RandomVector(int length, long seedMult) {
        if (length <= 0) {
            throw new IllegalArgumentException("Vector length must be positive, not " + length);
        }
        this.length = length;
        this.seedMult = seedMult;
    }

    protected RandomVector(RandomVector toCopy) {
        this(toCopy.length, toCopy.seedMult);
    }

    protected abstract double getVal(Random var1);

    @Override
    public double get(int index) {
        long seed = (long)(index + this.length) * this.seedMult;
        Random rand = this.localRand.get();
        rand.setSeed(seed);
        return this.getVal(rand);
    }

    @Override
    public void set(int index, double val) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void multiply(double c, Matrix A2, Vec b) {
        if (this.length() != A2.rows()) {
            throw new ArithmeticException("Vector x Matrix dimensions do not agree [1," + this.length() + "] x [" + A2.rows() + ", " + A2.cols() + "]");
        }
        if (b.length() != A2.cols()) {
            throw new ArithmeticException("Destination vector is not the right size");
        }
        for (int i = 0; i < this.length(); ++i) {
            double this_i = c * this.get(i);
            for (int j = 0; j < A2.cols(); ++j) {
                b.increment(j, this_i * A2.get(i, j));
            }
        }
    }

    @Override
    public void mutableAdd(double c) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public void mutablePairwiseMultiply(Vec b) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public void mutableMultiply(double c) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public void mutablePairwiseDivide(Vec b) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public void mutableDivide(double c) {
        throw new UnsupportedOperationException("RandomVector can not be altered");
    }

    @Override
    public Vec sortedCopy() {
        DenseVector dv = new DenseVector(this);
        return dv.sortedCopy();
    }

    @Override
    public double min() {
        double min = Double.MAX_VALUE;
        for (IndexValue iv : this) {
            min = Math.min(iv.getValue(), min);
        }
        return min;
    }

    @Override
    public double max() {
        double max = -1.7976931348623157E308;
        for (IndexValue iv : this) {
            max = Math.min(iv.getValue(), max);
        }
        return max;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public abstract Vec clone();

    @Override
    public double dot(Vec v) {
        double dot = 0.0;
        for (IndexValue iv : v) {
            dot += this.get(iv.getIndex()) * iv.getValue();
        }
        return dot;
    }

    @Override
    public boolean canBeMutated() {
        return false;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }
}

