/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Collections;
import java.util.Iterator;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class ScaledVector
extends Vec {
    private static final long serialVersionUID = 7357893957632067299L;
    private double scale;
    private Vec base;

    public ScaledVector(double scale, Vec base) {
        this.scale = scale;
        this.base = base;
    }

    public ScaledVector(Vec vec) {
        this(1.0, vec);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            this.zeroOut();
        } else {
            this.scale = scale;
        }
    }

    public Vec getBase() {
        return this.base;
    }

    public void embedScale() {
        this.base.mutableMultiply(this.scale);
        this.scale = 1.0;
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public double get(int index) {
        return this.base.get(index) * this.scale;
    }

    @Override
    public void set(int index, double val) {
        this.base.set(index, val / this.scale);
    }

    @Override
    public void multiply(double c, Matrix A2, Vec b) {
        this.base.multiply(c / this.scale, A2, b);
    }

    @Override
    public void mutableAdd(double c) {
        this.base.mutableAdd(c / this.scale);
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        this.base.mutableAdd(c / this.scale, b);
    }

    @Override
    public void mutablePairwiseMultiply(Vec b) {
        this.base.mutablePairwiseMultiply(b);
    }

    @Override
    public void mutableMultiply(double c) {
        this.scale *= c;
        if (this.scale == 0.0) {
            this.zeroOut();
        } else if (Math.abs(this.scale) < 1.0E-10 || Math.abs(this.scale) > 1.0E10) {
            this.embedScale();
        }
    }

    @Override
    public void mutablePairwiseDivide(Vec b) {
        this.base.mutablePairwiseDivide(b);
    }

    @Override
    public void mutableDivide(double c) {
        this.scale /= c;
        if (this.scale == 0.0) {
            this.zeroOut();
        }
    }

    @Override
    public Vec sortedCopy() {
        return new ScaledVector(this.scale, this.base.sortedCopy());
    }

    @Override
    public double min() {
        if (this.scale >= 0.0) {
            return this.base.min() * this.scale;
        }
        return this.base.max() * this.scale;
    }

    @Override
    public double max() {
        if (this.scale >= 0.0) {
            return this.base.max() * this.scale;
        }
        return this.base.min() * this.scale;
    }

    @Override
    public double sum() {
        return this.scale * this.base.sum();
    }

    @Override
    public double mean() {
        return this.scale * this.base.mean();
    }

    @Override
    public double standardDeviation() {
        return this.scale * this.base.standardDeviation();
    }

    @Override
    public double median() {
        return this.scale * this.base.median();
    }

    @Override
    public double skewness() {
        return this.base.skewness();
    }

    @Override
    public double kurtosis() {
        return this.base.kurtosis();
    }

    @Override
    public boolean isSparse() {
        return this.base.isSparse();
    }

    @Override
    public Vec clone() {
        return new ScaledVector(this.scale, this.base.clone());
    }

    @Override
    public double pNorm(double p) {
        return this.scale * this.base.pNorm(p);
    }

    @Override
    public double dot(Vec v) {
        return this.scale * this.base.dot(v);
    }

    @Override
    public double[] arrayCopy() {
        double[] copy = this.base.arrayCopy();
        int i = 0;
        while (i < copy.length) {
            int n = i++;
            copy[n] = copy[n] * this.scale;
        }
        return copy;
    }

    @Override
    public void zeroOut() {
        this.scale = 1.0;
        this.base.zeroOut();
    }

    @Override
    public int nnz() {
        return this.base.nnz();
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(int start) {
        if (this.scale == 0.0) {
            return Collections.EMPTY_LIST.iterator();
        }
        final Iterator<IndexValue> origIter = this.base.getNonZeroIterator(start);
        Iterator<IndexValue> wrapedIter = new Iterator<IndexValue>(){

            @Override
            public boolean hasNext() {
                return origIter.hasNext();
            }

            @Override
            public IndexValue next() {
                IndexValue iv = (IndexValue)origIter.next();
                if (iv != null) {
                    iv.setValue(ScaledVector.this.scale * iv.getValue());
                }
                return iv;
            }

            @Override
            public void remove() {
                origIter.remove();
            }
        };
        return wrapedIter;
    }

    @Override
    public void setLength(int length) {
        this.base.setLength(length);
    }
}

