/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import jsat.linear.DenseMatrix;
import jsat.linear.GenericMatrix;
import jsat.linear.Matrix;
import jsat.linear.SubVector;
import jsat.linear.Vec;

public class SubMatrix
extends GenericMatrix {
    private static final long serialVersionUID = 8842973175562587725L;
    private Matrix baseMatrix;
    private int firstRow;
    private int firstColumn;
    private int toRow;
    private int toCol;

    public SubMatrix(Matrix baseMatrix, int firstRow, int firstColumn, int toRow, int toCol) {
        this.baseMatrix = baseMatrix;
        if (firstColumn < 0 || firstRow < 0 || toRow < 0 || toCol < 0) {
            throw new ArithmeticException("Can not give negative row or column counts");
        }
        if (toRow == 0 || toCol == 0) {
            throw new ArithmeticException("Must give a positive number of rows and columns");
        }
        if (toRow > baseMatrix.rows() || toCol > baseMatrix.cols()) {
            throw new ArithmeticException("You can not specify a matrix that goes past the row / column boundry of the base matrix");
        }
        if (firstRow >= toRow || firstColumn >= toCol) {
            throw new ArithmeticException("Illogical bounds given");
        }
        this.firstRow = firstRow;
        this.firstColumn = firstColumn;
        this.toRow = toRow;
        this.toCol = toCol;
        if (baseMatrix instanceof SubMatrix) {
            SubMatrix given = (SubMatrix)baseMatrix;
            this.baseMatrix = given.baseMatrix;
            this.firstRow += given.firstRow;
            this.firstColumn += given.firstColumn;
            this.toRow = given.toRow;
            this.toCol = given.toCol;
        }
    }

    public Matrix getBaseMatrix() {
        return this.baseMatrix;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    @Override
    protected Matrix getMatrixOfSameType(int rows, int cols) {
        return new DenseMatrix(rows, cols);
    }

    @Override
    public double get(int i, int j) {
        if (i >= this.rows() || j >= this.cols()) {
            throw new ArrayIndexOutOfBoundsException("Can not access index [" + i + ", " + j + "] in the matrix of dimension [" + this.rows() + ", " + this.cols() + "]");
        }
        return this.baseMatrix.get(i + this.firstRow, j + this.firstColumn);
    }

    @Override
    public void set(int i, int j, double value) {
        if (i >= this.rows() || j >= this.cols()) {
            throw new ArrayIndexOutOfBoundsException("Can not access index [" + i + ", " + j + "] in the matrix of dimension [" + this.rows() + ", " + this.cols() + "]");
        }
        this.baseMatrix.set(i + this.firstRow, j + this.firstColumn, value);
    }

    @Override
    public Vec getRowView(int r) {
        if (r >= this.rows()) {
            throw new IndexOutOfBoundsException("Can not access row " + r + " of " + this.rows() + " by " + this.cols() + " matrix");
        }
        Vec origVec = this.baseMatrix.getRowView(r - this.firstRow);
        return new SubVector(this.firstColumn, this.toCol - this.firstColumn, origVec);
    }

    @Override
    public Vec getColumnView(int j) {
        if (j >= this.cols()) {
            throw new IndexOutOfBoundsException("Can not access column " + j + " of " + this.rows() + " by " + this.cols() + " matrix");
        }
        Vec origVec = this.baseMatrix.getColumnView(j - this.firstColumn);
        return new SubVector(this.firstRow, this.toRow - this.firstRow, origVec);
    }

    @Override
    public int rows() {
        return this.toRow - this.firstRow;
    }

    @Override
    public int cols() {
        return this.toCol - this.firstColumn;
    }

    @Override
    public boolean isSparce() {
        return this.baseMatrix.isSparce();
    }

    @Override
    public void changeSize(int newRows, int newCols) {
        if (newRows <= 0) {
            throw new ArithmeticException("Matrix must have a positive number of rows");
        }
        if (newCols <= 0) {
            throw new ArithmeticException("Matrix must have a positive number of columns");
        }
        int underNewRows = Math.max(newRows + this.firstRow, this.baseMatrix.rows());
        int underNewCols = Math.max(newCols + this.firstColumn, this.baseMatrix.cols());
        this.baseMatrix.changeSize(underNewRows, underNewCols);
        if (newRows > this.rows()) {
            new SubMatrix(this.baseMatrix, this.toRow, this.firstColumn, this.firstRow + newRows, this.firstColumn + newCols).zeroOut();
        }
        if (newCols > this.cols()) {
            new SubMatrix(this.baseMatrix, this.firstRow, this.toCol, this.firstRow + newRows, this.firstColumn + newCols).zeroOut();
        }
        this.toRow = this.firstRow + newRows;
        this.toCol = this.firstColumn + newCols;
    }
}

