/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Comparator;
import java.util.Iterator;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class VecPaired<V extends Vec, P>
extends Vec {
    private static final long serialVersionUID = 8039272826439917423L;
    private V vector;
    private P pair;

    public VecPaired(V v, P p) {
        this.vector = v;
        this.pair = p;
    }

    public P getPair() {
        return this.pair;
    }

    public void setPair(P pair) {
        this.pair = pair;
    }

    public V getVector() {
        return this.vector;
    }

    public void setVector(V vector) {
        this.vector = vector;
    }

    @Override
    public int length() {
        return ((Vec)this.vector).length();
    }

    @Override
    public int nnz() {
        return ((Vec)this.vector).nnz();
    }

    @Override
    public double get(int index) {
        return ((Vec)this.vector).get(index);
    }

    @Override
    public void set(int index, double val) {
        ((Vec)this.vector).set(index, val);
    }

    @Override
    public Vec add(double c) {
        return ((Vec)this.vector).add(c);
    }

    @Override
    public Vec add(Vec b) {
        b = VecPaired.extractTrueVec(b);
        return ((Vec)this.vector).add(b);
    }

    @Override
    public Vec subtract(Vec b) {
        b = VecPaired.extractTrueVec(b);
        return ((Vec)this.vector).subtract(b);
    }

    @Override
    public Vec pairwiseMultiply(Vec b) {
        b = VecPaired.extractTrueVec(b);
        return ((Vec)this.vector).pairwiseMultiply(b);
    }

    @Override
    public Vec multiply(double c) {
        return ((Vec)this.vector).multiply(c);
    }

    @Override
    public void multiply(double c, Matrix A2, Vec b) {
        ((Vec)this.vector).multiply(c, A2, b);
    }

    @Override
    public Vec pairwiseDivide(Vec b) {
        b = VecPaired.extractTrueVec(b);
        return ((Vec)this.vector).pairwiseDivide(b);
    }

    @Override
    public Vec divide(double c) {
        return ((Vec)this.vector).divide(c);
    }

    @Override
    public void mutableAdd(double c) {
        ((Vec)this.vector).mutableAdd(c);
    }

    @Override
    public void mutableAdd(Vec b) {
        b = VecPaired.extractTrueVec(b);
        ((Vec)this.vector).mutableAdd(b);
    }

    @Override
    public void mutableSubtract(Vec b) {
        b = VecPaired.extractTrueVec(b);
        ((Vec)this.vector).mutableSubtract(b);
    }

    @Override
    public void mutablePairwiseMultiply(Vec b) {
        b = VecPaired.extractTrueVec(b);
        ((Vec)this.vector).mutablePairwiseDivide(b);
    }

    @Override
    public void mutableMultiply(double c) {
        ((Vec)this.vector).mutableMultiply(c);
    }

    @Override
    public void mutablePairwiseDivide(Vec b) {
        b = VecPaired.extractTrueVec(b);
        ((Vec)this.vector).mutablePairwiseDivide(b);
    }

    @Override
    public void mutableDivide(double c) {
        ((Vec)this.vector).mutableDivide(c);
    }

    @Override
    public Vec sortedCopy() {
        return ((Vec)this.vector).sortedCopy();
    }

    @Override
    public double min() {
        return ((Vec)this.vector).min();
    }

    @Override
    public double max() {
        return ((Vec)this.vector).max();
    }

    @Override
    public double sum() {
        return ((Vec)this.vector).sum();
    }

    @Override
    public double mean() {
        return ((Vec)this.vector).mean();
    }

    @Override
    public double standardDeviation() {
        return ((Vec)this.vector).standardDeviation();
    }

    @Override
    public double variance() {
        return ((Vec)this.vector).variance();
    }

    @Override
    public double median() {
        return ((Vec)this.vector).median();
    }

    @Override
    public double skewness() {
        return ((Vec)this.vector).skewness();
    }

    @Override
    public double kurtosis() {
        return ((Vec)this.vector).kurtosis();
    }

    @Override
    public Vec clone() {
        return new VecPaired<Vec, P>(((Vec)this.vector).clone(), this.pair);
    }

    @Override
    public Vec normalized() {
        return ((Vec)this.vector).normalized();
    }

    @Override
    public void normalize() {
        ((Vec)this.vector).normalize();
    }

    @Override
    public double pNormDist(double p, Vec y) {
        y = VecPaired.extractTrueVec(y);
        return ((Vec)this.vector).pNormDist(p, y);
    }

    @Override
    public double pNorm(double p) {
        return ((Vec)this.vector).pNorm(p);
    }

    @Override
    public double dot(Vec v) {
        v = VecPaired.extractTrueVec(v);
        return ((Vec)this.vector).dot(v);
    }

    @Override
    public String toString() {
        return ((Vec)this.vector).toString();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Vec)this.vector).equals(obj);
    }

    @Override
    public boolean equals(Object obj, double range) {
        return ((Vec)this.vector).equals(obj, range);
    }

    @Override
    public double[] arrayCopy() {
        return ((Vec)this.vector).arrayCopy();
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        b = VecPaired.extractTrueVec(b);
        ((Vec)this.vector).mutableAdd(c, b);
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(int start) {
        return VecPaired.extractTrueVec(this.vector).getNonZeroIterator(start);
    }

    public static Vec extractTrueVec(Vec b) {
        while (b instanceof VecPaired) {
            b = ((VecPaired)b).getVector();
        }
        return b;
    }

    public static <V extends Vec, P extends Comparable<P>> Comparator<VecPaired<V, P>> vecPairedComparator() {
        Comparator comp = new Comparator<VecPaired<V, P>>(){

            @Override
            public int compare(VecPaired<V, P> o1, VecPaired<V, P> o2) {
                return ((Comparable)o1.getPair()).compareTo(o2.getPair());
            }
        };
        return comp;
    }

    @Override
    public int hashCode() {
        return ((Vec)this.vector).hashCode();
    }

    @Override
    public boolean isSparse() {
        return ((Vec)this.vector).isSparse();
    }

    @Override
    public void setLength(int length) {
        ((Vec)this.vector).setLength(length);
    }
}

