/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.decayrates;

import jsat.math.FastMath;
import jsat.math.decayrates.DecayRate;
import jsat.parameters.Parameterized;

public class PowerDecay
implements DecayRate,
Parameterized {
    private static final long serialVersionUID = 6075066391550611699L;
    private double tau;
    private double alpha;

    public PowerDecay(double tau, double alpha) {
        this.setTau(tau);
        this.setAlpha(alpha);
    }

    public PowerDecay() {
        this(10.0, 0.5);
    }

    public void setAlpha(double alpha) {
        if (alpha < 0.0 || Double.isInfinite(alpha) || Double.isNaN(alpha)) {
            throw new IllegalArgumentException("alpha must be a non negative constant, not " + alpha);
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setTau(double tau) {
        if (tau <= 0.0 || Double.isInfinite(tau) || Double.isNaN(tau)) {
            throw new IllegalArgumentException("tau must be a positive constant, not " + tau);
        }
        this.tau = tau;
    }

    public double getTau() {
        return this.tau;
    }

    @Override
    public double rate(double time, double maxTime, double initial) {
        return this.rate(time, initial);
    }

    @Override
    public double rate(double time, double initial) {
        return initial * FastMath.pow(this.tau + time, -this.alpha);
    }

    @Override
    public DecayRate clone() {
        return new PowerDecay(this.tau, this.alpha);
    }

    public String toString() {
        return "Power Decay";
    }
}

