/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.integration;

import jsat.math.Function1D;

public class Trapezoidal {
    public static double trapz(Function1D f, double a, double b, int N) {
        if (a == b) {
            return 0.0;
        }
        if (a > b) {
            throw new RuntimeException("Integral upper limit (" + b + ") must be larger than the lower-limit (" + a + ")");
        }
        if (N < 1) {
            throw new RuntimeException("At least two integration parts must be used, not " + N);
        }
        double sum = 0.0;
        for (int k = 1; k < N; ++k) {
            sum += f.f(a + (double)k * (b - a) / (double)N);
        }
        return (b - a) / (double)N * (sum += (f.f(a) + f.f(b)) / 2.0);
    }
}

