/*
 * Decompiled with CFR 0.152.
 */
package jsat.outlier;

import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.distributions.multivariate.MultivariateDistribution;
import jsat.distributions.multivariate.NormalMR;
import jsat.outlier.Outlier;
import jsat.utils.concurrent.ParallelUtils;

public class DensityOutlier
implements Outlier {
    private double outlierFraction;
    private MultivariateDistribution density;
    private double threshold;

    public DensityOutlier() {
        this(0.05);
    }

    public DensityOutlier(double outlierFraction) {
        this(outlierFraction, new NormalMR());
    }

    public DensityOutlier(double outlierFraction, MultivariateDistribution density) {
        this.outlierFraction = outlierFraction;
        this.density = density;
    }

    public DensityOutlier(DensityOutlier toCopy) {
        this(toCopy.outlierFraction, toCopy.density.clone());
        this.threshold = toCopy.threshold;
    }

    public void setOutlierFraction(double outlierFraction) {
        this.outlierFraction = outlierFraction;
    }

    public double getOutlierFraction() {
        return this.outlierFraction;
    }

    public void setDensityDistribution(MultivariateDistribution density) {
        this.density = density;
    }

    public MultivariateDistribution getDensityDistribution() {
        return this.density;
    }

    @Override
    public void fit(DataSet d, boolean parallel) {
        this.density.setUsingData(d, parallel);
        double[] scores = new double[d.size()];
        ParallelUtils.run(parallel, scores.length, (start, end) -> {
            for (int i = start; i < end; ++i) {
                scores[i] = this.density.logPdf(d.getDataPoint(i).getNumericalValues());
            }
        });
        Arrays.sort(scores);
        this.threshold = scores[(int)((double)scores.length * this.outlierFraction)];
    }

    @Override
    public double score(DataPoint x) {
        double logPDF = this.density.logPdf(x.getNumericalValues());
        return logPDF - this.threshold;
    }

    protected DensityOutlier clone() throws CloneNotSupportedException {
        return new DensityOutlier(this);
    }
}

