/*
 * Decompiled with CFR 0.152.
 */
package jsat.outlier;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.math.FastMath;
import jsat.math.SpecialMath;
import jsat.outlier.Outlier;
import jsat.utils.IntList;
import jsat.utils.concurrent.ParallelUtils;
import jsat.utils.random.RandomUtil;

public class IsolationForest
implements Outlier {
    private int trees = 100;
    private double subSamplingSize = 256.0;
    List<iTreeNode> roots = new ArrayList<iTreeNode>();

    public IsolationForest() {
    }

    public IsolationForest(IsolationForest toCopy) {
        this.trees = toCopy.trees;
        this.subSamplingSize = toCopy.subSamplingSize;
        this.roots = new ArrayList<iTreeNode>();
        for (iTreeNode root : toCopy.roots) {
            this.roots.add(root.clone());
        }
    }

    private static double c(double n) {
        return 2.0 * SpecialMath.harmonic(n - 1.0) - 2.0 * (n - 1.0) / n;
    }

    @Override
    public void fit(DataSet d, boolean parallel) {
        for (int i = 0; i < this.trees; ++i) {
            this.roots.add(new iTreeNode());
        }
        int l = (int)Math.ceil(Math.log(this.subSamplingSize) / Math.log(2.0));
        int D2 = d.getNumNumericalVars();
        ParallelUtils.streamP(this.roots.stream(), parallel).forEach(r -> r.build(0, l, d, IntList.range(d.size()), new double[D2], new double[D2]));
    }

    @Override
    public double score(DataPoint x) {
        double e_h_x = this.roots.stream().mapToDouble(r -> r.pathLength(x.getNumericalValues(), 0.0)).average().getAsDouble();
        double anomScore = FastMath.pow2(-e_h_x / IsolationForest.c(this.subSamplingSize));
        return 0.5 - anomScore;
    }

    protected IsolationForest clone() throws CloneNotSupportedException {
        return new IsolationForest(this);
    }

    private class iTreeNode
    implements Serializable {
        iTreeNode leftChild;
        iTreeNode rightChild;
        double size = 0.0;
        double splitVal;
        int splitAtt;

        public iTreeNode() {
        }

        public iTreeNode(iTreeNode toCopy) {
            this.leftChild = new iTreeNode(toCopy.leftChild);
            this.rightChild = new iTreeNode(toCopy.rightChild);
            this.splitVal = toCopy.splitVal;
            this.splitAtt = toCopy.splitAtt;
        }

        protected iTreeNode clone() {
            return new iTreeNode(this);
        }

        public void build(int e, int l, DataSet source, IntList X, double[] minVals, double[] maxVals) {
            if (e >= l || X.size() <= 1) {
                this.size = X.isEmpty() ? 1.0 : X.stream().mapToDouble(s -> source.getWeight((int)s)).sum();
                return;
            }
            int D2 = source.getNumNumericalVars();
            Arrays.fill(minVals, 0.0);
            Arrays.fill(maxVals, 0.0);
            X.stream().forEach(d -> {
                for (IndexValue iv : source.getDataPoint((int)d).getNumericalValues()) {
                    int i = iv.getIndex();
                    minVals[i] = Math.min(minVals[i], iv.getValue());
                    maxVals[i] = Math.max(maxVals[i], iv.getValue());
                }
            });
            int candiadates = 0;
            for (int i = 0; i < D2; ++i) {
                if (minVals[i] == maxVals[i]) continue;
                ++candiadates;
            }
            int q_candidate = RandomUtil.getLocalRandom().nextInt(candiadates);
            int q = 0;
            for (int i = 0; i < D2; ++i) {
                if (minVals[i] == maxVals[i] || --q_candidate != 0) continue;
                q = i;
                break;
            }
            this.splitVal = RandomUtil.getLocalRandom().nextDouble();
            this.splitVal = minVals[q] + (maxVals[q] - minVals[q]) * this.splitVal;
            IntList X_l = new IntList();
            IntList X_r = new IntList();
            Iterator iterator = X.iterator();
            while (iterator.hasNext()) {
                int x = (Integer)iterator.next();
                if (source.getDataPoint(x).getNumericalValues().get(q) < this.splitVal) {
                    X_l.add(x);
                    continue;
                }
                X_r.add(x);
            }
            this.splitAtt = q;
            this.leftChild = new iTreeNode();
            this.leftChild.build(e + 1, l, source, X_l, minVals, maxVals);
            this.rightChild = new iTreeNode();
            this.rightChild.build(e + 1, l, source, X_r, minVals, maxVals);
        }

        public double pathLength(Vec x, double e) {
            if (this.leftChild == null) {
                return e + IsolationForest.c(this.size);
            }
            if (x.get(this.splitAtt) < this.splitVal) {
                return this.leftChild.pathLength(x, e + 1.0);
            }
            return this.rightChild.pathLength(x, e + 1.0);
        }
    }
}

