// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
package org.matomo.java.tracking;

import java.util.function.BiConsumer;
import lombok.NonNull;

/**
 * The type of action performed (download or outlink).
 */
public enum ActionType {
  DOWNLOAD(MatomoRequest.MatomoRequestBuilder::downloadUrl), LINK(MatomoRequest.MatomoRequestBuilder::outlinkUrl);
  @NonNull
  private final BiConsumer<MatomoRequest.MatomoRequestBuilder, String> consumer;

  /**
   * Applies the action URL to the given builder.
   *
   * @param builder   The builder to apply the action URL to.
   * @param actionUrl The action URL to apply.
   *
   * @return The builder with the action URL applied.
   */
  public MatomoRequest.MatomoRequestBuilder applyUrl(@NonNull MatomoRequest.MatomoRequestBuilder builder, @NonNull String actionUrl) {
    if (builder == null) {
      throw new java.lang.NullPointerException("builder is marked non-null but is null");
    }
    if (actionUrl == null) {
      throw new java.lang.NullPointerException("actionUrl is marked non-null but is null");
    }
    consumer.accept(builder, actionUrl);
    return builder;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private ActionType(@NonNull final BiConsumer<MatomoRequest.MatomoRequestBuilder, String> consumer) {
    if (consumer == null) {
      throw new java.lang.NullPointerException("consumer is marked non-null but is null");
    }
    this.consumer = consumer;
  }
}
