/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.console;

import java.io.File;
import java.io.Serializable;
import org.jline.terminal.Terminal;
import org.openmole.console.Command;
import org.openmole.console.Command$;
import org.openmole.console.Console$;
import org.openmole.console.Console$ExitCodes$;
import org.openmole.core.authentication.AuthenticationStore;
import org.openmole.core.compiler.CompilationContext;
import org.openmole.core.compiler.Interpreter;
import org.openmole.core.compiler.REPL;
import org.openmole.core.dsl.package$;
import org.openmole.core.event.EventDispatcher;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.fileservice.FileServiceCache;
import org.openmole.core.fileservice.FileServiceCache$;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.preference.Preference;
import org.openmole.core.project.CompilationError;
import org.openmole.core.project.CompileResult;
import org.openmole.core.project.Compiled;
import org.openmole.core.project.ConsoleVariables;
import org.openmole.core.project.ConsoleVariables$;
import org.openmole.core.project.OpenMOLEREPL$;
import org.openmole.core.project.Project$;
import org.openmole.core.project.ScriptFileDoesNotExists;
import org.openmole.core.project.ScriptFileDoesNotExists$;
import org.openmole.core.replication.ReplicaCatalog;
import org.openmole.core.serializer.SerializerService;
import org.openmole.core.services.Services;
import org.openmole.core.services.Services$;
import org.openmole.core.services.ServicesContainer;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.timeservice.TimeService;
import org.openmole.core.workflow.composition.DSL;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.Workspace;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.crypto.Cypher;
import org.openmole.tool.logger.JavaLogger$Log$;
import org.openmole.tool.logger.LoggerService;
import org.openmole.tool.logger.Prettifier$;
import org.openmole.tool.outputredirection.OutputRedirection;
import org.openmole.tool.random.Seeder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Console {
    private final Option<String> script;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Console$.class.getDeclaredField("Log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Console$.class.getDeclaredField("consoleUsage$lzy1"));

    public static JavaLogger$Log$ Log() {
        return Console$.MODULE$.Log();
    }

    public static String askPassword(String string, Terminal terminal) {
        return Console$.MODULE$.askPassword(string, terminal);
    }

    public static void chosePassword(String string, Preference preference) {
        Console$.MODULE$.chosePassword(string, preference);
    }

    public static String consoleSplash() {
        return Console$.MODULE$.consoleSplash();
    }

    public static String consoleUsage() {
        return Console$.MODULE$.consoleUsage();
    }

    public static Iterable<Tuple2<File, Throwable>> dealWithLoadError(Function0<Iterable<Tuple2<File, Throwable>>> function0, boolean bl) {
        return Console$.MODULE$.dealWithLoadError(function0, bl);
    }

    public static String initPassword(Preference preference, Terminal terminal) {
        return Console$.MODULE$.initPassword(preference, terminal);
    }

    public static boolean testPassword(String string, Preference preference) {
        return Console$.MODULE$.testPassword(string, preference);
    }

    public static <T> T withTerminal(Function1<Terminal, T> function1) {
        return Console$.MODULE$.withTerminal(function1);
    }

    public static Option<String> $lessinit$greater$default$1() {
        return Console$.MODULE$.$lessinit$greater$default$1();
    }

    public static String askPassword$default$1() {
        return Console$.MODULE$.askPassword$default$1();
    }

    public Console(Option<String> script) {
        this.script = script;
    }

    public String commandsName() {
        return "_commands_";
    }

    public int run(Seq<String> args, Option<File> workDirectory, boolean splash, Services services, Terminal terminal) {
        Option<String> option;
        if (splash) {
            Predef$.MODULE$.println((Object)Console$.MODULE$.consoleSplash());
            Predef$.MODULE$.println((Object)Console$.MODULE$.consoleUsage());
        }
        if (None$.MODULE$.equals(option = this.script)) {
            ConsoleVariables variables = ConsoleVariables$.MODULE$.apply(args, (File)workDirectory.getOrElse(Console::$anonfun$1), ConsoleVariables.Experiment$.MODULE$.apply("console", services.timeService()), services);
            return BoxesRunTime.unboxToInt(this.withREPL(variables, (Function1 & Serializable)loop -> {
                loop.loop((Option)Some$.MODULE$.apply((Object)terminal));
                return 0;
            }, services.tmpDirectory(), services.fileService(), terminal));
        }
        if (option instanceof Some) {
            String script = (String)((Some)option).value();
            File scriptFile = new File(script);
            Either<Object, CompiledDSL> either = this.load(scriptFile, args, workDirectory, services);
            if (either instanceof Right) {
                CompiledDSL dsl = (CompiledDSL)((Right)either).value();
                Try try_ = Try$.MODULE$.apply(() -> Console.run$$anonfun$2(dsl, services));
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    Predef$.MODULE$.println((Object)Prettifier$.MODULE$.stackString(e));
                    return Console$ExitCodes$.MODULE$.executionError();
                }
                if (try_ instanceof Success) {
                    return Console$ExitCodes$.MODULE$.ok();
                }
                throw new MatchError((Object)try_);
            }
            if (either instanceof Left) {
                int c = BoxesRunTime.unboxToInt((Object)((Left)either).value());
                return c;
            }
            throw new MatchError(either);
        }
        throw new MatchError(option);
    }

    public boolean run$default$3() {
        return true;
    }

    public Either<Object, CompiledDSL> load(File script, Seq<String> args, Option<File> workDirectory, Services services) {
        FileServiceCache fileServiceCache = FileServiceCache$.MODULE$.apply(services.preference());
        Workspace workspace = Services$.MODULE$.copy$default$2(services);
        Preference preference = Services$.MODULE$.copy$default$3(services);
        Cypher cypher = Services$.MODULE$.copy$default$4(services);
        ThreadProvider threadProvider = Services$.MODULE$.copy$default$5(services);
        Seeder seeder = Services$.MODULE$.copy$default$6(services);
        ReplicaCatalog replicaCatalog = Services$.MODULE$.copy$default$7(services);
        TmpDirectory tmpDirectory = Services$.MODULE$.copy$default$8(services);
        AuthenticationStore authenticationStore = Services$.MODULE$.copy$default$9(services);
        SerializerService serializerService = Services$.MODULE$.copy$default$10(services);
        FileService fileService = Services$.MODULE$.copy$default$11(services);
        Lazy lazy = Services$.MODULE$.copy$default$12(services);
        EventDispatcher eventDispatcher = Services$.MODULE$.copy$default$13(services);
        OutputRedirection outputRedirection = Services$.MODULE$.copy$default$14(services);
        NetworkService networkService = Services$.MODULE$.copy$default$15(services);
        LoggerService loggerService = Services$.MODULE$.copy$default$17(services);
        TimeService timeService = Services$.MODULE$.copy$default$18(services);
        ServicesContainer runServices = Services$.MODULE$.copy(services, workspace, preference, cypher, threadProvider, seeder, replicaCatalog, tmpDirectory, authenticationStore, serializerService, fileService, lazy, eventDispatcher, outputRedirection, networkService, fileServiceCache, loggerService, timeService);
        CompileResult compileResult = Project$.MODULE$.compile((File)workDirectory.getOrElse(() -> Console.load$$anonfun$1(script)), script, Project$.MODULE$.compile$default$3(), Project$.MODULE$.compile$default$4(), (Services)runServices);
        if (compileResult instanceof ScriptFileDoesNotExists && ScriptFileDoesNotExists$.MODULE$.unapply((ScriptFileDoesNotExists)compileResult)) {
            Predef$.MODULE$.println((Object)("File " + script + " doesn't exist."));
            return Left$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Console$ExitCodes$.MODULE$.scriptDoesNotExist()));
        }
        if (compileResult instanceof CompilationError) {
            CompilationError e = (CompilationError)compileResult;
            package$.MODULE$.FileDecorator(services.tmpDirectory().directory()).recursiveDelete();
            Predef$.MODULE$.println((Object)Prettifier$.MODULE$.stackString(e.error()));
            return Left$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Console$ExitCodes$.MODULE$.compilationError()));
        }
        if (compileResult instanceof Compiled) {
            Compiled compiled = (Compiled)compileResult;
            Try try_ = Try$.MODULE$.apply(() -> Console.load$$anonfun$2(compiled, args, services));
            if (try_ instanceof Success) {
                DSL res = (DSL)((Success)try_).value();
                return Right$.MODULE$.apply((Object)new CompiledDSL(res, compiled.compilationContext(), compiled.result()));
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                package$.MODULE$.FileDecorator(services.tmpDirectory().directory()).recursiveDelete();
                Predef$.MODULE$.println((Object)"Error during script evaluation: ");
                Predef$.MODULE$.print((Object)Prettifier$.MODULE$.stackString(e));
                return Left$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Console$ExitCodes$.MODULE$.compilationError()));
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)compileResult);
    }

    public <T> T withREPL(ConsoleVariables args, Function1<REPL, T> f, TmpDirectory x$3, FileService x$4, Terminal x$5) {
        Object object;
        args.workDirectory().mkdirs();
        REPL loop = OpenMOLEREPL$.MODULE$.newREPL(false, x$3, x$4);
        ConsoleVariables$.MODULE$.bindVariables(loop, args, ConsoleVariables$.MODULE$.bindVariables$default$3());
        loop.bind(this.commandsName(), (Object)new Command(loop, args, x$5), ManifestFactory$.MODULE$.classType(Command.class));
        loop.eval("import " + this.commandsName() + "._");
        try {
            object = f.apply((Object)loop);
        }
        finally {
            loop.close();
        }
        return (T)object;
    }

    private static final File $anonfun$1() {
        return package$.MODULE$.currentDirectory();
    }

    private static final MoleExecution run$$anonfun$2(CompiledDSL dsl$1, Services services$1) {
        MoleExecution moleExecution = Command$.MODULE$.start(dsl$1.dsl(), dsl$1.compilationContext(), services$1);
        return moleExecution.hangOn(moleExecution.hangOn$default$1());
    }

    private static final File load$$anonfun$1(File script$1) {
        return package$.MODULE$.FileDecorator(script$1).getParentFileSafe();
    }

    private static final DSL load$$anonfun$2(Compiled compiled$1, Seq args$1, Services services$2) {
        return compiled$1.eval(args$1, services$2);
    }

    public static class CompiledDSL {
        private final DSL dsl;
        private final CompilationContext compilationContext;
        private final Interpreter.RawCompiled raw;

        public CompiledDSL(DSL dsl, CompilationContext compilationContext, Interpreter.RawCompiled raw) {
            this.dsl = dsl;
            this.compilationContext = compilationContext;
            this.raw = raw;
        }

        public DSL dsl() {
            return this.dsl;
        }

        public CompilationContext compilationContext() {
            return this.compilationContext;
        }

        public Interpreter.RawCompiled raw() {
            return this.raw;
        }
    }
}

