/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import java.io.Serializable;
import scala.Char$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

public abstract class GenericSignatureVisitor {
    private final boolean nestedOnly;

    public GenericSignatureVisitor(boolean nestedOnly) {
        this.nestedOnly = nestedOnly;
    }

    public final void visitInternalName(String internalName) {
        this.visitInternalName(internalName, 0, internalName == null ? 0 : internalName.length());
    }

    public abstract void visitInternalName(String var1, int var2, int var3);

    public abstract void raiseError(String var1, String var2, Option<Throwable> var3);

    public Option<Throwable> raiseError$default$3() {
        return None$.MODULE$;
    }

    public void visitClassSignature(String sig) {
        if (sig != null) {
            Parser p = new Parser(this, sig, this.nestedOnly);
            p.safely((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                GenericSignatureVisitor.visitClassSignature$$anonfun$1(p);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void visitMethodSignature(String sig) {
        if (sig != null) {
            Parser p = new Parser(this, sig, this.nestedOnly);
            p.safely((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                GenericSignatureVisitor.visitMethodSignature$$anonfun$1(p);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void visitFieldSignature(String sig) {
        if (sig != null) {
            Parser p = new Parser(this, sig, this.nestedOnly);
            p.safely((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                GenericSignatureVisitor.visitFieldSignature$$anonfun$1(p);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void visitClassSignature$$anonfun$1(Parser p$1) {
        p$1.classSignature();
    }

    private static final void visitMethodSignature$$anonfun$1(Parser p$2) {
        p$2.methodSignature();
    }

    private static final void visitFieldSignature$$anonfun$1(Parser p$3) {
        p$3.fieldSignature();
    }

    public static final /* synthetic */ boolean dotty$tools$backend$jvm$GenericSignatureVisitor$Parser$$_$$lessinit$greater$$anonfun$1(char c) {
        return c == '<' || c == '.' || c == ';';
    }

    public interface CharBooleanFunction {
        public boolean apply(char var1);
    }

    public final class Parser {
        private final String sig;
        private final boolean nestedOnly;
        private int index;
        private final int end;
        private final Throwable Aborted;
        private final CharBooleanFunction isClassNameEnd;
        private final /* synthetic */ GenericSignatureVisitor $outer;

        public Parser(GenericSignatureVisitor $outer, String sig, boolean nestedOnly) {
            this.sig = sig;
            this.nestedOnly = nestedOnly;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.index = 0;
            this.end = sig.length();
            this.Aborted = (Throwable)((Object)new NoStackTrace(){
                {
                    NoStackTrace.$init$(this);
                }

                public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }
            });
            this.isClassNameEnd = GenericSignatureVisitor::dotty$tools$backend$jvm$GenericSignatureVisitor$Parser$$_$$lessinit$greater$$anonfun$1;
        }

        private Nothing$ abort() {
            throw this.Aborted;
        }

        public void safely(Function0<BoxedUnit> f) {
            block3: {
                try {
                    f.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = this.Aborted;
                    Throwable throwable4 = throwable2;
                    if (!(throwable3 == null ? throwable4 != null : !throwable3.equals(throwable4))) break block3;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable5;
                        Throwable e = throwable5 = option.get();
                        this.$outer.raiseError("Exception thrown during signature parsing", this.sig, Some$.MODULE$.apply(e));
                    }
                    throw throwable;
                }
            }
        }

        private char current() {
            if (this.index >= this.end) {
                this.$outer.raiseError(new StringBuilder(19).append("Out of bounds, ").append(this.index).append(" >= ").append(this.end).toString(), this.sig, this.$outer.raiseError$default$3());
                throw this.abort();
            }
            return this.sig.charAt(this.index);
        }

        private void accept(char c) {
            if (this.current() != c) {
                this.$outer.raiseError(new StringBuilder(21).append("Expected ").append(c).append(" at ").append(this.index).append(", found ").append(this.current()).toString(), this.sig, this.$outer.raiseError$default$3());
                throw this.abort();
            }
            ++this.index;
        }

        private void skip() {
            ++this.index;
        }

        private char getCurrentAndSkip() {
            char c = this.current();
            this.skip();
            return c;
        }

        private void skipUntil(CharBooleanFunction isDelimiter) {
            while (!isDelimiter.apply(this.current())) {
                ++this.index;
            }
        }

        private void skipUntilDelimiter(char delimiter) {
            int i;
            int n = this.sig.indexOf(Char$.MODULE$.char2int(delimiter), this.index);
            if (-1 == n) {
                this.$outer.raiseError("Out of bounds", this.sig, this.$outer.raiseError$default$3());
                throw this.abort();
            }
            this.index = i = n;
        }

        private void appendUntil(StringBuilder builder, CharBooleanFunction isDelimiter) {
            int start = this.index;
            this.skipUntil(isDelimiter);
            builder.append(this.sig, start, this.index);
        }

        public boolean isBaseType(char c) {
            char c2 = c;
            switch (c2) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return true;
                }
            }
            return false;
        }

        private void typeArguments() {
            if (this.current() == '<') {
                this.skip();
                block3: while (this.current() != '>') {
                    char c = this.current();
                    switch (c) {
                        case '*': 
                        case '+': 
                        case '-': {
                            this.skip();
                            continue block3;
                        }
                    }
                    this.referenceTypeSignature();
                }
                this.accept('>');
                return;
            }
        }

        private void referenceTypeSignature() {
            char c;
            block5: while (true) {
                c = this.getCurrentAndSkip();
                switch (c) {
                    case 'L': {
                        StringBuilder names = null;
                        int start = this.index;
                        boolean seenDollar = false;
                        while (!this.isClassNameEnd.apply(this.current())) {
                            seenDollar = seenDollar || this.current() == '$';
                            ++this.index;
                        }
                        if (this.current() == '.' || seenDollar || !this.nestedOnly) {
                            names = new StringBuilder(32);
                            names.append(this.sig, start, this.index);
                            this.$outer.visitInternalName(names.toString());
                        }
                        this.typeArguments();
                        while (this.current() == '.') {
                            this.skip();
                            names.append('$');
                            this.appendUntil(names, this.isClassNameEnd);
                            this.$outer.visitInternalName(names.toString());
                            this.typeArguments();
                        }
                        this.accept(';');
                        return;
                    }
                    case 'T': {
                        this.skipUntilDelimiter(';');
                        this.skip();
                        return;
                    }
                    case '[': {
                        if (!this.isBaseType(this.current())) continue block5;
                        this.skip();
                        return;
                    }
                }
                break;
            }
            throw new MatchError(BoxesRunTime.boxToCharacter(c));
        }

        private void typeParameters() {
            if (this.current() == '<') {
                this.skip();
                while (this.current() != '>') {
                    this.skipUntilDelimiter(':');
                    this.skip();
                    char c = this.current();
                    if (c != ':' && c != '>') {
                        this.referenceTypeSignature();
                    }
                    while (this.current() == ':') {
                        this.skip();
                        this.referenceTypeSignature();
                    }
                }
                this.accept('>');
                return;
            }
        }

        public void classSignature() {
            this.typeParameters();
            while (this.index < this.end) {
                this.referenceTypeSignature();
            }
        }

        public void methodSignature() {
            this.typeParameters();
            this.accept('(');
            while (this.current() != ')') {
                if (this.isBaseType(this.current())) {
                    this.skip();
                    continue;
                }
                this.referenceTypeSignature();
            }
            this.accept(')');
            if (this.current() == 'V' || this.isBaseType(this.current())) {
                this.skip();
            } else {
                this.referenceTypeSignature();
            }
            while (this.index < this.end) {
                this.accept('^');
                this.referenceTypeSignature();
            }
        }

        public void fieldSignature() {
            if (this.sig != null) {
                this.safely((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                    this.fieldSignature$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }

        public final /* synthetic */ GenericSignatureVisitor dotty$tools$backend$jvm$GenericSignatureVisitor$Parser$$$outer() {
            return this.$outer;
        }

        private final void fieldSignature$$anonfun$1() {
            this.referenceTypeSignature();
        }
    }
}

