/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import dotty.tools.backend.jvm.BTypes;
import dotty.tools.backend.jvm.BackendUtils;
import dotty.tools.backend.jvm.ClassfileWriters;
import dotty.tools.backend.jvm.GeneratedClass;
import dotty.tools.backend.jvm.GeneratedTasty;
import dotty.tools.backend.jvm.GeneratedTasty$;
import dotty.tools.backend.jvm.PostProcessorFrontendAccess;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.io.AbstractFile;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.tools.asm.ClassWriter;
import scala.tools.asm.Handle;
import scala.tools.asm.tree.ClassNode;
import scala.tools.asm.tree.InnerClassNode;

public class PostProcessor {
    private final PostProcessorFrontendAccess frontendAccess;
    private final BTypes bTypes;
    private final BackendUtils backendUtils;
    private final ClassfileWriters classfileWriters;
    private final ClassfileWriters.ClassfileWriter classfileWriter;
    private final ConcurrentHashMap<String, Tuple2<String, SourcePosition>> caseInsensitively;

    public PostProcessor(PostProcessorFrontendAccess frontendAccess, BTypes bTypes) {
        this.frontendAccess = frontendAccess;
        this.bTypes = bTypes;
        this.backendUtils = new BackendUtils(this);
        this.classfileWriters = new ClassfileWriters(frontendAccess);
        this.classfileWriter = this.classfileWriters().ClassfileWriter().apply();
        this.caseInsensitively = new ConcurrentHashMap();
    }

    public PostProcessorFrontendAccess frontendAccess() {
        return this.frontendAccess;
    }

    public BTypes bTypes() {
        return this.bTypes;
    }

    public BackendUtils backendUtils() {
        return this.backendUtils;
    }

    public ClassfileWriters classfileWriters() {
        return this.classfileWriters;
    }

    public ClassfileWriters.ClassfileWriter classfileWriter() {
        return this.classfileWriter;
    }

    public void sendToDisk(GeneratedClass clazz, AbstractFile sourceFile) {
        if (!this.frontendAccess().compilerSettings().outputOnlyTasty()) {
            byte[] bytes;
            byte[] byArray;
            ClassNode classNode = clazz.classNode();
            String x$proxy1 = classNode.name;
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String internalName = x$proxy1;
            try {
                if (!clazz.isArtifact()) {
                    this.setSerializableLambdas(classNode);
                }
                this.warnCaseInsensitiveOverwrite(clazz);
                this.setInnerClasses(classNode);
                byArray = this.serializeClass(classNode);
            }
            catch (Throwable throwable) {
                Object v1;
                RuntimeException e;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RuntimeException && (e = (RuntimeException)throwable2).getMessage() != null && e.getMessage().contains("too large!")) {
                    this.frontendAccess().backendReporting().error((Function1<Contexts.Context, Message> & Serializable)contextual$3 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Could not write class ", " because it exceeds JVM code size limits. ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(internalName), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(e.getMessage())}), (Contexts.Context)contextual$3));
                    v1 = null;
                } else if (throwable2 != null) {
                    Throwable ex = throwable2;
                    if (this.frontendAccess().compilerSettings().debug()) {
                        ex.printStackTrace();
                    }
                    this.frontendAccess().backendReporting().error((Function1<Contexts.Context, Message> & Serializable)contextual$4 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Error while emitting ", "\\n", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(internalName), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(ex.getMessage())}), (Contexts.Context)contextual$4));
                    v1 = null;
                } else {
                    throw throwable;
                }
                byArray = bytes = (byte[])v1;
            }
            if (bytes != null) {
                AbstractFile clsFile = this.classfileWriter().writeClass(internalName, bytes, sourceFile);
                clazz.onFileCreated().apply(clsFile);
                return;
            }
            return;
        }
    }

    public void sendToDisk(GeneratedTasty tasty, AbstractFile sourceFile) {
        GeneratedTasty generatedTasty = tasty;
        GeneratedTasty generatedTasty2 = GeneratedTasty$.MODULE$.unapply(generatedTasty);
        ClassNode classNode = generatedTasty2._1();
        Function0<byte[]> function0 = generatedTasty2._2();
        ClassNode classNode2 = classNode;
        Function0<byte[]> tastyGenerator = function0;
        Tuple2<ClassNode, Function0<byte[]>> tuple2 = Tuple2$.MODULE$.apply(classNode2, tastyGenerator);
        ClassNode classNode3 = tuple2._1();
        Function0<byte[]> tastyGenerator2 = tuple2._2();
        String x$proxy2 = classNode3.name;
        if (x$proxy2 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        String internalName = x$proxy2;
        String x$proxy3 = classNode3.name;
        if (x$proxy3 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        this.classfileWriter().writeTasty(x$proxy3, tastyGenerator2.apply(), sourceFile);
    }

    private void warnCaseInsensitiveOverwrite(GeneratedClass clazz) {
        SourcePosition clsPos;
        String name = clazz.classNode().name;
        String lowerCaseJavaName = name.toLowerCase();
        Tuple2<String, SourcePosition> tuple2 = this.caseInsensitively.putIfAbsent(lowerCaseJavaName, Tuple2$.MODULE$.apply(name, clsPos = clazz.position()));
        if (tuple2 == null) {
            return;
        }
        if (tuple2 != null) {
            String dupName = tuple2._1();
            SourcePosition dupPos = tuple2._2();
            Tuple2<Tuple2<SourcePosition, SourcePosition>, Tuple2<String, String>> tuple22 = StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(name), dupName) ? Tuple2$.MODULE$.apply(Tuple2$.MODULE$.apply(clsPos, dupPos), Tuple2$.MODULE$.apply(name, dupName)) : Tuple2$.MODULE$.apply(Tuple2$.MODULE$.apply(dupPos, clsPos), Tuple2$.MODULE$.apply(dupName, name));
            Tuple2<SourcePosition, SourcePosition> tuple23 = tuple22._1();
            Tuple2<String, String> tuple24 = tuple22._2();
            SourcePosition pos1 = tuple23._1();
            SourcePosition pos2 = tuple23._2();
            String name1 = tuple24._1();
            String name2 = tuple24._2();
            Tuple4<SourcePosition, SourcePosition, String, String> tuple4 = Tuple4$.MODULE$.apply(pos1, pos2, name1, name2);
            SourcePosition pos12 = tuple4._1();
            SourcePosition pos22 = tuple4._2();
            String name12 = tuple4._3();
            String name22 = tuple4._4();
            String string2 = pos12.source().path();
            String string3 = pos22.source().path();
            String locationAddendum = !(string2 != null ? !string2.equals(string3) : string3 != null) ? "" : new StringBuilder(14).append(" (defined in ").append(pos22.source().file().name()).append(")").toString();
            String string4 = name12;
            String string5 = name22;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.frontendAccess().backendReporting().error((Function1<Contexts.Context, Message> & Serializable)contextual$1 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"", " and ", " produce classes that overwrite one another"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(PostProcessor.nicify$1(name12)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(PostProcessor.nicify$1(name22))}), (Contexts.Context)contextual$1), pos12);
                return;
            }
            this.frontendAccess().backendReporting().warning((Function1<Contexts.Context, Message> & Serializable)contextual$2 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Generated class ", " differs only in case from ", "", ".\n                |  Such classes will overwrite one another on case-insensitive filesystems."})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(PostProcessor.nicify$1(name12)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(PostProcessor.nicify$1(name22)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(locationAddendum)}), (Contexts.Context)contextual$2), pos12);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void setSerializableLambdas(ClassNode classNode) {
        Object[] serializableLambdas = this.backendUtils().collectSerializableLambdas(classNode);
        Object object = Predef$.MODULE$.refArrayOps(serializableLambdas);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
            this.backendUtils().addLambdaDeserialize(classNode, (Handle[])serializableLambdas);
            return;
        }
    }

    private void setInnerClasses(ClassNode classNode) {
        java.util.List<InnerClassNode> x$proxy4 = classNode.innerClasses;
        if (x$proxy4 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        x$proxy4.clear();
        Tuple2<List<BTypes.ClassBType>, List<BTypes.ClassBType>> tuple2 = this.backendUtils().collectNestedClasses(classNode);
        List<BTypes.ClassBType> declared = tuple2._1();
        List<BTypes.ClassBType> referred = tuple2._2();
        Tuple2<List<BTypes.ClassBType>, List<BTypes.ClassBType>> tuple22 = Tuple2$.MODULE$.apply(declared, referred);
        List<BTypes.ClassBType> declared2 = tuple22._1();
        List<BTypes.ClassBType> referred2 = tuple22._2();
        this.backendUtils().addInnerClasses(classNode, declared2, referred2);
    }

    public byte[] serializeClass(ClassNode classNode) {
        ClassWriterWithBTypeLub cw = new ClassWriterWithBTypeLub(this.backendUtils().extraProc());
        classNode.accept(cw);
        byte[] x$proxy5 = cw.toByteArray();
        if (x$proxy5 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy5;
    }

    private static final String nicify$1(String name) {
        return name.replace('/', '.');
    }

    public final class ClassWriterWithBTypeLub
    extends ClassWriter {
        public ClassWriterWithBTypeLub(int flags) {
            if (PostProcessor.this == null) {
                throw new NullPointerException();
            }
            super(flags);
        }

        @Override
        public String getCommonSuperClass(String inameA, String inameB) {
            String lubName;
            BTypes.ClassBType a = PostProcessor.this.bTypes().classBTypeFromInternalName(inameA);
            BTypes.ClassBType b = PostProcessor.this.bTypes().classBTypeFromInternalName(inameB);
            BTypes.ClassBType lub = a.jvmWiseLUB(b);
            String string2 = lubName = lub.internalName();
            String string3 = "scala/Any";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return lubName;
        }

        public final /* synthetic */ PostProcessor dotty$tools$backend$jvm$PostProcessor$ClassWriterWithBTypeLub$$$outer() {
            return PostProcessor.this;
        }
    }
}

