/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.BinaryFileEntry;
import dotty.tools.dotc.classpath.ClassFileEntry;
import dotty.tools.dotc.classpath.ClassFileEntry$;
import dotty.tools.dotc.classpath.ClassPathEntries;
import dotty.tools.dotc.classpath.ClassPathEntries$;
import dotty.tools.dotc.classpath.NoSourcePaths;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.dotc.classpath.PackageNameUtils$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassPath$;
import dotty.tools.io.PlainFile;
import dotty.tools.io.PlainFile$;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class CtSymClassPath
implements ClassPath,
NoSourcePaths {
    private final String releaseCode;
    private final Map<String, Seq<Path>> packageIndex;

    public CtSymClassPath(Path ctSym, int release) {
        FileSystem fileSystem = FileSystems.newFileSystem(ctSym, null);
        Path root3 = fileSystem.getRootDirectories().iterator().next();
        List roots = CollectionConverters$.MODULE$.IteratorHasAsScala(Files.newDirectoryStream(root3).iterator()).asScala().toList();
        this.releaseCode = this.codeFor(release);
        Object rootsForRelease = roots.filter((Function1<Path, Boolean> & Serializable)root2 -> this.fileNameMatchesRelease(root2.getFileName().toString()));
        HashMap index = (HashMap)HashMap$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
        boolean isJava12OrHigher = Properties$.MODULE$.isJavaAtLeast("12");
        ((List)rootsForRelease).foreach(root2 -> CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(root2, new FileVisitOption[0]).iterator()).asScala().filter((Function1<Path, Boolean> & Serializable)_$3 -> Files.isDirectory(_$3, new LinkOption[0])).foreach(p -> {
            int moduleNamePathElementCount;
            int n = moduleNamePathElementCount = isJava12OrHigher ? 1 : 0;
            if (p.getNameCount() > root2.getNameCount() + moduleNamePathElementCount) {
                String packageDotted = p.subpath(moduleNamePathElementCount + root2.getNameCount(), p.getNameCount()).toString().replace('/', '.');
                ((Growable)index.getOrElseUpdate(packageDotted, CtSymClassPath::$init$$$anonfun$3$$anonfun$2$$anonfun$1)).$plus$eq(p);
                return;
            }
        }));
        this.packageIndex = index;
    }

    private String codeFor(int major) {
        if (major < 10) {
            return BoxesRunTime.boxToInteger(major).toString();
        }
        return BoxesRunTime.boxToCharacter((char)(65 + (major - 10))).toString();
    }

    private boolean fileNameMatchesRelease(String fileName) {
        return !fileName.contains("-") && fileName.contains(this.releaseCode);
    }

    @Override
    public boolean hasPackage(PackageName pkg) {
        return this.packageIndex.contains(pkg.dottedString());
    }

    @Override
    public scala.collection.immutable.Seq<PackageEntry> packages(PackageName inPackage) {
        return this.packageIndex.keysIterator().filter((Function1<String, Boolean> & Serializable)pack -> PackageNameUtils$.MODULE$.packageContains(inPackage.dottedString(), (String)pack)).map((Function1<String, PackageEntryImpl> & Serializable)_$4 -> PackageEntryImpl$.MODULE$.apply((String)_$4)).toVector();
    }

    @Override
    public scala.collection.immutable.Seq<BinaryFileEntry> classes(PackageName inPackage) {
        AbstractSeq abstractSeq;
        if (inPackage.isRoot()) {
            abstractSeq = package$.MODULE$.Nil();
        } else {
            Iterator sigFiles = ((IterableOnce)this.packageIndex.getOrElse(inPackage.dottedString(), CtSymClassPath::$anonfun$3)).iterator().flatMap((Function1<Path, IterableOnce> & Serializable)p -> CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(p).iterator()).asScala().filter((Function1<Path, Boolean> & Serializable)_$5 -> _$5.getFileName().toString().endsWith(".sig")));
            abstractSeq = sigFiles.map((Function1<Path, ClassFileEntry> & Serializable)f -> ClassFileEntry$.MODULE$.apply(PlainFile$.MODULE$.toPlainFile((Path)f))).toVector();
        }
        return abstractSeq;
    }

    @Override
    public ClassPathEntries list(PackageName inPackage) {
        if (inPackage.isRoot()) {
            return ClassPathEntries$.MODULE$.apply(this.packages(inPackage), package$.MODULE$.Nil());
        }
        return ClassPathEntries$.MODULE$.apply(this.packages(inPackage), this.classes(inPackage));
    }

    @Override
    public scala.collection.immutable.Seq<URL> asURLs() {
        return package$.MODULE$.Nil();
    }

    @Override
    public scala.collection.immutable.Seq<String> asClassPathStrings() {
        return package$.MODULE$.Nil();
    }

    @Override
    public Option<AbstractFile> findClassFile(String className) {
        Tuple2<String, String> tuple2;
        if (!className.contains(".")) {
            return None$.MODULE$;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            tuple2 = Tuple2$.MODULE$.apply(ClassPath$.MODULE$.RootPackage(), className);
        } else {
            String x$proxy3 = className.substring(0, lastDotIndex);
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String x$proxy4 = className.substring(lastDotIndex + 1);
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            tuple2 = Tuple2$.MODULE$.apply(x$proxy3, x$proxy4);
        }
        Tuple2<String, String> tuple22 = tuple2;
        String inPackage = tuple22._1();
        String classSimpleName = tuple22._2();
        Tuple2<String, String> tuple23 = Tuple2$.MODULE$.apply(inPackage, classSimpleName);
        String inPackage2 = tuple23._1();
        String classSimpleName2 = tuple23._2();
        return ((IterableOnce)this.packageIndex.getOrElse(inPackage2, CtSymClassPath::findClassFile$$anonfun$3)).iterator().flatMap((Function1<Path, IterableOnce> & Serializable)p -> {
            Path path2 = p.resolve(new StringBuilder(4).append(classSimpleName2).append(".sig").toString());
            if (Files.exists(path2, new LinkOption[0])) {
                PlainFile plainFile = PlainFile$.MODULE$.toPlainFile(path2);
                return package$.MODULE$.Nil().$colon$colon(plainFile);
            }
            return package$.MODULE$.Nil();
        }).take(1).toList().headOption();
    }

    private static final ListBuffer $init$$$anonfun$3$$anonfun$2$$anonfun$1() {
        return new ListBuffer();
    }

    private static final Seq $anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final Seq findClassFile$$anonfun$3() {
        return package$.MODULE$.Nil();
    }
}

