/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.core.NameKinds;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.NameKinds$SignedName$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.core.Signature;
import dotty.tools.dotc.core.Signature$;
import dotty.tools.dotc.core.tasty.CommonTastyHeader;
import dotty.tools.dotc.core.tasty.TastyUnpickler$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyBuffer$NameRef$;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHeaderUnpickler;
import dotty.tools.tasty.TastyReader;
import dotty.tools.tasty.TastyVersion;
import dotty.tools.tasty.UnpicklerConfig;
import dotty.tools.tasty.besteffort.BestEffortTastyHeaderUnpickler;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class TastyUnpickler {
    private final TastyReader reader;
    private final HashMap<String, TastyReader> sectionReader;
    private final NameTable nameAtRef;
    private final CommonTastyHeader header;

    public static UnpicklerConfig scala3CompilerConfig() {
        return TastyUnpickler$.MODULE$.scala3CompilerConfig();
    }

    public TastyUnpickler(TastyReader reader, boolean isBestEffortTasty) {
        this.reader = reader;
        this.sectionReader = new HashMap();
        this.nameAtRef = new NameTable();
        this.header = isBestEffortTasty ? new CommonTastyHeader(new BestEffortTastyHeaderUnpickler(TastyUnpickler$.MODULE$.scala3CompilerConfig(), reader).readFullHeader()) : new CommonTastyHeader(new TastyHeaderUnpickler(reader).readFullHeader());
        this.readNames();
        this.loadSections();
    }

    public TastyReader reader() {
        return this.reader;
    }

    public TastyUnpickler(byte[] bytes) {
        this(new TastyReader(bytes), false);
    }

    public TastyUnpickler(byte[] bytes, boolean isBestEffortTasty) {
        this(new TastyReader(bytes), isBestEffortTasty);
    }

    public NameTable nameAtRef() {
        return this.nameAtRef;
    }

    private Names.TermName readName() {
        return this.nameAtRef().apply(this.reader().readNameRef());
    }

    private String readString() {
        return this.readName().toString();
    }

    private Object readParamSig() {
        int ref = this.reader().readInt();
        if (ref < 0) {
            return BoxesRunTime.boxToInteger(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(ref)));
        }
        return this.nameAtRef().apply(TastyBuffer$NameRef$.MODULE$.apply(ref)).toTypeName();
    }

    private Names.TermName readNameContents() {
        Names.TermName termName;
        int tag = this.reader().readByte();
        int length = this.reader().readNat();
        int start = this.reader().currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        int n = tag;
        switch (n) {
            case 1: {
                this.reader().goto(end);
                termName = Names$.MODULE$.termName(this.bytes(), start, length);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                termName = NameKinds$.MODULE$.qualifiedNameKindOfTag().apply(BoxesRunTime.boxToInteger(tag)).apply(this.readName(), this.readName().asSimpleName());
                break;
            }
            case 10: {
                String separator = this.readName().toString();
                int num = this.reader().readNat();
                List originals = this.reader().until(end, this::$anonfun$2);
                Names.TermName original = originals.isEmpty() ? Names$.MODULE$.EmptyTermName() : (Names.TermName)originals.head();
                termName = ((NameKinds.NumberedNameKind)NameKinds$.MODULE$.uniqueNameKindOfSeparator().apply(separator)).apply(original, num);
                break;
            }
            case 11: {
                termName = NameKinds$.MODULE$.numberedNameKindOfTag().apply(BoxesRunTime.boxToInteger(tag)).apply(this.readName(), this.reader().readNat());
                break;
            }
            case 63: {
                Names.TermName original = this.readName();
                termName = this.readSignedRest$1(end, original, original);
                break;
            }
            case 62: {
                Names.TermName original = this.readName();
                Names.TermName target = this.readName();
                termName = this.readSignedRest$1(end, original, target);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                termName = NameKinds$.MODULE$.simpleNameKindOfTag().apply(BoxesRunTime.boxToInteger(tag)).apply(this.readName());
                break;
            }
            default: {
                throw new MatchError((Object)new StringBuilder(17).append("unknown name tag ").append(TastyFormat$.MODULE$.nameTagToString(tag)).toString());
            }
        }
        Names.TermName result = termName;
        if (!TastyBuffer$Addr$.MODULE$.$eq$eq$extension(this.reader().currentAddr(), end)) {
            throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(12).append("bad name ").append(result).append(" ").append(new TastyBuffer.Addr(start)).append(" ").append(new TastyBuffer.Addr(this.reader().currentAddr())).append(" ").append(new TastyBuffer.Addr(end)).toString());
        }
        return result;
    }

    public CommonTastyHeader header() {
        return this.header;
    }

    public void readNames() {
        this.reader().until(this.reader().readEnd(), this::readNames$$anonfun$1);
    }

    public void loadSections() {
        while (!this.reader().isAtEnd()) {
            String secName = this.readString();
            int secEnd = this.reader().readEnd();
            this.sectionReader.update(secName, new TastyReader(this.bytes(), this.reader().currentAddr(), secEnd, this.reader().currentAddr()));
            this.reader().goto(secEnd);
        }
    }

    public <R> Option<R> unpickle(SectionUnpickler<R> sec) {
        return this.sectionReader.get(sec.name()).map((Function1<TastyReader, Object> & Serializable)reader -> sec.unpickle((TastyReader)reader, this.nameAtRef()));
    }

    public byte[] bytes() {
        return this.reader().bytes();
    }

    private final Object $anonfun$1() {
        return this.readParamSig();
    }

    private final Names.TermName readSignedRest$1(int end$1, Names.TermName original, Names.TermName target) {
        Names.TypeName result = this.readName().toTypeName();
        List<Object> paramsSig = this.reader().until(end$1, this::$anonfun$1);
        Signature sig = Signature$.MODULE$.apply(paramsSig, result);
        return NameKinds$SignedName$.MODULE$.apply(original, sig, target);
    }

    private final Names.TermName $anonfun$2() {
        return this.readName();
    }

    private final ArrayBuffer readNames$$anonfun$1() {
        return this.nameAtRef().add(this.readNameContents());
    }

    public static class NameTable
    implements Function1<TastyBuffer.NameRef, Names.TermName> {
        private final ArrayBuffer<Names.TermName> names = new ArrayBuffer();

        public ArrayBuffer<Names.TermName> add(Names.TermName name) {
            return (ArrayBuffer)this.names.$plus$eq(name);
        }

        @Override
        public Names.TermName apply(int ref) {
            return this.names.apply(ref);
        }

        public Iterable<Names.TermName> contents() {
            return this.names;
        }
    }

    public static interface Scala3CompilerConfig
    extends UnpicklerConfig {
        private String asScala3Compiler(TastyVersion version) {
            if (version.major() == 28) {
                if (version.experimental() > 0) {
                    return new StringBuilder(46).append("the same nightly or snapshot Scala 3.").append(version.minor() - 1).append(" compiler").toString();
                }
                return new StringBuilder(30).append("a Scala 3.").append(version.minor()).append(".0 compiler or newer").toString();
            }
            if (version.experimental() > 0) {
                return "the same Scala compiler";
            }
            return "a more recent Scala compiler";
        }

        public static String upgradedReaderTool$(Scala3CompilerConfig $this, TastyVersion version) {
            return $this.upgradedReaderTool(version);
        }

        @Override
        default public String upgradedReaderTool(TastyVersion version) {
            return this.asScala3Compiler(version);
        }

        public static String upgradedProducerTool$(Scala3CompilerConfig $this, TastyVersion version) {
            return $this.upgradedProducerTool(version);
        }

        @Override
        default public String upgradedProducerTool(TastyVersion version) {
            return this.asScala3Compiler(version);
        }

        public static String recompileAdditionalInfo$(Scala3CompilerConfig $this) {
            return $this.recompileAdditionalInfo();
        }

        @Override
        default public String recompileAdditionalInfo() {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |  Usually this means that the library dependency containing this file should be updated."));
        }

        public static String upgradeAdditionalInfo$(Scala3CompilerConfig $this, TastyVersion fileVersion) {
            return $this.upgradeAdditionalInfo(fileVersion);
        }

        @Override
        default public String upgradeAdditionalInfo(TastyVersion fileVersion) {
            if (fileVersion.isExperimental() && this.experimentalVersion() == 0) {
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |  Note that you are using a stable compiler, which can not read experimental TASTy."));
            }
            return "";
        }
    }

    public static abstract class SectionUnpickler<R> {
        private final String name;

        public SectionUnpickler(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract R unpickle(TastyReader var1, NameTable var2);
    }
}

