/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.coverage;

import dotty.tools.dotc.coverage.Coverage;
import dotty.tools.dotc.coverage.Statement;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Serializer$
implements Serializable {
    private static final String CoverageFileName;
    private static final String CoverageDataFormatVersion;
    public static final Serializer$ MODULE$;

    private Serializer$() {
    }

    static {
        MODULE$ = new Serializer$();
        CoverageFileName = "scoverage.coverage";
        CoverageDataFormatVersion = "3.0";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serializer$.class);
    }

    public void serialize(Coverage coverage, String dataDir, String sourceRoot) {
        this.serialize(coverage, Paths.get(dataDir, CoverageFileName).toAbsolutePath(), Paths.get(sourceRoot, new String[0]).toAbsolutePath());
    }

    public void serialize(Coverage coverage, Path file, Path sourceRoot) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.serialize(coverage, writer, sourceRoot);
        }
    }

    public void serialize(Coverage coverage, Writer writer, Path sourceRoot) {
        this.writeHeader$1(writer);
        ((IterableOnceOps)coverage.statements().toSeq().sortBy((Function1<Statement, Integer> & Serializable)_$1 -> _$1.id(), Ordering$Int$.MODULE$)).foreach(stmt -> this.writeStatement$1(sourceRoot, (Statement)stmt, writer));
    }

    public String escaped(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\\\");
                    continue block6;
                }
                case '\n': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\n");
                    continue block6;
                }
                case '\r': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\r");
                    continue block6;
                }
                case '\f': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\f");
                    continue block6;
                }
                default: {
                    char c2 = c;
                    StringBuilder stringBuilder = (StringBuilder)builder.$plus$eq(BoxesRunTime.boxToCharacter(c2));
                    continue block6;
                }
            }
        }
        return builder.result();
    }

    private final String getRelativePath$1(Path sourceRoot$1, Path filePath) {
        Path relPath = sourceRoot$1.normalize().relativize(filePath);
        return relPath.toString();
    }

    private final void writeHeader$1(Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(864).append("# Coverage data, format version: ").append(CoverageDataFormatVersion).append("\n                      |# Statement data:\n                      |# - id\n                      |# - source path\n                      |# - package name\n                      |# - class name\n                      |# - class type (Class, Object or Trait)\n                      |# - full class name\n                      |# - method name\n                      |# - start offset\n                      |# - end offset\n                      |# - line number\n                      |# - symbol name\n                      |# - tree name\n                      |# - is branch\n                      |# - invocations count\n                      |# - is ignored\n                      |# - description (can be multi-line)\n                      |# '\f' sign\n                      |# ------------------------------------------\n                      |").toString())));
    }

    private final void writeStatement$1(Path sourceRoot$3, Statement stmt, Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(410).append(stmt.id()).append("\n                      |").append(this.escaped(this.getRelativePath$1(sourceRoot$3, stmt.location().sourcePath()))).append("\n                      |").append(this.escaped(stmt.location().packageName())).append("\n                      |").append(this.escaped(stmt.location().className())).append("\n                      |").append(stmt.location().classType()).append("\n                      |").append(this.escaped(stmt.location().fullClassName())).append("\n                      |").append(this.escaped(stmt.location().methodName())).append("\n                      |").append(stmt.start()).append("\n                      |").append(stmt.end()).append("\n                      |").append(stmt.line()).append("\n                      |").append(this.escaped(stmt.symbolName())).append("\n                      |").append(stmt.treeName()).append("\n                      |").append(stmt.branch()).append("\n                      |0\n                      |").append(stmt.ignored()).append("\n                      |").append(this.escaped(stmt.desc())).append("\n                      |\f\n                      |").toString())));
    }
}

