/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.ParamInfo;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.SyntaxMsg;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class WrongNumberOfTypeArgs
extends SyntaxMsg {
    private final Types.Type fntpe;
    private final List<ParamInfo> expectedArgs;
    private final List<Trees.Tree<Types.Type>> actual;
    private final int expectedCount;
    private final int actualCount;
    private final String msgPrefix;

    public WrongNumberOfTypeArgs(Types.Type fntpe, List<ParamInfo> expectedArgs, List<Trees.Tree<Types.Type>> actual, Contexts.Context x$4) {
        this.fntpe = fntpe;
        this.expectedArgs = expectedArgs;
        this.actual = actual;
        super(ErrorMessageID$.WrongNumberOfTypeArgsID, x$4);
        this.expectedCount = expectedArgs.length();
        this.actualCount = actual.length();
        this.msgPrefix = this.actualCount > this.expectedCount ? "Too many" : "Not enough";
    }

    @Override
    public String msg(Contexts.Context x$1) {
        String string2;
        String expectedArgString = ((AbstractIterable)this.expectedArgs.map((Function1<ParamInfo, String> & Serializable)_$4 -> NameOps$.MODULE$.unexpandedName(_$4.paramName(x$1)).show(x$1))).mkString("[", ", ", "]");
        String actualArgString = ((AbstractIterable)this.actual.map((Function1<Trees.Tree, String> & Serializable)_$5 -> _$5.show(x$1))).mkString("[", ", ", "]");
        try {
            Symbols.Symbol symbol = this.fntpe.termSymbol(x$1);
            if (Symbols$NoSymbol$.MODULE$.equals(symbol)) {
                string2 = this.fntpe.show(x$1);
            } else {
                Symbols.Symbol symbol2 = symbol;
                string2 = symbol2.showFullName(x$1);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                string2 = this.fntpe.show(x$1);
            }
            throw throwable;
        }
        String prettyName = string2;
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"|", " type arguments for ", "", "\n        |expected: ", "\n        |actual:   ", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(this.msgPrefix), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(prettyName), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(expectedArgString), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(expectedArgString), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(actualArgString)}), x$1);
    }

    @Override
    public String explain(Contexts.Context x$1) {
        String tooManyTypeParams = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|val tuple2: (Int, String) = (1, \"one\")\n          |val list: List[(Int, String)] = List(tuple2)"));
        if (this.actualCount > this.expectedCount) {
            return Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"|You have supplied too many type parameters\n          |\n          |For example List takes a single type parameter (List[A])\n          |If you need to hold more types in a list then you need to combine them\n          |into another data type that can contain the number of types you need,\n          |In this example one solution would be to use a Tuple:\n          |\n          |", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(tooManyTypeParams)}), x$1);
        }
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"|You have not supplied enough type parameters\n          |If you specify one type parameter then you need to specify every type parameter."})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]), x$1);
    }
}

