/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.File;
import dotty.tools.io.File$;
import dotty.tools.io.Jar;
import dotty.tools.io.Jar$;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.PatternSyntaxException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class ClassPath$
implements Serializable {
    private static final String RootPackage;
    public static final ClassPath$ MODULE$;

    private ClassPath$() {
    }

    static {
        MODULE$ = new ClassPath$();
        RootPackage = "";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClassPath$.class);
    }

    public String RootPackage() {
        return RootPackage;
    }

    private List<String> expandS(String pattern) {
        String wildSuffix = new StringBuilder(1).append(File$.MODULE$.separator()).append("*").toString();
        String string2 = pattern;
        String string3 = "*";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.lsDir$1(Directory$.MODULE$.apply("."), this.lsDir$default$2$1());
        }
        if (pattern.endsWith(wildSuffix) || pattern.endsWith("/*")) {
            return this.lsDir$1(Directory$.MODULE$.apply(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(pattern), 2)), this.lsDir$default$2$1());
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(pattern), '*')) {
            List list;
            try {
                Regex regexp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(pattern.replace("\\*", ".*")).append("$").toString()));
                list = this.lsDir$1(Directory$.MODULE$.apply(pattern).parent(), (Function1<String, Boolean> & Serializable)_$5 -> regexp.findFirstIn((CharSequence)_$5).isDefined());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                list = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)pattern), Nil$.MODULE$));
            }
            return list;
        }
        return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)pattern), Nil$.MODULE$));
    }

    public List<String> split(String path2) {
        return (List)((AbstractSeq)Predef$.MODULE$.wrapRefArray(path2.split(File$.MODULE$.pathSeparator())).toList().filterNot((Function1<String, Boolean> & Serializable)_$6 -> {
            String string2 = _$6;
            String string3 = "";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        })).distinct();
    }

    public String join(Seq<String> paths) {
        return ((IterableOnceOps)paths.filterNot((Function1<String, Boolean> & Serializable)_$7 -> {
            String string2 = _$7;
            String string3 = "";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        })).mkString(File$.MODULE$.pathSeparator());
    }

    public String map(String cp, Function1<String, String> f) {
        return this.join((Seq<String>)this.split(cp).map(f));
    }

    public List<String> expandPath(String path2, boolean expandStar) {
        if (expandStar) {
            return this.split(path2).flatMap((Function1<String, IterableOnce> & Serializable)pattern -> MODULE$.expandS((String)pattern));
        }
        return this.split(path2);
    }

    public boolean expandPath$default$2() {
        return true;
    }

    public List<String> expandDir(String extdir) {
        AbstractFile abstractFile = AbstractFile$.MODULE$.getDirectory(extdir);
        if (abstractFile == null) {
            return package$.MODULE$.Nil();
        }
        AbstractFile dir = abstractFile;
        return ((IterableOnceOps)((IterableOps)dir.filter((Function1<AbstractFile, Boolean> & Serializable)_$8 -> _$8.isClassContainer())).map((Function1<AbstractFile, String> & Serializable)x -> new java.io.File(dir.file(), x.name()).getPath())).toList();
    }

    public List<URL> expandManifestPath(String jarPath) {
        File file = File$.MODULE$.apply(jarPath, Codec$.MODULE$.fallbackSystemCodec());
        if (!file.isFile()) {
            return package$.MODULE$.Nil();
        }
        Directory baseDir = file.parent();
        return new Jar(file).classPathElements().map((Function1<String, URL> & Serializable)elem -> (URL)MODULE$.specToURL((String)elem, baseDir).getOrElse(() -> ClassPath$.expandManifestPath$$anonfun$1$$anonfun$1(baseDir, elem)));
    }

    public Option<URL> specToURL(String spec, Directory basedir) {
        Option option;
        try {
            URI uri = new URI(spec);
            option = uri.isAbsolute() ? Some$.MODULE$.apply(uri.toURL()) : Some$.MODULE$.apply(basedir.resolve(Path$.MODULE$.apply(spec)).toURL());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof MalformedURLException || throwable2 instanceof URISyntaxException) {
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public List<URL> manifests() {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(resources).asScala().filter((Function1<URL, Object>)(Function1<URL, Boolean> & Serializable)_$9 -> {
            String string2 = _$9.getProtocol();
            String string3 = "jar";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).toList();
    }

    private final List lsDir$1(Directory dir, Function1 filt) {
        return dir.list().filter((Function1<Path, Object>)(Function1<Path, Boolean> & Serializable)x -> BoxesRunTime.unboxToBoolean(filt.apply(x.name())) && (x.isDirectory() || Jar$.MODULE$.isJarOrZip((Path)x))).map((Function1<Path, String> & Serializable)_$4 -> _$4.path()).toList();
    }

    private final Function1 lsDir$default$2$1() {
        return (Function1<String, Boolean> & Serializable)_$3 -> true;
    }

    private static final URL expandManifestPath$$anonfun$1$$anonfun$1(Directory baseDir$2, String elem$1) {
        return baseDir$2.$div(elem$1).toURL();
    }
}

