/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.backend.jvm.PostProcessorFrontendAccess;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SrcPos;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.FileWriters$;
import dotty.tools.io.FileWriters$BufferingReporter$Report$;
import dotty.tools.io.FileWriters$FileConflictException$;
import dotty.tools.io.FileWriters$FileWriter$;
import dotty.tools.io.FileWriters$ReadOnlyContext$;
import dotty.tools.io.FileWriters$TastyWriter$;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Properties$;
import scala.util.matching.Regex;

public final class FileWriters {

    public static interface BufferedReadOnlyContext
    extends ReadOnlyContext {
        @Override
        public BufferingReporter reporter();
    }

    public static final class BufferingReporter
    implements DelayedReporter {
        private final AtomicReference<List<Report>> _bufferedReports;
        private final AtomicBoolean _hasErrors;
        public final FileWriters$BufferingReporter$Report$ Report$lzy1 = new FileWriters$BufferingReporter$Report$(this);

        public BufferingReporter() {
            this._bufferedReports = new AtomicReference<Object>(package$.MODULE$.List().empty());
            this._hasErrors = new AtomicBoolean(false);
        }

        public final FileWriters$BufferingReporter$Report$ Report() {
            return this.Report$lzy1;
        }

        private void recordError() {
            this._hasErrors.set(true);
        }

        private void recordReport(Report report2) {
            this._bufferedReports.getAndUpdate(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$BufferingReporter$$_$recordReport$$anonfun$1(report2, arg_0));
        }

        private List<Report> resetReports() {
            List<Report> curr = this._bufferedReports.get();
            if (curr.nonEmpty() && !this._bufferedReports.compareAndSet(curr, package$.MODULE$.Nil())) {
                throw new ConcurrentModificationException("concurrent modification of buffered reports");
            }
            return curr;
        }

        @Override
        public boolean hasErrors() {
            return this._hasErrors.get();
        }

        public boolean hasReports() {
            return ((IterableOnceOps)this._bufferedReports.get()).nonEmpty();
        }

        @Override
        public void error(Function1<Contexts.Context, Message> message, SourcePosition position) {
            this.recordReport(this.Report().Error().apply(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$BufferingReporter$$_$error$$anonfun$1(message, arg_0), position));
            this.recordError();
        }

        @Override
        public void warning(Function1<Contexts.Context, Message> message, SourcePosition position) {
            this.recordReport(this.Report().Warning().apply(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$BufferingReporter$$_$warning$$anonfun$1(message, arg_0), position));
        }

        @Override
        public void log(String message) {
            this.recordReport(this.Report().Log().apply(message));
        }

        public void relayReports(PostProcessorFrontendAccess.BackendReporting toReporting, Contexts.Context x$2) {
            List<Report> reports = this.resetReports();
            if (reports.nonEmpty()) {
                ((List)reports.reverse()).foreach(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$BufferingReporter$$_$relayReports$$anonfun$1(x$2, toReporting, arg_0));
                return;
            }
        }

        public abstract class Report
        implements Product,
        Enum {
            private final Function1<Contexts.Context, Function1<PostProcessorFrontendAccess.BackendReporting, BoxedUnit>> relay;
            private final /* synthetic */ BufferingReporter $outer;

            public Report(Function1<Contexts.Context, Function1<PostProcessorFrontendAccess.BackendReporting, BoxedUnit>> function1) {
                this.relay = (Function1<Contexts.Context, Function1<PostProcessorFrontendAccess.BackendReporting, BoxedUnit>>)relay;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Function1<Contexts.Context, Function1<PostProcessorFrontendAccess.BackendReporting, BoxedUnit>> relay() {
                return this.relay;
            }

            public final /* synthetic */ BufferingReporter dotty$tools$io$FileWriters$BufferingReporter$Report$$$outer() {
                return this.$outer;
            }
        }
    }

    public static interface DelayedReporter {
        public boolean hasErrors();

        public void error(Function1<Contexts.Context, Message> var1, SourcePosition var2);

        public void warning(Function1<Contexts.Context, Message> var1, SourcePosition var2);

        public void log(String var1);

        public static Option toBuffered$(DelayedReporter $this) {
            return $this.toBuffered();
        }

        default public Option<BufferingReporter> toBuffered() {
            DelayedReporter delayedReporter = this;
            if (delayedReporter instanceof BufferingReporter) {
                BufferingReporter buffered = (BufferingReporter)delayedReporter;
                if (buffered.hasReports()) {
                    return Some$.MODULE$.apply(buffered);
                }
                return None$.MODULE$;
            }
            if (delayedReporter instanceof EagerReporter) {
                return None$.MODULE$;
            }
            throw new MatchError(delayedReporter);
        }

        public static void error$(DelayedReporter $this, Function1 message) {
            $this.error(message);
        }

        default public void error(Function1<Contexts.Context, Message> message) {
            this.error(message, NoSourcePosition$.MODULE$);
        }

        public static void warning$(DelayedReporter $this, Function1 message) {
            $this.warning(message);
        }

        default public void warning(Function1<Contexts.Context, Message> message) {
            this.warning(message, NoSourcePosition$.MODULE$);
        }

        public static void exception$(DelayedReporter $this, Function1 reason, Throwable throwable) {
            $this.exception(reason, throwable);
        }

        default public void exception(Function1<Contexts.Context, Message> reason, Throwable throwable) {
            this.error(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$DelayedReporter$$_$exception$$anonfun$1(throwable, reason, arg_0), NoSourcePosition$.MODULE$);
        }
    }

    public static final class DirEntryWriter
    implements FileWriter {
        private final Path base;
        private final ConcurrentHashMap<Path, Boolean> builtPaths;
        private final FileAttribute<?>[] noAttributes;
        private final boolean isWindows;
        private final EnumSet fastOpenOptions;
        private final EnumSet fallbackOpenOptions;

        public DirEntryWriter(Path base) {
            this.base = base;
            this.builtPaths = new ConcurrentHashMap();
            this.noAttributes = (FileAttribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileAttribute.class));
            this.isWindows = Properties$.MODULE$.isWin();
            this.fastOpenOptions = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.fallbackOpenOptions = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }

        public ConcurrentHashMap<Path, Boolean> builtPaths() {
            return this.builtPaths;
        }

        public FileAttribute<?>[] noAttributes() {
            return this.noAttributes;
        }

        private void checkName(Path component, ReadOnlyContext x$2) {
            if (this.isWindows) {
                Regex specials = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9]"));
                String name = component.toString();
                specials.findPrefixOf(name).foreach(prefix -> {
                    if (prefix.length() == name.length() || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), prefix.length()) == '.') {
                        this.warnSpecial$1(x$2, name);
                        return;
                    }
                });
                return;
            }
        }

        public void ensureDirForPath(Path baseDir, Path filePath, ReadOnlyContext x$3) {
            Path parent = filePath.getParent();
            if (!this.builtPaths().containsKey(parent)) {
                Object object;
                parent.iterator().forEachRemaining(component -> this.checkName((Path)component, x$3));
                try {
                    object = Files.createDirectories(parent, this.noAttributes());
                }
                catch (FileAlreadyExistsException e) {
                    if (!Files.isDirectory(parent, new LinkOption[0])) {
                        throw new FileConflictException(new StringBuilder(78).append("Can't create directory ").append(parent).append("; there is an existing (non-directory) file in its path").toString(), e);
                    }
                    object = BoxedUnit.UNIT;
                }
                this.builtPaths().put(baseDir, Boolean.TRUE);
                for (Path current = parent; current != null && !(null == this.builtPaths().put(current, Boolean.TRUE)); current = current.getParent()) {
                }
            }
            this.checkName(filePath.getFileName(), x$3);
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, ReadOnlyContext x$3) {
            FileChannel fileChannel;
            Path path2 = this.base.resolve(relativePath);
            this.ensureDirForPath(this.base, path2, x$3);
            if (this.isWindows) {
                try {
                    fileChannel = FileChannel.open(path2, this.fastOpenOptions, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    fileChannel = FileChannel.open(path2, this.fallbackOpenOptions, new FileAttribute[0]);
                }
            } else {
                fileChannel = FileChannel.open(path2, this.fallbackOpenOptions, new FileAttribute[0]);
            }
            FileChannel os = fileChannel;
            try {
                os.write(ByteBuffer.wrap(bytes), 0L);
            }
            catch (ClosedByInterruptException ex) {
                Serializable serializable;
                try {
                    serializable = BoxesRunTime.boxToBoolean(Files.deleteIfExists(path2));
                }
                catch (Throwable throwable) {
                    serializable = BoxedUnit.UNIT;
                }
                throw ex;
            }
            try {
                os.close();
            }
            catch (FileConflictException e) {
                x$3.reporter().error(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$DirEntryWriter$$_$writeFile$$anonfun$1(path2, e, arg_0));
            }
            catch (FileSystemException e) {
                if (x$3.settings().debug()) {
                    e.printStackTrace();
                }
                x$3.reporter().error(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$DirEntryWriter$$_$writeFile$$anonfun$2(path2, e, arg_0));
            }
            return AbstractFile$.MODULE$.getFile(path2);
        }

        @Override
        public void close() {
        }

        private final void warnSpecial$1(ReadOnlyContext x$2$2, String name$1) {
            x$2$2.reporter().warning(arg_0 -> FileWriters$.dotty$tools$io$FileWriters$DirEntryWriter$$_$warnSpecial$1$$anonfun$1(name$1, arg_0));
        }
    }

    public static final class EagerReporter
    implements DelayedReporter {
        private final Contexts.Context captured;
        private boolean _hasErrors;

        public EagerReporter(Contexts.Context captured) {
            this.captured = captured;
            this._hasErrors = false;
        }

        @Override
        public boolean hasErrors() {
            return this._hasErrors;
        }

        @Override
        public void error(Function1<Contexts.Context, Message> message, SourcePosition position) {
            report$.MODULE$.error(message.apply(this.captured), (SrcPos)position, this.captured);
            this._hasErrors = true;
        }

        @Override
        public void warning(Function1<Contexts.Context, Message> message, SourcePosition position) {
            report$.MODULE$.warning(message.apply(this.captured), (SrcPos)position, this.captured);
        }

        @Override
        public void log(String message) {
            report$.MODULE$.echo(() -> FileWriters$.dotty$tools$io$FileWriters$EagerReporter$$_$log$$anonfun$1(message), report$.MODULE$.echo$default$2(), this.captured);
        }
    }

    public static class FileConflictException
    extends IOException {
        public static Throwable $lessinit$greater$default$2() {
            return FileWriters$FileConflictException$.MODULE$.$lessinit$greater$default$2();
        }

        public FileConflictException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface FileWriter {
        public static FileWriter apply(AbstractFile abstractFile, Option<String> option, ReadOnlyContext readOnlyContext) {
            return FileWriters$FileWriter$.MODULE$.apply(abstractFile, option, readOnlyContext);
        }

        public AbstractFile writeFile(String var1, byte[] var2, ReadOnlyContext var3);

        public void close();
    }

    public static final class JarEntryWriter
    implements FileWriter {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JarEntryWriter.class.getDeclaredField("crc$lzy1"));
        private final boolean storeOnly;
        private final JarOutputStream jarWriter;
        private volatile Object crc$lzy1;

        public JarEntryWriter(AbstractFile file, Option<String> mainClass, int compressionLevel) {
            this.storeOnly = compressionLevel == 0;
            Manifest manifest = new Manifest();
            Attributes attrs = manifest.getMainAttributes();
            attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attrs.put(Properties$.MODULE$.ScalaCompilerVersion(), Properties$.MODULE$.versionNumberString());
            mainClass.foreach((Function1<String, Object> & Serializable)c -> attrs.put(Attributes.Name.MAIN_CLASS, c));
            JarOutputStream jar = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file.file()), 64000), manifest);
            jar.setLevel(compressionLevel);
            if (this.storeOnly()) {
                jar.setMethod(0);
            }
            this.jarWriter = jar;
        }

        public boolean storeOnly() {
            return this.storeOnly;
        }

        public JarOutputStream jarWriter() {
            return this.jarWriter;
        }

        public CRC32 crc() {
            Object object = this.crc$lzy1;
            if (object instanceof CRC32) {
                return (CRC32)object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (CRC32)this.crc$lzyINIT1();
        }

        private Object crc$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.crc$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        CRC32 cRC32 = null;
                        try {
                            cRC32 = new CRC32();
                            object2 = cRC32 == null ? LazyVals$NullValue$.MODULE$ : cRC32;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.crc$lzy1;
                                LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return cRC32;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, ReadOnlyContext x$3) {
            AbstractFile abstractFile;
            JarEntryWriter jarEntryWriter = this;
            synchronized (jarEntryWriter) {
                ZipEntry entry = new ZipEntry(relativePath);
                if (this.storeOnly()) {
                    entry.setSize(Int$.MODULE$.int2long(bytes.length));
                    this.crc().reset();
                    this.crc().update(bytes);
                    entry.setCrc(this.crc().getValue());
                }
                this.jarWriter().putNextEntry(entry);
                try {
                    this.jarWriter().write(bytes, 0, bytes.length);
                }
                finally {
                    this.jarWriter().flush();
                }
                abstractFile = null;
            }
            return abstractFile;
        }

        @Override
        public void close() {
            JarEntryWriter jarEntryWriter = this;
            synchronized (jarEntryWriter) {
                this.jarWriter().close();
            }
        }
    }

    public static interface ReadOnlyContext {
        public static BufferedReadOnlyContext buffered(Contexts.Context context) {
            return FileWriters$ReadOnlyContext$.MODULE$.buffered(context);
        }

        public static ReadOnlyContext eager(Contexts.Context context) {
            return FileWriters$ReadOnlyContext$.MODULE$.eager(context);
        }

        public static ReadOnlyRun readRun(Contexts.Context context) {
            return FileWriters$ReadOnlyContext$.MODULE$.readRun(context);
        }

        public static ReadOnlySettings readSettings(Contexts.Context context) {
            return FileWriters$ReadOnlyContext$.MODULE$.readSettings(context);
        }

        public ReadOnlyRun run();

        public ReadOnlySettings settings();

        public DelayedReporter reporter();
    }

    public static interface ReadOnlyRun {
        public boolean suspendedAtTyperPhase();
    }

    public static interface ReadOnlySettings {
        public int jarCompressionLevel();

        public boolean debug();
    }

    public static interface TastyWriter {
        public static TastyWriter apply(AbstractFile abstractFile, ReadOnlyContext readOnlyContext) {
            return FileWriters$TastyWriter$.MODULE$.apply(abstractFile, readOnlyContext);
        }

        public AbstractFile writeTasty(String var1, byte[] var2, ReadOnlyContext var3);

        public void close();

        public static String classToRelativePath$(TastyWriter $this, String className) {
            return $this.classToRelativePath(className);
        }

        default public String classToRelativePath(String className) {
            return new StringBuilder(6).append(className.replace('.', '/')).append(".tasty").toString();
        }
    }

    public static final class VirtualFileWriter
    implements FileWriter {
        private final AbstractFile base;

        public VirtualFileWriter(AbstractFile base) {
            this.base = base;
        }

        private AbstractFile getFile(AbstractFile base, String path2) {
            Object[] components = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(path2), '/');
            ObjectRef<AbstractFile> dir = ObjectRef.create(base);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), components.length - 1).foreach(arg_0 -> this.getFile$$anonfun$1(dir, (String[])components, base, path2, arg_0));
            Object object = Predef$.MODULE$.refArrayOps(components);
            return this.ensureDirectory$1(base, path2, (AbstractFile)dir.elem).fileNamed(((String)ArrayOps$.MODULE$.last$extension(object)).toString());
        }

        private void writeBytes(AbstractFile outFile, byte[] bytes) {
            try (DataOutputStream out = new DataOutputStream(outFile.bufferedOutput());){
                out.write(bytes, 0, bytes.length);
            }
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, ReadOnlyContext x$3) {
            AbstractFile outFile = this.getFile(this.base, relativePath);
            this.writeBytes(outFile, bytes);
            return outFile;
        }

        @Override
        public void close() {
        }

        private final AbstractFile ensureDirectory$1(AbstractFile base$1, String path$3, AbstractFile dir) {
            if (dir.isDirectory()) {
                return dir;
            }
            throw new FileConflictException(new StringBuilder(22).append(base$1.path()).append("/").append(path$3).append(": ").append(dir.path()).append(" is not a directory").toString(), FileWriters$FileConflictException$.MODULE$.$lessinit$greater$default$2());
        }

        private final /* synthetic */ void getFile$$anonfun$1(ObjectRef dir$1, String[] components$1, AbstractFile base$2, String path$4, int i) {
            dir$1.elem = this.ensureDirectory$1(base$2, path$4, (AbstractFile)dir$1.elem).subdirectoryNamed(components$1[i].toString());
        }
    }
}

