/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.sjs.ir;

import dotty.tools.sjs.ir.IRVersionNotSupportedException;
import dotty.tools.sjs.ir.VersionChecks$;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;

public class VersionChecks {
    private final String current;
    private final String binaryEmitted;
    private final int binaryMajor;
    private final int binaryMinor;
    private final Option<String> binaryPreRelease;
    private final String binaryCross;
    private final ConcurrentHashMap.KeySetView knownSupportedBinary;

    public VersionChecks(String current, String binaryEmitted) {
        this.current = current;
        this.binaryEmitted = binaryEmitted;
        VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$checkConsistent(current, binaryEmitted);
        Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$parseBinary(binaryEmitted);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int binaryMajor = BoxesRunTime.unboxToInt(tuple3._1());
        int binaryMinor = BoxesRunTime.unboxToInt(tuple3._2());
        Option<String> binaryPreRelease = tuple3._3();
        Tuple3<Integer, Integer, Option<String>> tuple32 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(binaryMajor), BoxesRunTime.boxToInteger(binaryMinor), binaryPreRelease);
        this.binaryMajor = BoxesRunTime.unboxToInt(tuple32._1());
        this.binaryMinor = BoxesRunTime.unboxToInt(tuple32._2());
        this.binaryPreRelease = tuple32._3();
        boolean needsFull = this.binaryPreRelease.isDefined() && this.binaryMinor == 0;
        this.binaryCross = needsFull ? binaryEmitted : BoxesRunTime.boxToInteger(this.binaryMajor).toString();
        ConcurrentHashMap.KeySetView<String, Boolean> m = ConcurrentHashMap.newKeySet();
        m.add(binaryEmitted);
        this.knownSupportedBinary = m;
    }

    public final String current() {
        return this.current;
    }

    public final String binaryEmitted() {
        return this.binaryEmitted;
    }

    public final String binaryCross() {
        return this.binaryCross;
    }

    public final void checkSupported(String version) {
        if (!this.knownSupportedBinary.contains(version)) {
            boolean supported;
            Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$parseBinary(version);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int major = BoxesRunTime.unboxToInt(tuple3._1());
            int minor = BoxesRunTime.unboxToInt(tuple3._2());
            Option<String> preRelease = tuple3._3();
            Tuple3<Integer, Integer, Option<String>> tuple32 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(major), BoxesRunTime.boxToInteger(minor), preRelease);
            int major2 = BoxesRunTime.unboxToInt(tuple32._1());
            int minor2 = BoxesRunTime.unboxToInt(tuple32._2());
            Option<String> preRelease2 = tuple32._3();
            boolean bl = supported = preRelease2.isEmpty() && major2 == this.binaryMajor && minor2 <= this.binaryMinor && (this.binaryPreRelease.isEmpty() || minor2 < this.binaryMinor);
            if (supported) {
                this.knownSupportedBinary.add(version);
                return;
            }
            throw new IRVersionNotSupportedException(version, this.binaryEmitted(), new StringBuilder(49).append("This version (").append(version).append(") of Scala.js IR is not supported. ").append(new StringBuilder(29).append("Supported versions are up to ").append(this.binaryEmitted()).toString()).toString());
        }
    }
}

