/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Hashing$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.OldHashMap;
import scala.collection.immutable.OldHashMap$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.parallel.BucketCombiner;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.Task;
import scala.collection.parallel.immutable.HashMapCombiner$;
import scala.collection.parallel.immutable.ParHashMap;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class HashMapCombiner<K, V>
extends BucketCombiner<Tuple2<K, V>, ParHashMap<K, V>, Tuple2<K, V>, HashMapCombiner<K, V>> {
    private final OldHashMap emptyTrie = OldHashMap$.MODULE$.empty();

    public static <K, V> HashMapCombiner<K, V> apply() {
        return HashMapCombiner$.MODULE$.apply();
    }

    public static int rootbits() {
        return HashMapCombiner$.MODULE$.rootbits();
    }

    public static int rootsize() {
        return HashMapCombiner$.MODULE$.rootsize();
    }

    public HashMapCombiner() {
        super(HashMapCombiner$.MODULE$.rootsize());
    }

    public OldHashMap<K, V> emptyTrie() {
        return this.emptyTrie;
    }

    public HashMapCombiner addOne(Tuple2<K, V> elem) {
        this.sz_$eq(this.sz() + 1);
        int hc = Hashing$.MODULE$.computeHash(elem._1());
        int pos = hc & 0x1F;
        if (this.buckets()[pos] == null) {
            this.buckets()[pos] = new UnrolledBuffer(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        this.buckets()[pos].$plus$eq(elem);
        return this;
    }

    @Override
    public ParHashMap<K, V> result() {
        ParHashMap parHashMap;
        Object object = Predef$.MODULE$.refArrayOps(this.buckets());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1<UnrolledBuffer, boolean> & Serializable)_$1 -> _$1 != null));
        UnrolledBuffer.Unrolled[] bucks = (UnrolledBuffer.Unrolled[])ArrayOps$.MODULE$.map$extension(object2, (Function1<UnrolledBuffer, UnrolledBuffer.Unrolled> & Serializable)_$2 -> _$2.headPtr(), ClassTag$.MODULE$.apply(UnrolledBuffer.Unrolled.class));
        Object[] root2 = new OldHashMap[bucks.length];
        this.combinerTaskSupport().executeAndWaitResult(new CreateTrie(this, bucks, (OldHashMap<K, V>[])root2, 0, bucks.length));
        int bitmap = 0;
        for (int i = 0; i < HashMapCombiner$.MODULE$.rootsize(); ++i) {
            if (this.buckets()[i] == null) continue;
            bitmap |= 1 << i;
        }
        Object object3 = Predef$.MODULE$.refArrayOps(root2);
        int sz = BoxesRunTime.unboxToInt(ArrayOps$.MODULE$.foldLeft$extension(object3, BoxesRunTime.boxToInteger(0), (Function2<Object, Object, int> & Serializable)(_$3, _$4) -> HashMapCombiner.$anonfun$6(BoxesRunTime.unboxToInt(_$3), (OldHashMap)_$4)));
        if (sz == 0) {
            parHashMap = new ParHashMap();
        } else if (sz == 1) {
            parHashMap = new ParHashMap(root2[0]);
        } else {
            OldHashMap.HashTrieMap trie = new OldHashMap.HashTrieMap(bitmap, (OldHashMap<K, V>[])root2, sz);
            parHashMap = new ParHashMap(trie);
        }
        return parHashMap;
    }

    public <Repr> ParHashMap<K, Repr> groupByKey(Function0<Combiner<V, Repr>> cbf) {
        ParHashMap parHashMap;
        Object object = Predef$.MODULE$.refArrayOps(this.buckets());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1<UnrolledBuffer, boolean> & Serializable)_$5 -> _$5 != null));
        UnrolledBuffer.Unrolled[] bucks = (UnrolledBuffer.Unrolled[])ArrayOps$.MODULE$.map$extension(object2, (Function1<UnrolledBuffer, UnrolledBuffer.Unrolled> & Serializable)_$6 -> _$6.headPtr(), ClassTag$.MODULE$.apply(UnrolledBuffer.Unrolled.class));
        Object[] root2 = new OldHashMap[bucks.length];
        this.combinerTaskSupport().executeAndWaitResult(new CreateGroupedTrie<Repr>(this, cbf, bucks, (OldHashMap<K, Object>[])root2, 0, bucks.length));
        int bitmap = 0;
        for (int i = 0; i < HashMapCombiner$.MODULE$.rootsize(); ++i) {
            if (this.buckets()[i] == null) continue;
            bitmap |= 1 << i;
        }
        Object object3 = Predef$.MODULE$.refArrayOps(root2);
        int sz = BoxesRunTime.unboxToInt(ArrayOps$.MODULE$.foldLeft$extension(object3, BoxesRunTime.boxToInteger(0), (Function2<Object, Object, int> & Serializable)(_$7, _$8) -> HashMapCombiner.$anonfun$7(BoxesRunTime.unboxToInt(_$7), (OldHashMap)_$8)));
        if (sz == 0) {
            parHashMap = new ParHashMap();
        } else if (sz == 1) {
            parHashMap = new ParHashMap(root2[0]);
        } else {
            OldHashMap.HashTrieMap trie = new OldHashMap.HashTrieMap(bitmap, (OldHashMap<K, V>[])root2, sz);
            parHashMap = new ParHashMap(trie);
        }
        return parHashMap;
    }

    public String toString() {
        return "HashTrieCombiner(sz: " + this.size() + ")";
    }

    private static final /* synthetic */ int $anonfun$6(int _$3, OldHashMap _$4) {
        return _$3 + _$4.size();
    }

    private static final /* synthetic */ int $anonfun$7(int _$7, OldHashMap _$8) {
        return _$7 + _$8.size();
    }

    public static final /* synthetic */ Tuple2 scala$collection$parallel$immutable$HashMapCombiner$CreateGroupedTrie$$_$_$$anonfun$5(Tuple2 p) {
        return Tuple2$.MODULE$.apply(p._1(), ((Builder)p._2()).result());
    }

    public class CreateGroupedTrie<Repr>
    implements Task<BoxedUnit, CreateGroupedTrie<Repr>> {
        private volatile Throwable throwable;
        private final Function0<Combiner<V, Repr>> cbf;
        private final UnrolledBuffer.Unrolled<Tuple2<K, V>>[] bucks;
        private final OldHashMap<K, Object>[] root;
        private final int offset;
        private final int howmany;
        private volatile BoxedUnit result;
        private final HashMapCombiner<K, V> $outer;

        public CreateGroupedTrie(HashMapCombiner $outer, Function0<Combiner<V, Repr>> cbf, UnrolledBuffer.Unrolled<Tuple2<K, V>>[] bucks, OldHashMap<K, Object>[] root2, int offset, int howmany) {
            this.cbf = cbf;
            this.bucks = bucks;
            this.root = root2;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            this.result = BoxedUnit.UNIT;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public BoxedUnit result() {
            return this.result;
        }

        @Override
        public void result_$eq(BoxedUnit x$1) {
            this.result = x$1;
        }

        @Override
        public void leaf(Option<BoxedUnit> prev) {
            int until = this.offset + this.howmany;
            for (int i = this.offset; i < until; ++i) {
                this.root[i] = this.createGroupedTrie(this.bucks[i]);
            }
            this.result_$eq(this.result());
        }

        private OldHashMap<K, Repr> createGroupedTrie(UnrolledBuffer.Unrolled<Tuple2<K, V>> elems) {
            OldHashMap trie = OldHashMap$.MODULE$.empty();
            int i = 0;
            for (UnrolledBuffer.Unrolled unrolled = elems; unrolled != null; unrolled = unrolled.next()) {
                Tuple2[] chunkarr = (Tuple2[])unrolled.array();
                int chunksz = unrolled.size();
                while (i < chunksz) {
                    Combiner combiner;
                    Tuple2 kv = chunkarr[i];
                    int hc = Hashing$.MODULE$.computeHash(kv._1());
                    Option option = trie.get0(kv._1(), hc, HashMapCombiner$.MODULE$.rootbits());
                    if (option instanceof Some) {
                        Combiner cmb;
                        combiner = cmb = (Combiner)((Some)option).value();
                    } else if (None$.MODULE$.equals(option)) {
                        Combiner cmb = this.cbf.apply();
                        trie = trie.updated0(kv._1(), hc, HashMapCombiner$.MODULE$.rootbits(), cmb, null, null);
                        combiner = cmb;
                    } else {
                        throw new MatchError(option);
                    }
                    Combiner cmb = combiner;
                    cmb.$plus$eq(kv._2());
                    ++i;
                }
                i = 0;
            }
            return this.evaluateCombiners(trie);
        }

        private OldHashMap<K, Repr> evaluateCombiners(OldHashMap<K, Combiner<V, Repr>> trie) {
            OldHashMap oldHashMap;
            OldHashMap.OldHashMap1 oldHashMap1 = trie;
            if (oldHashMap1 instanceof OldHashMap.OldHashMap1) {
                OldHashMap.OldHashMap1 hm1 = oldHashMap1;
                Object evaledvalue = ((Builder)hm1.value()).result();
                oldHashMap = new OldHashMap.OldHashMap1(hm1.key(), hm1.hash(), evaledvalue, null);
            } else if (oldHashMap1 instanceof OldHashMap.OldHashMapCollision1) {
                OldHashMap.OldHashMapCollision1 hmc = (OldHashMap.OldHashMapCollision1)((Object)oldHashMap1);
                ListMap evaledkvs = (ListMap)hmc.kvs().map(HashMapCombiner::scala$collection$parallel$immutable$HashMapCombiner$CreateGroupedTrie$$_$_$$anonfun$5);
                oldHashMap = new OldHashMap.OldHashMapCollision1(hmc.hash(), evaledkvs);
            } else if (oldHashMap1 instanceof OldHashMap.HashTrieMap) {
                OldHashMap.HashTrieMap htm = (OldHashMap.HashTrieMap)((Object)oldHashMap1);
                for (int i = 0; i < htm.elems().length; ++i) {
                    htm.elems()[i] = this.evaluateCombiners(htm.elems()[i]);
                }
                oldHashMap = htm;
            } else {
                OldHashMap.OldHashMap1 empty;
                oldHashMap = empty = oldHashMap1;
            }
            return oldHashMap;
        }

        @Override
        public Seq<Task<BoxedUnit, CreateGroupedTrie<Repr>>> split() {
            int fp = this.howmany / 2;
            return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CreateGroupedTrie[]{new CreateGroupedTrie<Repr>(this.$outer, this.cbf, this.bucks, this.root, this.offset, fp), new CreateGroupedTrie<Repr>(this.$outer, this.cbf, this.bucks, this.root, this.offset + fp, this.howmany - fp)}));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(this.root.length, this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final HashMapCombiner<K, V> scala$collection$parallel$immutable$HashMapCombiner$CreateGroupedTrie$$$outer() {
            return this.$outer;
        }
    }

    public class CreateTrie
    implements Task<BoxedUnit, CreateTrie> {
        private volatile Throwable throwable;
        private final UnrolledBuffer.Unrolled<Tuple2<K, V>>[] bucks;
        private final OldHashMap<K, V>[] root;
        private final int offset;
        private final int howmany;
        private volatile BoxedUnit result;
        private final HashMapCombiner<K, V> $outer;

        public CreateTrie(HashMapCombiner $outer, UnrolledBuffer.Unrolled<Tuple2<K, V>>[] bucks, OldHashMap<K, V>[] root2, int offset, int howmany) {
            this.bucks = bucks;
            this.root = root2;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            this.result = BoxedUnit.UNIT;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public BoxedUnit result() {
            return this.result;
        }

        @Override
        public void result_$eq(BoxedUnit x$1) {
            this.result = x$1;
        }

        @Override
        public void leaf(Option<BoxedUnit> prev) {
            int until = this.offset + this.howmany;
            for (int i = this.offset; i < until; ++i) {
                this.root[i] = this.createTrie(this.bucks[i]);
            }
            this.result_$eq(this.result());
        }

        /*
         * WARNING - void declaration
         */
        private OldHashMap<K, V> createTrie(UnrolledBuffer.Unrolled<Tuple2<K, V>> elems) {
            void var2_2;
            OldHashMap trie = OldHashMap$.MODULE$.empty();
            int i = 0;
            for (UnrolledBuffer.Unrolled unrolled = elems; unrolled != null; unrolled = unrolled.next()) {
                Tuple2[] chunkarr = (Tuple2[])unrolled.array();
                int chunksz = unrolled.size();
                while (i < chunksz) {
                    Tuple2 kv = chunkarr[i];
                    int hc = Hashing$.MODULE$.computeHash(kv._1());
                    trie = trie.updated0(kv._1(), hc, HashMapCombiner$.MODULE$.rootbits(), kv._2(), kv, null);
                    ++i;
                }
                i = 0;
            }
            return var2_2;
        }

        @Override
        public Seq<Task<BoxedUnit, CreateTrie>> split() {
            int fp = this.howmany / 2;
            return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CreateTrie[]{new CreateTrie(this.$outer, this.bucks, this.root, this.offset, fp), new CreateTrie(this.$outer, this.bucks, this.root, this.offset + fp, this.howmany - fp)}));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(this.root.length, this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final HashMapCombiner<K, V> scala$collection$parallel$immutable$HashMapCombiner$CreateTrie$$$outer() {
            return this.$outer;
        }
    }
}

