/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.io.Serializable;
import xsbti.api.AnalyzedClass;
import xsbti.api.DependencyContext;

public final class ExternalDependency
implements Serializable {
    private String sourceClassName;
    private String targetProductClassName;
    private AnalyzedClass targetClass;
    private DependencyContext context;

    public static ExternalDependency create(String string2, String string3, AnalyzedClass analyzedClass, DependencyContext dependencyContext) {
        return new ExternalDependency(string2, string3, analyzedClass, dependencyContext);
    }

    public static ExternalDependency of(String string2, String string3, AnalyzedClass analyzedClass, DependencyContext dependencyContext) {
        return new ExternalDependency(string2, string3, analyzedClass, dependencyContext);
    }

    protected ExternalDependency(String string2, String string3, AnalyzedClass analyzedClass, DependencyContext dependencyContext) {
        this.sourceClassName = string2;
        this.targetProductClassName = string3;
        this.targetClass = analyzedClass;
        this.context = dependencyContext;
    }

    public String sourceClassName() {
        return this.sourceClassName;
    }

    public String targetProductClassName() {
        return this.targetProductClassName;
    }

    public AnalyzedClass targetClass() {
        return this.targetClass;
    }

    public DependencyContext context() {
        return this.context;
    }

    public ExternalDependency withSourceClassName(String string2) {
        return new ExternalDependency(string2, this.targetProductClassName, this.targetClass, this.context);
    }

    public ExternalDependency withTargetProductClassName(String string2) {
        return new ExternalDependency(this.sourceClassName, string2, this.targetClass, this.context);
    }

    public ExternalDependency withTargetClass(AnalyzedClass analyzedClass) {
        return new ExternalDependency(this.sourceClassName, this.targetProductClassName, analyzedClass, this.context);
    }

    public ExternalDependency withContext(DependencyContext dependencyContext) {
        return new ExternalDependency(this.sourceClassName, this.targetProductClassName, this.targetClass, dependencyContext);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExternalDependency)) {
            return false;
        }
        ExternalDependency externalDependency = (ExternalDependency)object;
        return this.sourceClassName().equals(externalDependency.sourceClassName()) && this.targetProductClassName().equals(externalDependency.targetProductClassName()) && this.targetClass().equals(externalDependency.targetClass()) && this.context().equals((Object)externalDependency.context());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (17 + "xsbti.api.ExternalDependency".hashCode()) + this.sourceClassName().hashCode()) + this.targetProductClassName().hashCode()) + this.targetClass().hashCode()) + this.context().hashCode());
    }

    public String toString() {
        return "ExternalDependency(sourceClassName: " + this.sourceClassName() + ", targetProductClassName: " + this.targetProductClassName() + ", targetClass: " + this.targetClass() + ", context: " + (Object)((Object)this.context()) + ")";
    }
}

