/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.ClassFileFormatException;
import de.unkrig.jdisasm.OperandKind;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class BytecodeDecoder<R, EX extends Throwable> {
    @NotNullByDefault(value=false)
    public R decode(DataInputStream dis) throws IOException, EX {
        int opcode = dis.read();
        switch (opcode) {
            case -1: {
                return this.decoded("end", new OperandKind[0]);
            }
            case 50: {
                return this.decoded("aaload", new OperandKind[0]);
            }
            case 83: {
                return this.decoded("aastore", new OperandKind[0]);
            }
            case 1: {
                return this.decoded("aconst_null", new OperandKind[0]);
            }
            case 25: {
                return this.decoded("aload", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 42: {
                return this.decoded("aload_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 43: {
                return this.decoded("aload_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 44: {
                return this.decoded("aload_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 45: {
                return this.decoded("aload_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 189: {
                return this.decoded("anewarray", OperandKind.CLASS2);
            }
            case 176: {
                return this.decoded("areturn", new OperandKind[0]);
            }
            case 190: {
                return this.decoded("arraylength", new OperandKind[0]);
            }
            case 58: {
                return this.decoded("astore", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 75: {
                return this.decoded("astore_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 76: {
                return this.decoded("astore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 77: {
                return this.decoded("astore_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 78: {
                return this.decoded("astore_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 191: {
                return this.decoded("athrow", new OperandKind[0]);
            }
            case 51: {
                return this.decoded("baload", new OperandKind[0]);
            }
            case 84: {
                return this.decoded("bastore", new OperandKind[0]);
            }
            case 16: {
                return this.decoded("bipush", OperandKind.SIGNEDBYTE);
            }
            case 52: {
                return this.decoded("caload", new OperandKind[0]);
            }
            case 85: {
                return this.decoded("castore", new OperandKind[0]);
            }
            case 192: {
                return this.decoded("checkcast", OperandKind.CLASS2);
            }
            case 144: {
                return this.decoded("d2f", new OperandKind[0]);
            }
            case 142: {
                return this.decoded("d2i", new OperandKind[0]);
            }
            case 143: {
                return this.decoded("d2l", new OperandKind[0]);
            }
            case 99: {
                return this.decoded("dadd", new OperandKind[0]);
            }
            case 49: {
                return this.decoded("daload", new OperandKind[0]);
            }
            case 82: {
                return this.decoded("dastore", new OperandKind[0]);
            }
            case 152: {
                return this.decoded("dcmpg", new OperandKind[0]);
            }
            case 151: {
                return this.decoded("dcmpl", new OperandKind[0]);
            }
            case 14: {
                return this.decoded("dconst_0", new OperandKind[0]);
            }
            case 15: {
                return this.decoded("dconst_1", new OperandKind[0]);
            }
            case 111: {
                return this.decoded("ddiv", new OperandKind[0]);
            }
            case 24: {
                return this.decoded("dload", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 38: {
                return this.decoded("dload_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 39: {
                return this.decoded("dload_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 40: {
                return this.decoded("dload_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 41: {
                return this.decoded("dload_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 107: {
                return this.decoded("dmul", new OperandKind[0]);
            }
            case 119: {
                return this.decoded("dneg", new OperandKind[0]);
            }
            case 115: {
                return this.decoded("drem", new OperandKind[0]);
            }
            case 175: {
                return this.decoded("dreturn", new OperandKind[0]);
            }
            case 57: {
                return this.decoded("dstore", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 71: {
                return this.decoded("dstore_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 72: {
                return this.decoded("dstore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 73: {
                return this.decoded("dstore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 74: {
                return this.decoded("dstore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 103: {
                return this.decoded("dsub", new OperandKind[0]);
            }
            case 89: {
                return this.decoded("dup", new OperandKind[0]);
            }
            case 90: {
                return this.decoded("dup_x1", new OperandKind[0]);
            }
            case 91: {
                return this.decoded("dup_x2", new OperandKind[0]);
            }
            case 92: {
                return this.decoded("dup2", new OperandKind[0]);
            }
            case 93: {
                return this.decoded("dup2_x1", new OperandKind[0]);
            }
            case 94: {
                return this.decoded("dup2_x2", new OperandKind[0]);
            }
            case 141: {
                return this.decoded("f2d", new OperandKind[0]);
            }
            case 139: {
                return this.decoded("f2i", new OperandKind[0]);
            }
            case 140: {
                return this.decoded("f2l", new OperandKind[0]);
            }
            case 98: {
                return this.decoded("fadd", new OperandKind[0]);
            }
            case 48: {
                return this.decoded("faload", new OperandKind[0]);
            }
            case 81: {
                return this.decoded("fastore", new OperandKind[0]);
            }
            case 150: {
                return this.decoded("fcmpg", new OperandKind[0]);
            }
            case 149: {
                return this.decoded("fcmpl", new OperandKind[0]);
            }
            case 11: {
                return this.decoded("fconst_0", new OperandKind[0]);
            }
            case 12: {
                return this.decoded("fconst_1", new OperandKind[0]);
            }
            case 13: {
                return this.decoded("fconst_2", new OperandKind[0]);
            }
            case 110: {
                return this.decoded("fdiv", new OperandKind[0]);
            }
            case 23: {
                return this.decoded("fload", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 34: {
                return this.decoded("fload_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 35: {
                return this.decoded("fload_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 36: {
                return this.decoded("fload_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 37: {
                return this.decoded("fload_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 106: {
                return this.decoded("fmul", new OperandKind[0]);
            }
            case 118: {
                return this.decoded("fneg", new OperandKind[0]);
            }
            case 114: {
                return this.decoded("frem", new OperandKind[0]);
            }
            case 174: {
                return this.decoded("freturn", new OperandKind[0]);
            }
            case 56: {
                return this.decoded("fstore", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 67: {
                return this.decoded("fstore_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 68: {
                return this.decoded("fstore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 69: {
                return this.decoded("fstore_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 70: {
                return this.decoded("fstore_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 102: {
                return this.decoded("fsub", new OperandKind[0]);
            }
            case 180: {
                return this.decoded("getfield", OperandKind.FIELDREF2);
            }
            case 178: {
                return this.decoded("getstatic", OperandKind.FIELDREF2);
            }
            case 167: {
                return this.decoded("goto", OperandKind.BRANCHOFFSET2);
            }
            case 200: {
                return this.decoded("goto_w", OperandKind.BRANCHOFFSET4);
            }
            case 145: {
                return this.decoded("i2b", new OperandKind[0]);
            }
            case 146: {
                return this.decoded("i2c", new OperandKind[0]);
            }
            case 135: {
                return this.decoded("i2d", new OperandKind[0]);
            }
            case 134: {
                return this.decoded("i2f", new OperandKind[0]);
            }
            case 133: {
                return this.decoded("i2l", new OperandKind[0]);
            }
            case 147: {
                return this.decoded("i2s", new OperandKind[0]);
            }
            case 96: {
                return this.decoded("iadd", new OperandKind[0]);
            }
            case 46: {
                return this.decoded("iaload", new OperandKind[0]);
            }
            case 126: {
                return this.decoded("iand", new OperandKind[0]);
            }
            case 79: {
                return this.decoded("iastore", new OperandKind[0]);
            }
            case 2: {
                return this.decoded("iconst_m1", new OperandKind[0]);
            }
            case 3: {
                return this.decoded("iconst_0", new OperandKind[0]);
            }
            case 4: {
                return this.decoded("iconst_1", new OperandKind[0]);
            }
            case 5: {
                return this.decoded("iconst_2", new OperandKind[0]);
            }
            case 6: {
                return this.decoded("iconst_3", new OperandKind[0]);
            }
            case 7: {
                return this.decoded("iconst_4", new OperandKind[0]);
            }
            case 8: {
                return this.decoded("iconst_5", new OperandKind[0]);
            }
            case 108: {
                return this.decoded("idiv", new OperandKind[0]);
            }
            case 165: {
                return this.decoded("if_acmpeq", OperandKind.BRANCHOFFSET2);
            }
            case 166: {
                return this.decoded("if_acmpne", OperandKind.BRANCHOFFSET2);
            }
            case 159: {
                return this.decoded("if_icmpeq", OperandKind.BRANCHOFFSET2);
            }
            case 160: {
                return this.decoded("if_icmpne", OperandKind.BRANCHOFFSET2);
            }
            case 161: {
                return this.decoded("if_icmplt", OperandKind.BRANCHOFFSET2);
            }
            case 162: {
                return this.decoded("if_icmpge", OperandKind.BRANCHOFFSET2);
            }
            case 163: {
                return this.decoded("if_icmpgt", OperandKind.BRANCHOFFSET2);
            }
            case 164: {
                return this.decoded("if_icmple", OperandKind.BRANCHOFFSET2);
            }
            case 153: {
                return this.decoded("ifeq", OperandKind.BRANCHOFFSET2);
            }
            case 154: {
                return this.decoded("ifne", OperandKind.BRANCHOFFSET2);
            }
            case 155: {
                return this.decoded("iflt", OperandKind.BRANCHOFFSET2);
            }
            case 156: {
                return this.decoded("ifge", OperandKind.BRANCHOFFSET2);
            }
            case 157: {
                return this.decoded("ifgt", OperandKind.BRANCHOFFSET2);
            }
            case 158: {
                return this.decoded("ifle", OperandKind.BRANCHOFFSET2);
            }
            case 199: {
                return this.decoded("ifnonnull", OperandKind.BRANCHOFFSET2);
            }
            case 198: {
                return this.decoded("ifnull", OperandKind.BRANCHOFFSET2);
            }
            case 132: {
                return this.decoded("iinc", OperandKind.LOCALVARIABLEINDEX1, OperandKind.SIGNEDBYTE);
            }
            case 21: {
                return this.decoded("iload", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 26: {
                return this.decoded("iload_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 27: {
                return this.decoded("iload_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 28: {
                return this.decoded("iload_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 29: {
                return this.decoded("iload_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 104: {
                return this.decoded("imul", new OperandKind[0]);
            }
            case 116: {
                return this.decoded("ineg", new OperandKind[0]);
            }
            case 193: {
                return this.decoded("instanceof", OperandKind.CLASS2);
            }
            case 186: {
                return this.decoded("invokedynamic", OperandKind.DYNAMICCALLSITE);
            }
            case 185: {
                return this.decoded("invokeinterface", OperandKind.INTERFACEMETHODREF2);
            }
            case 183: {
                return this.decoded("invokespecial", OperandKind.INTERFACEMETHODREFORMETHODREF2);
            }
            case 184: {
                return this.decoded("invokestatic", OperandKind.INTERFACEMETHODREFORMETHODREF2);
            }
            case 182: {
                return this.decoded("invokevirtual", OperandKind.METHODREF2);
            }
            case 128: {
                return this.decoded("ior", new OperandKind[0]);
            }
            case 112: {
                return this.decoded("irem", new OperandKind[0]);
            }
            case 172: {
                return this.decoded("ireturn", new OperandKind[0]);
            }
            case 120: {
                return this.decoded("ishl", new OperandKind[0]);
            }
            case 122: {
                return this.decoded("ishr", new OperandKind[0]);
            }
            case 54: {
                return this.decoded("istore", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 59: {
                return this.decoded("istore_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 60: {
                return this.decoded("istore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 61: {
                return this.decoded("istore_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 62: {
                return this.decoded("istore_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 100: {
                return this.decoded("isub", new OperandKind[0]);
            }
            case 124: {
                return this.decoded("iushr", new OperandKind[0]);
            }
            case 130: {
                return this.decoded("ixor", new OperandKind[0]);
            }
            case 168: {
                return this.decoded("jsr", OperandKind.BRANCHOFFSET2);
            }
            case 201: {
                return this.decoded("jsr_w", OperandKind.BRANCHOFFSET4);
            }
            case 138: {
                return this.decoded("l2d", new OperandKind[0]);
            }
            case 137: {
                return this.decoded("l2f", new OperandKind[0]);
            }
            case 136: {
                return this.decoded("l2i", new OperandKind[0]);
            }
            case 97: {
                return this.decoded("ladd", new OperandKind[0]);
            }
            case 47: {
                return this.decoded("laload", new OperandKind[0]);
            }
            case 127: {
                return this.decoded("land", new OperandKind[0]);
            }
            case 80: {
                return this.decoded("lastore", new OperandKind[0]);
            }
            case 148: {
                return this.decoded("lcmp", new OperandKind[0]);
            }
            case 9: {
                return this.decoded("lconst_0", new OperandKind[0]);
            }
            case 10: {
                return this.decoded("lconst_1", new OperandKind[0]);
            }
            case 18: {
                return this.decoded("ldc", OperandKind.CLASSFLOATINTSTRINGMETHODHANDLEMETHODTYPEDYNAMIC);
            }
            case 19: {
                return this.decoded("ldc_w", OperandKind.CLASSFLOATINTSTRINGMETHODHANDLEMETHODTYPEDYNAMIC_W);
            }
            case 20: {
                return this.decoded("ldc2_w", OperandKind.DOUBLELONGDYNAMIC_W);
            }
            case 22: {
                return this.decoded("lload", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 30: {
                return this.decoded("lload_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 31: {
                return this.decoded("lload_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 32: {
                return this.decoded("lload_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 33: {
                return this.decoded("lload_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 105: {
                return this.decoded("lmul", new OperandKind[0]);
            }
            case 117: {
                return this.decoded("lneg", new OperandKind[0]);
            }
            case 171: {
                return this.decoded("lookupswitch", OperandKind.LOOKUPSWITCH);
            }
            case 129: {
                return this.decoded("lor", new OperandKind[0]);
            }
            case 113: {
                return this.decoded("lrem", new OperandKind[0]);
            }
            case 173: {
                return this.decoded("lreturn", new OperandKind[0]);
            }
            case 121: {
                return this.decoded("lshl", new OperandKind[0]);
            }
            case 123: {
                return this.decoded("lshr", new OperandKind[0]);
            }
            case 55: {
                return this.decoded("lstore", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 63: {
                return this.decoded("lstore_0", OperandKind.IMPLICITLOCALVARIABLEINDEX_0);
            }
            case 64: {
                return this.decoded("lstore_1", OperandKind.IMPLICITLOCALVARIABLEINDEX_1);
            }
            case 65: {
                return this.decoded("lstore_2", OperandKind.IMPLICITLOCALVARIABLEINDEX_2);
            }
            case 66: {
                return this.decoded("lstore_3", OperandKind.IMPLICITLOCALVARIABLEINDEX_3);
            }
            case 101: {
                return this.decoded("lsub", new OperandKind[0]);
            }
            case 125: {
                return this.decoded("lushr", new OperandKind[0]);
            }
            case 131: {
                return this.decoded("lxor", new OperandKind[0]);
            }
            case 194: {
                return this.decoded("monitorenter", new OperandKind[0]);
            }
            case 195: {
                return this.decoded("monitorexit", new OperandKind[0]);
            }
            case 197: {
                return this.decoded("multianewarray", OperandKind.CLASS2, OperandKind.UNSIGNEDBYTE);
            }
            case 187: {
                return this.decoded("new", OperandKind.CLASS2);
            }
            case 188: {
                return this.decoded("newarray", OperandKind.ATYPE);
            }
            case 0: {
                return this.decoded("nop", new OperandKind[0]);
            }
            case 87: {
                return this.decoded("pop", new OperandKind[0]);
            }
            case 88: {
                return this.decoded("pop2", new OperandKind[0]);
            }
            case 181: {
                return this.decoded("putfield", OperandKind.FIELDREF2);
            }
            case 179: {
                return this.decoded("putstatic", OperandKind.FIELDREF2);
            }
            case 169: {
                return this.decoded("ret", OperandKind.LOCALVARIABLEINDEX1);
            }
            case 177: {
                return this.decoded("return", new OperandKind[0]);
            }
            case 53: {
                return this.decoded("saload", new OperandKind[0]);
            }
            case 86: {
                return this.decoded("sastore", new OperandKind[0]);
            }
            case 17: {
                return this.decoded("sipush", OperandKind.SIGNEDSHORT);
            }
            case 95: {
                return this.decoded("swap", new OperandKind[0]);
            }
            case 170: {
                return this.decoded("tableswitch", OperandKind.TABLESWITCH);
            }
            case 196: {
                int subopcode = 0xFF & dis.readByte();
                switch (subopcode) {
                    case 21: {
                        return this.decoded("wide iload", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 23: {
                        return this.decoded("wide fload", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 25: {
                        return this.decoded("wide aload", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 22: {
                        return this.decoded("wide lload", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 24: {
                        return this.decoded("wide dload", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 54: {
                        return this.decoded("wide istore", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 56: {
                        return this.decoded("wide fstore", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 58: {
                        return this.decoded("wide astore", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 55: {
                        return this.decoded("wide lstore", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 57: {
                        return this.decoded("wide dstore", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 169: {
                        return this.decoded("wide ret", OperandKind.LOCALVARIABLEINDEX2);
                    }
                    case 132: {
                        return this.decoded("wide iinc", OperandKind.LOCALVARIABLEINDEX2, OperandKind.SIGNEDSHORT);
                    }
                }
                throw new ClassFileFormatException("Invalid opcode " + opcode + " after WIDE");
            }
        }
        throw new ClassFileFormatException("Invalid opcode " + opcode);
    }

    @Nullable
    public abstract R decoded(String var1, OperandKind ... var2) throws EX;
}

