/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.ClassFileFormatException;
import de.unkrig.jdisasm.ConstantPool;
import de.unkrig.jdisasm.SignatureParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ClassFile {
    public short minorVersion;
    public short majorVersion;
    public ConstantPool constantPool;
    public AccessFlags accessFlags;
    public String thisClassName;
    public String thisClassPackageNamePrefix;
    public String simpleThisClassName;
    @Nullable
    public String superClassName;
    public final List<String> interfaceNames = new ArrayList<String>();
    public final List<Field> fields = new ArrayList<Field>();
    public final List<Method> methods = new ArrayList<Method>();
    @Nullable
    public BootstrapMethodsAttribute bootstrapMethodsAttribute;
    @Nullable
    public DeprecatedAttribute deprecatedAttribute;
    @Nullable
    public EnclosingMethodAttribute enclosingMethodAttribute;
    @Nullable
    public InnerClassesAttribute innerClassesAttribute;
    @Nullable
    public ModulePackagesAttribute modulePackagesAttribute;
    @Nullable
    public RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
    @Nullable
    public RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
    @Nullable
    public SignatureAttribute signatureAttribute;
    @Nullable
    public SourceFileAttribute sourceFileAttribute;
    @Nullable
    public SyntheticAttribute syntheticAttribute;
    public final List<Attribute> allAttributes = new ArrayList<Attribute>();
    public final List<Attribute> unprocessedAttributes = new ArrayList<Attribute>();
    private SignatureParser signatureParser = new SignatureParser();

    public ClassFile(DataInputStream dis) throws IOException {
        short i;
        int magic = dis.readInt();
        if (magic != -889275714) {
            throw new ClassFileFormatException("Wrong magic number 0x" + Integer.toHexString(magic));
        }
        this.minorVersion = dis.readShort();
        this.majorVersion = dis.readShort();
        this.constantPool = new ConstantPool(dis, this.signatureParser);
        this.accessFlags = new AccessFlags(dis.readShort());
        this.thisClassName = this.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class).toString();
        int idx = this.thisClassName.lastIndexOf(46) + 1;
        this.thisClassPackageNamePrefix = this.thisClassName.substring(0, idx);
        this.simpleThisClassName = this.thisClassName.substring(idx);
        ConstantPool.ConstantClassInfo superclassCci = this.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
        this.superClassName = superclassCci == null ? null : superclassCci.toString();
        for (short i2 = dis.readShort(); i2 > 0; i2 = (short)(i2 - 1)) {
            this.interfaceNames.add(this.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class).toString());
        }
        short n = dis.readShort();
        for (i = 0; i < n; i = (short)(i + 1)) {
            try {
                this.fields.add(new Field(dis));
                continue;
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading field #" + i + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Reading field #" + i + " of " + n + ": " + re.getMessage(), re);
            }
        }
        n = dis.readShort();
        for (i = 0; i < n; i = (short)(i + 1)) {
            try {
                this.methods.add(new Method(dis));
                continue;
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading method #" + i + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Class \"" + this.thisClassName + "\": Reading method #" + i + " of " + n + ": " + re.getMessage(), re);
            }
        }
        this.readAttributes(dis, new AbstractAttributeVisitor(){

            @Override
            public void visit(BootstrapMethodsAttribute bma) {
                ClassFile.this.bootstrapMethodsAttribute = bma;
                ClassFile.this.allAttributes.add(bma);
            }

            @Override
            public void visit(DeprecatedAttribute da) {
                ClassFile.this.deprecatedAttribute = da;
                ClassFile.this.allAttributes.add(da);
            }

            @Override
            public void visit(EnclosingMethodAttribute ema) {
                ClassFile.this.enclosingMethodAttribute = ema;
                ClassFile.this.allAttributes.add(ema);
            }

            @Override
            public void visit(InnerClassesAttribute ica) {
                ClassFile.this.innerClassesAttribute = ica;
                ClassFile.this.allAttributes.add(ica);
            }

            @Override
            public void visit(ModulePackagesAttribute mpa) {
                ClassFile.this.modulePackagesAttribute = mpa;
                ClassFile.this.allAttributes.add(mpa);
            }

            @Override
            public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                ClassFile.this.runtimeInvisibleAnnotationsAttribute = riaa;
                ClassFile.this.allAttributes.add(riaa);
            }

            @Override
            public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                ClassFile.this.runtimeVisibleAnnotationsAttribute = rvaa;
                ClassFile.this.allAttributes.add(rvaa);
            }

            @Override
            public void visit(SignatureAttribute sa) {
                ClassFile.this.signatureAttribute = sa;
                ClassFile.this.allAttributes.add(sa);
            }

            @Override
            public void visit(SourceFileAttribute sfa) {
                ClassFile.this.sourceFileAttribute = sfa;
                ClassFile.this.allAttributes.add(sfa);
            }

            @Override
            public void visit(SyntheticAttribute sa) {
                ClassFile.this.syntheticAttribute = sa;
                ClassFile.this.allAttributes.add(sa);
            }

            @Override
            public void visitOther(Attribute a) {
                ClassFile.this.allAttributes.add(a);
                ClassFile.this.unprocessedAttributes.add(a);
            }
        });
    }

    public void setSignatureParser(SignatureParser signatureParser) {
        this.signatureParser = signatureParser;
        this.constantPool.setSignatureParser(signatureParser);
    }

    public String getJdkName() {
        switch (this.majorVersion) {
            case 51: {
                return "J2SE 7";
            }
            case 50: {
                return "J2SE 6.0";
            }
            case 49: {
                return "J2SE 5.0";
            }
            case 48: {
                return "JDK 1.4";
            }
            case 47: {
                return "JDK 1.3";
            }
            case 46: {
                return "JDK 1.2";
            }
            case 45: {
                return "JDK 1.1";
            }
        }
        return "Java " + (this.majorVersion - 44);
    }

    final void readAttributes(DataInputStream dis, AttributeVisitor visitor) throws IOException {
        int n = dis.readShort();
        for (int i = 0; i < n; ++i) {
            try {
                this.readAttribute(dis, visitor);
                continue;
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading attribute #" + i + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Reading attribute #" + i + " of " + n + ": " + re.getMessage(), re);
            }
        }
    }

    private void readAttribute(DataInputStream dis, AttributeVisitor visitor) throws IOException {
        String attributeName = this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        try {
            int attributeLength = dis.readInt();
            byte[] ba = new byte[attributeLength];
            dis.readFully(ba);
            ByteArrayInputStream bais = new ByteArrayInputStream(ba);
            this.readAttributeBody(attributeName, new DataInputStream(bais), visitor);
            int av = bais.available();
            if (av > 0) {
                throw new RuntimeException(av + " extraneous bytes in attribute body");
            }
        }
        catch (IOException ioe) {
            IOException ioe2 = new IOException("Reading attribute '" + attributeName + "': " + ioe.getMessage());
            ioe2.initCause(ioe);
            throw ioe2;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Reading attribute '" + attributeName + "': " + re.getMessage(), re);
        }
    }

    private void readAttributeBody(String attributeName, DataInputStream dis, AttributeVisitor visitor) throws IOException {
        if ("AnnotationDefault".equals(attributeName)) {
            visitor.visit(new AnnotationDefaultAttribute(dis, this));
        } else if ("BootstrapMethods".equals(attributeName)) {
            visitor.visit(new BootstrapMethodsAttribute(dis, this));
        } else if ("ConstantValue".equals(attributeName)) {
            visitor.visit(new ConstantValueAttribute(dis, this));
        } else if ("Code".equals(attributeName)) {
            visitor.visit(new CodeAttribute(dis, this));
        } else if ("Deprecated".equals(attributeName)) {
            visitor.visit(new DeprecatedAttribute(dis, this));
        } else if ("EnclosingMethod".equals(attributeName)) {
            visitor.visit(new EnclosingMethodAttribute(dis, this));
        } else if ("Exceptions".equals(attributeName)) {
            visitor.visit(new ExceptionsAttribute(dis, this));
        } else if ("InnerClasses".equals(attributeName)) {
            visitor.visit(new InnerClassesAttribute(dis, this));
        } else if ("LineNumberTable".equals(attributeName)) {
            visitor.visit(new LineNumberTableAttribute(dis, this));
        } else if ("LocalVariableTable".equals(attributeName)) {
            visitor.visit(new LocalVariableTableAttribute(dis, this));
        } else if ("LocalVariableTypeTable".equals(attributeName)) {
            visitor.visit(new LocalVariableTypeTableAttribute(dis, this));
        } else if ("MethodParameters".equals(attributeName)) {
            visitor.visit(new MethodParametersAttribute(dis, this));
        } else if ("Module".equals(attributeName)) {
            visitor.visit(new ModuleAttribute(dis, this));
        } else if ("ModuleMainClass".equals(attributeName)) {
            visitor.visit(new ModuleMainClassAttribute(dis, this));
        } else if ("ModulePackages".equals(attributeName)) {
            visitor.visit(new ModulePackagesAttribute(dis, this));
        } else if ("RuntimeInvisibleAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeInvisibleAnnotationsAttribute(dis, this));
        } else if ("RuntimeInvisibleParameterAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeInvisibleParameterAnnotationsAttribute(dis, this));
        } else if ("RuntimeInvisibleTypeAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeInvisibleTypeAnnotationsAttribute(dis, this));
        } else if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeVisibleAnnotationsAttribute(dis, this));
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeVisibleParameterAnnotationsAttribute(dis, this));
        } else if ("RuntimeVisibleTypeAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeVisibleTypeAnnotationsAttribute(dis, this));
        } else if ("Signature".equals(attributeName)) {
            visitor.visit(new SignatureAttribute(dis, this));
        } else if ("SourceDebugExtension".equals(attributeName)) {
            visitor.visit(new SourceDebugExtensionAttribute(dis, this));
        } else if ("SourceFile".equals(attributeName)) {
            visitor.visit(new SourceFileAttribute(dis, this));
        } else if ("StackMapTable".equals(attributeName)) {
            visitor.visit(new StackMapTableAttribute(dis, this));
        } else if ("Synthetic".equals(attributeName)) {
            visitor.visit(new SyntheticAttribute(dis, this));
        } else {
            visitor.visit(new UnknownAttribute(attributeName, dis, this));
        }
    }

    ElementValue newElementValue(DataInputStream dis, ClassFile cf) throws IOException {
        final byte tag = dis.readByte();
        if ("BCDFIJSZ".indexOf(tag) != -1) {
            final String s2 = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantDoubleOrFloatOrIntegerOrLongInfo.class).toString();
            return new ElementValue(){

                public String toString() {
                    return s2;
                }
            };
        }
        if (tag == 115) {
            final String s3 = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            return new ElementValue(){

                public String toString() {
                    return ConstantPool.stringToJavaLiteral(s3);
                }
            };
        }
        if (tag == 101) {
            String typeName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            String constName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                final String s4 = this.signatureParser.decodeFieldDescriptor(typeName) + "." + constName;
                return new ElementValue(){

                    public String toString() {
                        return s4;
                    }
                };
            }
            catch (SignatureParser.SignatureException se) {
                throw new ClassFileFormatException("Decoding enum constant element value: " + se.getMessage(), se);
            }
        }
        if (tag == 99) {
            String classInfo = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                final String s5 = this.signatureParser.decodeReturnType(classInfo) + ".class";
                return new ElementValue(){

                    public String toString() {
                        return s5;
                    }
                };
            }
            catch (SignatureParser.SignatureException se) {
                throw new ClassFileFormatException("Decoding class element value: " + se.getMessage(), se);
            }
        }
        if (tag == 64) {
            final Annotation annotation = new Annotation(dis, cf);
            return new ElementValue(){

                public String toString() {
                    return annotation.toString();
                }
            };
        }
        if (tag == 91) {
            final ArrayList<ElementValue> values = new ArrayList<ElementValue>();
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                values.add(this.newElementValue(dis, cf));
            }
            return new ElementValue(){

                public String toString() {
                    Iterator it = values.iterator();
                    if (!it.hasNext()) {
                        return "{}";
                    }
                    ElementValue firstValue = (ElementValue)it.next();
                    if (!it.hasNext()) {
                        return firstValue.toString();
                    }
                    StringBuilder sb = new StringBuilder("{ ").append(firstValue.toString());
                    do {
                        sb.append(", ").append(((ElementValue)it.next()).toString());
                    } while (it.hasNext());
                    return sb.append(" }").toString();
                }
            };
        }
        return new ElementValue(){

            public String toString() {
                return "[Invalid element value tag '" + (char)tag + "']";
            }
        };
    }

    private static byte[] readByteArray(DataInputStream dis, int size) throws IOException {
        byte[] res = new byte[size];
        dis.readFully(res);
        return res;
    }

    public static final class ConstantValueAttribute
    implements Attribute {
        public final String constantValue;

        ConstantValueAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.constantValue = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo.class).toString();
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "ConstantValue";
        }
    }

    public static class LocalVariableTypeTableAttribute
    implements Attribute {
        public final List<Entry> entries = new ArrayList<Entry>();

        LocalVariableTypeTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.entries.add(new Entry(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LocalVariableTypeTable";
        }

        public static class Entry {
            public final int startPC;
            public final int length;
            public final String name;
            public final String signature;
            public final short index;

            Entry(DataInputStream dis, ClassFile cf) throws IOException {
                this.startPC = dis.readUnsignedShort();
                this.length = dis.readUnsignedShort();
                this.name = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.signature = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.index = dis.readShort();
            }
        }
    }

    public class LocalVariableTableAttribute
    implements Attribute {
        public final List<Entry> entries = new ArrayList<Entry>();

        LocalVariableTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.entries.add(new Entry(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LocalVariableTable";
        }

        class Entry {
            public final short startPC;
            public final short length;
            public final String name;
            public final String descriptor;
            public final short index;

            Entry(DataInputStream dis, ClassFile cf) throws IOException {
                this.startPC = dis.readShort();
                this.length = dis.readShort();
                this.name = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.descriptor = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.index = dis.readShort();
            }
        }
    }

    public static class LineNumberTableEntry {
        public int startPc;
        public int lineNumber;

        LineNumberTableEntry(DataInputStream dis) throws IOException {
            this.startPc = dis.readUnsignedShort();
            this.lineNumber = dis.readUnsignedShort();
        }
    }

    public class LineNumberTableAttribute
    implements Attribute {
        public final List<LineNumberTableEntry> entries = new ArrayList<LineNumberTableEntry>();

        LineNumberTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.entries.add(new LineNumberTableEntry(dis));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LineNumberTable";
        }
    }

    public static class UninitializedVariableInfo
    implements VerificationTypeInfo {
        private final short offset;

        public UninitializedVariableInfo(short offset) {
            this.offset = offset;
        }

        public String toString() {
            return "uninitialized(offset=" + this.offset + ")";
        }
    }

    public static class ObjectVariableInfo
    implements VerificationTypeInfo {
        private final ConstantPool.ConstantClassInfo constantClassInfo;

        public ObjectVariableInfo(ConstantPool.ConstantClassInfo constantClassInfo) {
            this.constantClassInfo = constantClassInfo;
        }

        public String toString() {
            return this.constantClassInfo.toString();
        }
    }

    public static class UninitializedThisVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "uninitializedThis";
        }
    }

    public static class NullVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "null";
        }
    }

    public static class DoubleVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "double";
        }
    }

    public static class LongVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "long";
        }
    }

    public static class FloatVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "float";
        }
    }

    public static class IntegerVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "int";
        }
    }

    public static class TopVariableInfo
    implements VerificationTypeInfo {
        public String toString() {
            return "top";
        }
    }

    public static interface VerificationTypeInfo {
    }

    public static class FullFrame
    extends StackMapFrame {
        public final VerificationTypeInfo[] locals;
        public final VerificationTypeInfo[] stack;

        public FullFrame(int offsetDelta, VerificationTypeInfo[] locals, VerificationTypeInfo[] stack) {
            super(offsetDelta);
            this.locals = locals;
            this.stack = stack;
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitFullFrame(this);
        }

        public String toString() {
            return "full_frame(offsetDelta=" + this.offsetDelta + ", locals=" + Arrays.toString(this.locals) + ", stack=" + Arrays.toString(this.stack) + ")";
        }
    }

    public static class AppendFrame
    extends StackMapFrame {
        public final VerificationTypeInfo[] locals;

        public AppendFrame(int offsetDelta, VerificationTypeInfo[] locals) {
            super(offsetDelta);
            this.locals = locals;
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitAppendFrame(this);
        }

        public String toString() {
            return "append_frame(offsetDelta=" + this.offsetDelta + ", locals+=" + Arrays.toString(this.locals) + ", stack=[])";
        }
    }

    public static class SameFrameExtended
    extends StackMapFrame {
        public SameFrameExtended(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitSameFrameExtended(this);
        }

        public String toString() {
            return "same_frame_extended(offsetDelta=" + this.offsetDelta + ", stack=[])";
        }
    }

    public static class ChopFrame
    extends StackMapFrame {
        public final int k;

        public ChopFrame(int offsetDelta, int k) {
            super(offsetDelta);
            this.k = k;
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitChopFrame(this);
        }

        public String toString() {
            return "chop_frame(offsetDelta=" + this.offsetDelta + ", locals-=" + this.k + ", stack=[])";
        }
    }

    public static class SameLocals1StackItemFrameExtended
    extends StackMapFrame {
        public final VerificationTypeInfo stack;

        public SameLocals1StackItemFrameExtended(int offsetDelta, VerificationTypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitSameLocals1StackItemFrameExtended(this);
        }

        public String toString() {
            return "same_locals_1_stack_item_frame_extended(offsetDelta=" + this.offsetDelta + ", stack=[" + this.stack + "])";
        }
    }

    public static class SameLocals1StackItemFrame
    extends StackMapFrame {
        public final VerificationTypeInfo stack;

        public SameLocals1StackItemFrame(int offsetDelta, VerificationTypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitSameLocals1StackItemFrame(this);
        }

        public String toString() {
            return "same_locals_1_stack_item_frame(offsetDelta=" + this.offsetDelta + ", stack=[" + this.stack + "])";
        }
    }

    public static class SameFrame
    extends StackMapFrame {
        public SameFrame(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public <T> T accept(StackMapFrameVisitor<T> smfv) {
            return smfv.visitSameFrame(this);
        }

        public String toString() {
            return "same_frame(offsetDelta=" + this.offsetDelta + ")";
        }
    }

    public static interface StackMapFrameVisitor<T> {
        public T visitSameFrame(SameFrame var1);

        public T visitSameLocals1StackItemFrame(SameLocals1StackItemFrame var1);

        public T visitSameLocals1StackItemFrameExtended(SameLocals1StackItemFrameExtended var1);

        public T visitChopFrame(ChopFrame var1);

        public T visitSameFrameExtended(SameFrameExtended var1);

        public T visitAppendFrame(AppendFrame var1);

        public T visitFullFrame(FullFrame var1);
    }

    public static abstract class StackMapFrame {
        final int offsetDelta;

        public StackMapFrame(int offsetDelta) {
            this.offsetDelta = offsetDelta;
        }

        public abstract <T> T accept(StackMapFrameVisitor<T> var1);
    }

    public class StackMapTableAttribute
    implements Attribute {
        final List<StackMapFrame> entries = new ArrayList<StackMapFrame>();

        StackMapTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int n = dis.readUnsignedShort();
            for (int i = 0; i < n; ++i) {
                StackMapFrame smf;
                try {
                    smf = this.readStackMapFrame(dis);
                }
                catch (IOException ioe) {
                    IOException ioe2 = new IOException("Reading frame #" + i + " of " + n + ": " + ioe.getMessage());
                    ioe2.initCause(ioe);
                    throw ioe2;
                }
                catch (RuntimeException re) {
                    throw new RuntimeException("Reading frame #" + i + " of " + n + ": " + re.getMessage(), re);
                }
                this.entries.add(smf);
            }
        }

        private StackMapFrame readStackMapFrame(DataInputStream dis) throws IOException {
            int frameType = 0xFF & dis.readByte();
            switch (frameType) {
                case 247: {
                    return new SameLocals1StackItemFrameExtended(dis.readShort(), this.readVerificationTypeInfo(dis));
                }
                case 248: 
                case 249: 
                case 250: {
                    return new ChopFrame(dis.readShort(), 251 - frameType);
                }
                case 251: {
                    return new SameFrameExtended(dis.readShort());
                }
                case 252: 
                case 253: 
                case 254: {
                    return new AppendFrame(dis.readShort(), this.readVerificationTypeInfos(dis, frameType - 251));
                }
                case 255: {
                    return new FullFrame(dis.readShort(), this.readVerificationTypeInfos(dis, dis.readShort()), this.readVerificationTypeInfos(dis, dis.readShort()));
                }
            }
            if (frameType <= 63) {
                return new SameFrame(frameType);
            }
            if (frameType <= 127) {
                return new SameLocals1StackItemFrame(frameType - 64, this.readVerificationTypeInfo(dis));
            }
            if (frameType <= 246) {
                throw new ClassFileFormatException("Reserved frame type " + frameType);
            }
            throw new AssertionError(frameType);
        }

        private VerificationTypeInfo[] readVerificationTypeInfos(DataInputStream dis, int n) throws IOException {
            VerificationTypeInfo[] result = new VerificationTypeInfo[n];
            for (int i = 0; i < n; ++i) {
                result[i] = this.readVerificationTypeInfo(dis);
            }
            return result;
        }

        private VerificationTypeInfo readVerificationTypeInfo(DataInputStream dis) throws IOException {
            int tag = 0xFF & dis.readByte();
            switch (tag) {
                case 0: {
                    return new TopVariableInfo();
                }
                case 1: {
                    return new IntegerVariableInfo();
                }
                case 2: {
                    return new FloatVariableInfo();
                }
                case 3: {
                    return new DoubleVariableInfo();
                }
                case 4: {
                    return new LongVariableInfo();
                }
                case 5: {
                    return new NullVariableInfo();
                }
                case 6: {
                    return new UninitializedThisVariableInfo();
                }
                case 7: {
                    return new ObjectVariableInfo(ClassFile.this.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class));
                }
                case 8: {
                    return new UninitializedVariableInfo(dis.readShort());
                }
            }
            throw new ClassFileFormatException("Invalid verification_type_info tag " + tag);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "StackMapTable";
        }
    }

    public static class SourceFileAttribute
    implements Attribute {
        public String sourceFile;

        SourceFileAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.sourceFile = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "SourceFile";
        }
    }

    public static class ExceptionTableEntry {
        public int startPc;
        public int endPc;
        public int handlerPc;
        @Nullable
        public ConstantPool.ConstantClassInfo catchType;

        ExceptionTableEntry(DataInputStream dis, ClassFile cf) throws IOException {
            this.startPc = dis.readUnsignedShort();
            this.endPc = dis.readUnsignedShort();
            this.handlerPc = dis.readUnsignedShort();
            this.catchType = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
        }

        public String toString() {
            return "startPC=" + this.startPc + " endPC=" + this.endPc + " handlerPC=" + this.handlerPc + " catchType=" + this.catchType;
        }
    }

    public static final class CodeAttribute
    implements Attribute {
        public final short maxStack;
        public final short maxLocals;
        public final byte[] code;
        public final List<ExceptionTableEntry> exceptionTable = new ArrayList<ExceptionTableEntry>();
        @Nullable
        public LocalVariableTableAttribute localVariableTableAttribute;
        @Nullable
        public LocalVariableTypeTableAttribute localVariableTypeTableAttribute;
        @Nullable
        public LineNumberTableAttribute lineNumberTableAttribute;
        @Nullable
        public StackMapTableAttribute stackMapTableAttribute;
        public final List<Attribute> allAttributes = new ArrayList<Attribute>();
        public final List<Attribute> unprocessedAttributes = new ArrayList<Attribute>();

        CodeAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.maxStack = dis.readShort();
            this.maxLocals = dis.readShort();
            this.code = ClassFile.readByteArray(dis, dis.readInt());
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.exceptionTable.add(new ExceptionTableEntry(dis, cf));
            }
            cf.readAttributes(dis, new AbstractAttributeVisitor(){

                @Override
                public void visit(LineNumberTableAttribute lnta) {
                    CodeAttribute.this.lineNumberTableAttribute = lnta;
                    CodeAttribute.this.allAttributes.add(lnta);
                }

                @Override
                public void visit(LocalVariableTableAttribute lvta) {
                    CodeAttribute.this.localVariableTableAttribute = lvta;
                    CodeAttribute.this.allAttributes.add(lvta);
                }

                @Override
                public void visit(LocalVariableTypeTableAttribute lvtta) {
                    CodeAttribute.this.localVariableTypeTableAttribute = lvtta;
                    CodeAttribute.this.allAttributes.add(lvtta);
                }

                @Override
                public void visit(StackMapTableAttribute smta) {
                    CodeAttribute.this.stackMapTableAttribute = smta;
                    CodeAttribute.this.allAttributes.add(smta);
                }

                @Override
                public void visitOther(Attribute a) {
                    CodeAttribute.this.allAttributes.add(a);
                    CodeAttribute.this.unprocessedAttributes.add(a);
                }
            });
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Code";
        }
    }

    public static final class ExceptionsAttribute
    implements Attribute {
        public final List<ConstantPool.ConstantClassInfo> exceptionNames = new ArrayList<ConstantPool.ConstantClassInfo>();

        ExceptionsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.exceptionNames.add(cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Exceptions";
        }
    }

    public static final class EnclosingMethodAttribute
    implements Attribute {
        public ConstantPool.ConstantClassInfo clasS;
        @Nullable
        public ConstantPool.ConstantNameAndTypeInfo method;

        EnclosingMethodAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.clasS = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class);
            this.method = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantNameAndTypeInfo.class);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "EnclosingMethod";
        }
    }

    public static final class SignatureAttribute
    implements Attribute {
        public final String signature;

        SignatureAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.signature = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Signature";
        }
    }

    public static interface ElementValue {
    }

    public class Annotation {
        public String typeName;
        public final List<ElementValuePair> elementValuePairs = new ArrayList<ElementValuePair>();

        public Annotation(DataInputStream dis, ClassFile cf) throws IOException {
            short typeIndex = dis.readShort();
            try {
                this.typeName = ClassFile.this.signatureParser.decodeFieldDescriptor(cf.constantPool.get((short)typeIndex, ConstantPool.ConstantUtf8Info.class).bytes).toString();
            }
            catch (SignatureParser.SignatureException e) {
                throw new ClassFileFormatException("Decoding annotation type: " + e.getMessage(), e);
            }
            for (int i = dis.readUnsignedShort(); i > 0; --i) {
                this.elementValuePairs.add(new ElementValuePair(dis, cf));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("@").append(this.typeName);
            if (!this.elementValuePairs.isEmpty()) {
                Iterator<ElementValuePair> it = this.elementValuePairs.iterator();
                sb.append('(').append(it.next());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next());
                }
                return sb.append(')').toString();
            }
            return sb.toString();
        }

        public class ElementValuePair {
            public final String elementName;
            public final ElementValue elementValue;

            public ElementValuePair(DataInputStream dis, ClassFile cf) throws IOException {
                this.elementName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.elementValue = ClassFile.this.newElementValue(dis, cf);
            }

            public String toString() {
                return "value".equals(this.elementName) ? this.elementValue.toString() : this.elementName + " = " + this.elementValue.toString();
            }
        }
    }

    public static class BootstrapMethodsAttribute
    implements Attribute {
        public List<BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethod>();

        BootstrapMethodsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readShort(); i > 0; --i) {
                this.bootstrapMethods.add(new BootstrapMethod(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "BootstrapMethods";
        }

        public static class BootstrapMethod {
            private final ConstantPool.ConstantMethodHandleInfo bootstrapMethod;
            private final List<ConstantPool.ConstantPoolEntry> bootstrapArguments = new ArrayList<ConstantPool.ConstantPoolEntry>();

            public BootstrapMethod(DataInputStream dis, ClassFile cf) throws IOException {
                this.bootstrapMethod = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantMethodHandleInfo.class);
                for (int i = dis.readShort(); i > 0; --i) {
                    this.bootstrapArguments.add(cf.constantPool.get(dis.readShort(), ConstantPool.ConstantPoolEntry.class));
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder().append(this.bootstrapMethod).append('(');
                Iterator<ConstantPool.ConstantPoolEntry> it = this.bootstrapArguments.iterator();
                if (it.hasNext()) {
                    sb.append(it.next());
                    while (it.hasNext()) {
                        sb.append(", ").append(it.next());
                    }
                }
                return sb.append(')').toString();
            }
        }
    }

    public class AnnotationDefaultAttribute
    implements Attribute {
        public ElementValue defaultValue;

        AnnotationDefaultAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.defaultValue = ClassFile.this.newElementValue(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "AnnotationDefault";
        }
    }

    public class RuntimeInvisibleParameterAnnotationsAttribute
    extends RuntimeVisibleParameterAnnotationsAttribute {
        public RuntimeInvisibleParameterAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class RuntimeVisibleParameterAnnotationsAttribute
    implements Attribute {
        public final List<ParameterAnnotation> parameterAnnotations = new ArrayList<ParameterAnnotation>();

        RuntimeVisibleParameterAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readByte(); i > 0; --i) {
                this.parameterAnnotations.add(new ParameterAnnotation(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "RuntimeVisibleParameterAnnotations";
        }
    }

    public class ParameterAnnotation {
        public final List<Annotation> annotations = new ArrayList<Annotation>();

        public ParameterAnnotation(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readShort(); i > 0; --i) {
                this.annotations.add(new Annotation(dis, cf));
            }
        }
    }

    public class RuntimeInvisibleAnnotationsAttribute
    extends RuntimeVisibleAnnotationsAttribute {
        public RuntimeInvisibleAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class RuntimeVisibleAnnotationsAttribute
    implements Attribute {
        public final List<Annotation> annotations = new ArrayList<Annotation>();

        RuntimeVisibleAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = 0xFFFF & dis.readShort(); i > 0; --i) {
                this.annotations.add(new Annotation(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "RuntimeVisibleAnnotations";
        }
    }

    public static final class InnerClassesAttribute
    implements Attribute {
        public final List<ClasS> classes = new ArrayList<ClasS>();

        InnerClassesAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readShort(); i > 0; --i) {
                this.classes.add(new ClasS(dis, cf));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "InnerClasses";
        }

        public static class ClasS {
            public final ConstantPool.ConstantClassInfo innerClassInfo;
            @Nullable
            public final ConstantPool.ConstantClassInfo outerClassInfo;
            @Nullable
            public final ConstantPool.ConstantUtf8Info innerName;
            public final AccessFlags innerClassAccessFlags;

            public ClasS(DataInputStream dis, ClassFile cf) throws IOException {
                this.innerClassInfo = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class);
                this.outerClassInfo = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
                this.innerName = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantUtf8Info.class);
                this.innerClassAccessFlags = new AccessFlags(dis.readShort());
            }
        }
    }

    public static class DeprecatedAttribute
    implements Attribute {
        public DeprecatedAttribute(DataInputStream dis, ClassFile cf) {
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Deprecated";
        }
    }

    public static class SyntheticAttribute
    implements Attribute {
        public SyntheticAttribute(DataInputStream dis, ClassFile cf) {
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Synthetic";
        }
    }

    public static class UnknownAttribute
    implements Attribute {
        public final String name;
        public byte[] info;

        UnknownAttribute(String name, DataInputStream dis, ClassFile cf) throws IOException {
            this.name = name;
            this.info = ClassFile.readByteArray(dis, dis.available());
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static abstract class AbstractAttributeVisitor
    implements AttributeVisitor {
        public abstract void visitOther(Attribute var1);

        @Override
        public void visit(BootstrapMethodsAttribute bma) {
            this.visitOther(bma);
        }

        @Override
        public void visit(AnnotationDefaultAttribute ada) {
            this.visitOther(ada);
        }

        @Override
        public void visit(CodeAttribute ca) {
            this.visitOther(ca);
        }

        @Override
        public void visit(ConstantValueAttribute cva) {
            this.visitOther(cva);
        }

        @Override
        public void visit(DeprecatedAttribute da) {
            this.visitOther(da);
        }

        @Override
        public void visit(EnclosingMethodAttribute ema) {
            this.visitOther(ema);
        }

        @Override
        public void visit(ExceptionsAttribute ea) {
            this.visitOther(ea);
        }

        @Override
        public void visit(InnerClassesAttribute ica) {
            this.visitOther(ica);
        }

        @Override
        public void visit(LineNumberTableAttribute lnta) {
            this.visitOther(lnta);
        }

        @Override
        public void visit(LocalVariableTableAttribute lvta) {
            this.visitOther(lvta);
        }

        @Override
        public void visit(LocalVariableTypeTableAttribute lvtta) {
            this.visitOther(lvtta);
        }

        @Override
        public void visit(MethodParametersAttribute mpa) {
            this.visitOther(mpa);
        }

        @Override
        public void visit(ModulePackagesAttribute mpa) {
            this.visitOther(mpa);
        }

        @Override
        public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
            this.visitOther(riaa);
        }

        @Override
        public void visit(RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
            this.visitOther(ripaa);
        }

        @Override
        public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
            this.visitOther(rvaa);
        }

        @Override
        public void visit(RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
            this.visitOther(rvpaa);
        }

        @Override
        public void visit(SignatureAttribute sa) {
            this.visitOther(sa);
        }

        @Override
        public void visit(SourceFileAttribute sfa) {
            this.visitOther(sfa);
        }

        @Override
        public void visit(StackMapTableAttribute smta) {
            this.visitOther(smta);
        }

        @Override
        public void visit(SyntheticAttribute sa) {
            this.visitOther(sa);
        }

        @Override
        public void visit(UnknownAttribute a) {
            this.visitOther(a);
        }
    }

    public static interface AttributeVisitor {
        public void visit(AnnotationDefaultAttribute var1);

        public void visit(CodeAttribute var1);

        public void visit(ConstantValueAttribute var1);

        public void visit(DeprecatedAttribute var1);

        public void visit(EnclosingMethodAttribute var1);

        public void visit(ExceptionsAttribute var1);

        public void visit(InnerClassesAttribute var1);

        public void visit(LineNumberTableAttribute var1);

        public void visit(LocalVariableTableAttribute var1);

        public void visit(LocalVariableTypeTableAttribute var1);

        public void visit(MethodParametersAttribute var1);

        public void visit(ModulePackagesAttribute var1);

        public void visit(RuntimeInvisibleAnnotationsAttribute var1);

        public void visit(RuntimeInvisibleParameterAnnotationsAttribute var1);

        public void visit(RuntimeVisibleAnnotationsAttribute var1);

        public void visit(RuntimeVisibleParameterAnnotationsAttribute var1);

        public void visit(SignatureAttribute var1);

        public void visit(SourceFileAttribute var1);

        public void visit(StackMapTableAttribute var1);

        public void visit(SyntheticAttribute var1);

        public void visit(BootstrapMethodsAttribute var1);

        public void visit(UnknownAttribute var1);
    }

    public static class ModuleMainClassAttribute
    extends UnknownAttribute {
        ModuleMainClassAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super("ModuleMainClass", dis, cf);
        }
    }

    public static final class ModulePackagesAttribute
    implements Attribute {
        public final List<String> packages = new ArrayList<String>();

        ModulePackagesAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readShort(); i > 0; --i) {
                this.packages.add(cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantPackageInfo.class).name.bytes);
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "ModulePackages";
        }
    }

    public static class ModuleAttribute
    extends UnknownAttribute {
        ModuleAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super("Module", dis, cf);
        }
    }

    public static class MethodParametersAttribute
    implements Attribute {
        final List<Parameter> parameters = new ArrayList<Parameter>();

        MethodParametersAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            for (int i = dis.readByte(); i > 0; --i) {
                this.parameters.add(new Parameter(cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes, new AccessFlags(dis.readShort())));
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "MethodParameters";
        }

        public static class Parameter {
            String name;
            AccessFlags accessFlags;

            public Parameter(String name, AccessFlags accessFlags) {
                this.name = name;
                this.accessFlags = accessFlags;
            }

            public String toString() {
                return this.accessFlags.toString() + this.name;
            }
        }
    }

    public static class RuntimeInvisibleTypeAnnotationsAttribute
    extends UnknownAttribute {
        RuntimeInvisibleTypeAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super("RuntimeInvisibleTypeAnnotations", dis, cf);
        }
    }

    public static class RuntimeVisibleTypeAnnotationsAttribute
    extends UnknownAttribute {
        RuntimeVisibleTypeAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super("RuntimeVisibleTypeAnnotation", dis, cf);
        }
    }

    public static class SourceDebugExtensionAttribute
    extends UnknownAttribute {
        SourceDebugExtensionAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super("SourceDebugExtension", dis, cf);
        }
    }

    public static interface Attribute {
        public void accept(AttributeVisitor var1);

        public String getName();
    }

    public class Method {
        public AccessFlags accessFlags;
        public String name;
        public String descriptor;
        final List<Attribute> allAttributes = new ArrayList<Attribute>();
        final List<Attribute> unprocessedAttributes = new ArrayList<Attribute>();
        @Nullable
        AnnotationDefaultAttribute annotationDefaultAttribute;
        @Nullable
        CodeAttribute codeAttribute;
        @Nullable
        DeprecatedAttribute deprecatedAttribute;
        @Nullable
        ExceptionsAttribute exceptionsAttribute;
        @Nullable
        MethodParametersAttribute methodParametersAttribute;
        @Nullable
        RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
        @Nullable
        RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute;
        @Nullable
        RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
        @Nullable
        RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute;
        @Nullable
        SignatureAttribute signatureAttribute;
        @Nullable
        SyntheticAttribute syntheticAttribute;

        public Method(DataInputStream dis) throws IOException {
            this.accessFlags = new AccessFlags(dis.readShort());
            this.name = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            this.descriptor = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                ClassFile.this.readAttributes(dis, new AbstractAttributeVisitor(){

                    @Override
                    public void visit(AnnotationDefaultAttribute ada) {
                        Method.this.annotationDefaultAttribute = ada;
                        Method.this.allAttributes.add(ada);
                    }

                    @Override
                    public void visit(CodeAttribute ca) {
                        Method.this.codeAttribute = ca;
                        Method.this.allAttributes.add(ca);
                    }

                    @Override
                    public void visit(DeprecatedAttribute da) {
                        Method.this.deprecatedAttribute = da;
                        Method.this.allAttributes.add(da);
                    }

                    @Override
                    public void visit(ExceptionsAttribute ea) {
                        Method.this.exceptionsAttribute = ea;
                        Method.this.allAttributes.add(ea);
                    }

                    @Override
                    public void visit(MethodParametersAttribute mpa) {
                        Method.this.methodParametersAttribute = mpa;
                        Method.this.allAttributes.add(mpa);
                    }

                    @Override
                    public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                        Method.this.runtimeInvisibleAnnotationsAttribute = riaa;
                        Method.this.allAttributes.add(riaa);
                    }

                    @Override
                    public void visit(RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
                        Method.this.runtimeInvisibleParameterAnnotationsAttribute = ripaa;
                        Method.this.allAttributes.add(ripaa);
                    }

                    @Override
                    public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                        Method.this.runtimeVisibleAnnotationsAttribute = rvaa;
                        Method.this.allAttributes.add(rvaa);
                    }

                    @Override
                    public void visit(RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
                        Method.this.runtimeVisibleParameterAnnotationsAttribute = rvpaa;
                        Method.this.allAttributes.add(rvpaa);
                    }

                    @Override
                    public void visit(SignatureAttribute sa) {
                        Method.this.signatureAttribute = sa;
                        Method.this.allAttributes.add(sa);
                    }

                    @Override
                    public void visit(StackMapTableAttribute smta) {
                        super.visit(smta);
                    }

                    @Override
                    public void visit(SyntheticAttribute sa) {
                        Method.this.syntheticAttribute = sa;
                        Method.this.allAttributes.add(sa);
                    }

                    @Override
                    public void visitOther(Attribute ai) {
                        Method.this.allAttributes.add(ai);
                        Method.this.unprocessedAttributes.add(ai);
                    }
                });
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Parsing method '" + this.name + "' [" + this.descriptor + "]: " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Parsing method '" + this.name + "' [" + this.descriptor + "]: " + re.getMessage(), re);
            }
        }

        public ClassFile getClassFile() {
            return ClassFile.this;
        }

        public BootstrapMethodsAttribute getBootstrapMethodsAttribute() {
            BootstrapMethodsAttribute result = ClassFile.this.bootstrapMethodsAttribute;
            if (result == null) {
                throw new RuntimeException("BootstrapMethods attribute missing");
            }
            return result;
        }
    }

    public class Field {
        public AccessFlags accessFlags;
        public String name;
        public String descriptor;
        public final List<Attribute> allAttributes = new ArrayList<Attribute>();
        public final List<Attribute> unprocessedAttributes = new ArrayList<Attribute>();
        @Nullable
        public ConstantValueAttribute constantValueAttribute;
        @Nullable
        public DeprecatedAttribute deprecatedAttribute;
        @Nullable
        public RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
        @Nullable
        public RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
        @Nullable
        public SignatureAttribute signatureAttribute;
        @Nullable
        public SyntheticAttribute syntheticAttribute;

        public Field(DataInputStream dis) throws IOException {
            this.accessFlags = new AccessFlags(dis.readShort());
            this.name = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            this.descriptor = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            ClassFile.this.readAttributes(dis, new AbstractAttributeVisitor(){

                @Override
                public void visit(ConstantValueAttribute cva) {
                    Field.this.constantValueAttribute = cva;
                    Field.this.allAttributes.add(cva);
                }

                @Override
                public void visit(DeprecatedAttribute da) {
                    Field.this.deprecatedAttribute = da;
                    Field.this.allAttributes.add(da);
                }

                @Override
                public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                    Field.this.runtimeInvisibleAnnotationsAttribute = riaa;
                    Field.this.allAttributes.add(riaa);
                }

                @Override
                public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                    Field.this.runtimeVisibleAnnotationsAttribute = rvaa;
                    Field.this.allAttributes.add(rvaa);
                }

                @Override
                public void visit(SignatureAttribute sa) {
                    Field.this.signatureAttribute = sa;
                    Field.this.allAttributes.add(sa);
                }

                @Override
                public void visit(SyntheticAttribute sa) {
                    Field.this.syntheticAttribute = sa;
                    Field.this.allAttributes.add(sa);
                }

                @Override
                public void visitOther(Attribute ai) {
                    Field.this.allAttributes.add(ai);
                    Field.this.unprocessedAttributes.add(ai);
                }
            });
        }
    }

    public static class AccessFlags {
        private final int value;

        public AccessFlags(int value) {
            this.value = value;
        }

        public boolean is(FlagType ft) {
            return (this.value & ft.value) != 0;
        }

        public boolean isAny(FlagType ... flagTypes) {
            for (FlagType ft : flagTypes) {
                if (!this.is(ft)) continue;
                return true;
            }
            return false;
        }

        public AccessFlags add(FlagType ft) {
            return (this.value & ft.value) != 0 ? this : new AccessFlags(this.value | ft.value);
        }

        public AccessFlags remove(FlagType ft) {
            return (this.value & ft.value) == 0 ? this : new AccessFlags(this.value & ~ft.value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.is(FlagType.PUBLIC)) {
                sb.append("public ");
            }
            if (this.is(FlagType.PRIVATE)) {
                sb.append("private ");
            }
            if (this.is(FlagType.PROTECTED)) {
                sb.append("protected ");
            }
            if (this.is(FlagType.ABSTRACT)) {
                sb.append("abstract ");
            }
            if (this.is(FlagType.STATIC)) {
                sb.append("static ");
            }
            if (this.is(FlagType.FINAL)) {
                sb.append("final ");
            }
            if (this.is(FlagType.TRANSIENT)) {
                sb.append("transient ");
            }
            if (this.is(FlagType.VOLATILE)) {
                sb.append("volatile ");
            }
            if (this.is(FlagType.SYNCHRONIZED)) {
                sb.append("synchronized ");
            }
            if (this.is(FlagType.NATIVE)) {
                sb.append("native ");
            }
            if (this.is(FlagType.STRICT)) {
                sb.append("strictfp ");
            }
            if (this.is(FlagType.SYNTHETIC)) {
                sb.append("synthetic ");
            }
            if (this.is(FlagType.ANNOTATION)) {
                sb.append("@");
            }
            if (this.is(FlagType.INTERFACE)) {
                sb.append("interface ");
            }
            if (this.is(FlagType.ENUM)) {
                sb.append("enum ");
            }
            return sb.toString();
        }

        static enum FlagType {
            PUBLIC(1),
            PRIVATE(2),
            PROTECTED(4),
            STATIC(8),
            FINAL(16),
            SYNCHRONIZED(32),
            VOLATILE(64),
            BRIDGE(64),
            TRANSIENT(128),
            VARARGS(128),
            NATIVE(256),
            INTERFACE(512),
            ABSTRACT(1024),
            STRICT(2048),
            SYNTHETIC(4096),
            ANNOTATION(8192),
            ENUM(16384);

            private final int value;

            private FlagType(int value) {
                this.value = value;
            }
        }
    }
}

