/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.codegen.Code;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.ExprState;
import org.apache.fory.codegen.Expression;
import org.apache.fory.codegen.FieldInfo;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;

public class CodegenContext {
    private static final Logger LOG = LoggerFactory.getLogger(CodegenContext.class);
    public static Set<String> JAVA_RESERVED_WORDS = new HashSet<String>();
    private static Map<String, Map<String, Boolean>> nameConflicts;
    Map<String, Long> newValNameIds = new HashMap<String, Long>();
    Set<String> valNames = new HashSet<String>(JAVA_RESERVED_WORDS);
    Map<Expression, ExprState> exprState = new HashMap<Expression, ExprState>();
    String pkg;
    LinkedHashSet<String> imports = new LinkedHashSet();
    String className;
    String classModifiers = "public final";
    String[] superClasses;
    String[] interfaces;
    List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private CodegenContext instanceInitCtx;
    List<String> instanceInitCodes = new ArrayList<String>();
    private CodegenContext staticInitCtx;
    List<String> staticInitCodes = new ArrayList<String>();
    List<String> constructors = new ArrayList<String>();
    LinkedHashMap<String, String> methods = new LinkedHashMap();
    private final Map<Class<?>, Boolean> sourcePublicAccessibleCache = new HashMap();
    private final Map<Class<?>, Boolean> sourcePkgLevelAccessibleCache = new HashMap();

    public CodegenContext() {
    }

    public CodegenContext(String pkg, Set<String> valNames, LinkedHashSet<String> imports) {
        this.pkg = pkg;
        this.valNames = valNames;
        this.imports = imports;
    }

    public void reserveName(String name) {
        Preconditions.checkArgument(!this.valNames.contains(name));
        String s2 = this.newName(name);
        Preconditions.checkArgument(s2.equals(name));
    }

    public boolean containName(String name) {
        return this.valNames.contains(name);
    }

    public String newName(Class<?> clz) {
        return this.newName(this.namePrefix(clz));
    }

    public String newName(Class<?> clz, String suffix) {
        String name = this.newName(clz);
        return this.newName(name + suffix);
    }

    public String newName(String name) {
        this.newValNameIds.putIfAbsent(name, 0L);
        long id = this.newValNameIds.get(name);
        this.newValNameIds.put(name, id + 1L);
        if (id == 0L && this.valNames.add(name)) {
            return name;
        }
        String newName = String.format("%s%s", name, id);
        while (this.valNames.contains(newName)) {
            this.newValNameIds.put(name, ++id);
            newName = String.format("%s%s", name, id);
        }
        this.valNames.add(newName);
        return newName;
    }

    public String[] newNames(Class<?> clz1, String name2) {
        if (clz1.isArray()) {
            return this.newNames("arr", name2);
        }
        return this.newNames(this.namePrefix(clz1), name2);
    }

    public String[] newNames(String ... names) {
        long id = 0L;
        for (String name : names) {
            id = Math.max(id, this.newValNameIds.getOrDefault(name, 0L));
        }
        for (String name : names) {
            this.newValNameIds.put(name, id + 1L);
        }
        if (id == 0L && !org.apache.fory.collection.Collections.hasIntersection(this.valNames, org.apache.fory.collection.Collections.ofHashSet(names))) {
            this.valNames.addAll(Arrays.asList(names));
            return names;
        }
        String[] newNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            newNames[i] = String.format("%s%s", names[i], id);
            while (this.valNames.contains(newNames[i])) {
                this.newValNameIds.put(newNames[i], ++id);
                newNames[i] = String.format("%s%s", names[i], id);
            }
        }
        this.valNames.addAll(Arrays.asList(newNames));
        return newNames;
    }

    public String namePrefix(Class<?> clz) {
        String type;
        if (clz.isArray()) {
            return "arr";
        }
        try {
            type = clz.getCanonicalName() != null ? this.type(clz) : "object";
        }
        catch (InternalError e) {
            type = "object";
        }
        int index = type.lastIndexOf(".");
        String name = index >= 0 ? StringUtils.uncapitalize(type.substring(index + 1)) : StringUtils.uncapitalize(type);
        if (JAVA_RESERVED_WORDS.contains(name)) {
            return "value";
        }
        return name;
    }

    public String type(Class<?> clz) {
        String pkgOrClassName;
        if (!this.sourcePkgLevelAccessible(clz)) {
            clz = Object.class;
        }
        if (clz.isArray()) {
            return TypeUtils.getArrayType(clz);
        }
        String type = ReflectionUtils.getLiteralName(clz);
        if (type.startsWith("java.lang") && !type.substring("java.lang.".length()).contains(".")) {
            String simpleName = clz.getSimpleName();
            boolean hasPackage = StringUtils.isNotBlank(this.pkg);
            Map packageMap = nameConflicts.computeIfAbsent(hasPackage ? this.pkg : "", p -> new ConcurrentHashMap());
            Class<Object> c = clz;
            Boolean conflictRes = packageMap.computeIfAbsent(simpleName, sn -> {
                try {
                    ClassLoader beanClassClassLoader;
                    ClassLoader classLoader = beanClassClassLoader = c.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : c.getClassLoader();
                    if (beanClassClassLoader == null) {
                        beanClassClassLoader = Fory.class.getClassLoader();
                    }
                    beanClassClassLoader.loadClass(hasPackage ? this.pkg + "." + sn : sn);
                    return Boolean.TRUE;
                }
                catch (ClassNotFoundException e) {
                    return Boolean.FALSE;
                }
            });
            return conflictRes != false ? clz.getName() : simpleName;
        }
        if (this.imports.contains(type)) {
            return clz.getSimpleName();
        }
        int index = type.lastIndexOf(".");
        if (index > 0 && this.imports.contains((pkgOrClassName = type.substring(0, index)) + ".*")) {
            return clz.getSimpleName();
        }
        return type;
    }

    public String type(TypeRef<?> typeRef) {
        return this.type(TypeUtils.getRawType(typeRef));
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public Set<String> getValNames() {
        return this.valNames;
    }

    public LinkedHashSet<String> getImports() {
        return this.imports;
    }

    public void addImports(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.imports.add(ReflectionUtils.getLiteralName(clz));
        }
    }

    public void addImports(String ... imports) {
        this.imports.addAll(Arrays.asList(imports));
    }

    public void addImport(Class<?> cls) {
        this.imports.add(ReflectionUtils.getLiteralName(cls));
    }

    public void addImport(String im) {
        this.imports.add(im);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassModifiers(String classModifiers) {
        this.classModifiers = classModifiers;
    }

    public void extendsClasses(String ... superClasses) {
        this.superClasses = superClasses;
    }

    public void implementsInterfaces(String ... interfaces) {
        this.interfaces = interfaces;
    }

    public void addConstructor(String codeBody, Object ... params) {
        List<Tuple2<String, String>> parameters = this.getParameters(params);
        String paramsStr = parameters.stream().map(t2 -> (String)t2.f0 + " " + (String)t2.f1).collect(Collectors.joining(", "));
        StringBuilder codeBuilder = new StringBuilder(CodeGenerator.alignIndent(codeBody)).append("\n");
        for (String init : this.instanceInitCodes) {
            codeBuilder.append(CodeGenerator.indent(init, 4)).append('\n');
        }
        String constructor = StringUtils.format("public ${className}(${paramsStr}) {\n    ${codeBody}}", "className", this.className, "paramsStr", paramsStr, "codeBody", codeBuilder);
        this.constructors.add(constructor);
    }

    public void addInitCode(String code) {
        this.instanceInitCodes.add(code);
    }

    public void addStaticMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("public static", methodName, codeBody, returnType, params);
    }

    public void addMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("public", methodName, codeBody, returnType, params);
    }

    public void addMethod(String modifier, String methodName, String codeBody, Class<?> returnType, Object ... params) {
        List<Tuple2<String, String>> parameters = this.getParameters(params);
        String paramsStr = parameters.stream().map(t2 -> (String)t2.f0 + " " + (String)t2.f1).collect(Collectors.joining(", "));
        String method = StringUtils.format("${modifier} ${returnType} ${methodName}(${paramsStr}) {\n    ${codeBody}\n}\n", "modifier", modifier, "returnType", this.type(returnType), "methodName", methodName, "paramsStr", paramsStr, "codeBody", CodeGenerator.alignIndent(codeBody));
        String signature = String.format("%s(%s)", methodName, paramsStr);
        if (this.methods.containsKey(signature)) {
            throw new IllegalStateException(String.format("Duplicated method signature: %s", signature));
        }
        this.methods.put(signature, method);
    }

    public void overrideMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("@Override public final", methodName, codeBody, returnType, params);
    }

    private List<Tuple2<String, String>> getParameters(Object ... args) {
        Preconditions.checkArgument(args.length % 2 == 0);
        ArrayList<Tuple2<String, String>> params = new ArrayList<Tuple2<String, String>>(0);
        for (int i = 0; i < args.length; i += 2) {
            String type = args[i] instanceof Class ? this.type((Class)args[i]) : args[i].toString();
            params.add(Tuple2.of(type, args[i + 1].toString()));
        }
        return params;
    }

    public boolean hasField(String fieldName) {
        for (FieldInfo field : this.fields) {
            if (!fieldName.equals(field.fieldName)) continue;
            return true;
        }
        return false;
    }

    private List<FieldInfo> getFieldsInfo(boolean isStatic) {
        return this.fields.stream().filter(f -> f.isStatic == isStatic).collect(Collectors.toList());
    }

    public void addField(Class<?> type, String fieldName) {
        this.addField(this.type(type), fieldName);
    }

    public void addField(String type, String fieldName) {
        this.addField(false, type, fieldName, null);
    }

    public void addField(Class<?> type, String fieldName, Expression initExpr) {
        this.addField(this.type(type), fieldName, initExpr);
    }

    public void addField(String type, String fieldName, Expression initExpr) {
        this.addField(true, type, fieldName, initExpr);
    }

    public void addField(boolean isFinalField, String type, String fieldName, Expression initExpr) {
        this.addField(false, isFinalField, type, fieldName, initExpr);
    }

    public void addField(boolean isStatic, boolean isFinalField, String type, String fieldName, Expression initExpr) {
        this.fields.add(new FieldInfo(isStatic, isFinalField, type, fieldName));
        if (initExpr != null) {
            Code.ExprCode exprCode;
            List<String> initCodes;
            CodegenContext ctx;
            if (isStatic) {
                if (this.staticInitCtx == null) {
                    this.staticInitCtx = new CodegenContext(this.pkg, this.valNames, this.imports);
                }
                ctx = this.staticInitCtx;
                initCodes = this.staticInitCodes;
                if (initExpr instanceof Expression.BaseInvoke) {
                    ((Expression.BaseInvoke)initExpr).needTryCatch = false;
                }
            } else {
                if (this.instanceInitCtx == null) {
                    this.instanceInitCtx = new CodegenContext(this.pkg, this.valNames, this.imports);
                }
                ctx = this.instanceInitCtx;
                initCodes = this.instanceInitCodes;
            }
            if (StringUtils.isNotBlank((exprCode = initExpr.genCode(ctx)).code())) {
                initCodes.add(exprCode.code());
            }
            initCodes.add(String.format("%s = %s;", fieldName, exprCode.value()));
        }
    }

    public String genCode() {
        List<FieldInfo> instanceFields;
        StringBuilder codeBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.pkg)) {
            codeBuilder.append("package ").append(this.pkg).append(";\n\n");
        }
        if (!this.imports.isEmpty()) {
            this.imports.forEach(clz -> codeBuilder.append("import ").append((String)clz).append(";\n"));
            codeBuilder.append('\n');
        }
        codeBuilder.append(String.format("%s class %s ", this.classModifiers, this.className));
        if (this.superClasses != null) {
            codeBuilder.append(String.format("extends %s ", String.join((CharSequence)", ", this.superClasses)));
        }
        if (this.interfaces != null) {
            codeBuilder.append(String.format("implements %s ", String.join((CharSequence)", ", this.interfaces)));
        }
        codeBuilder.append("{\n");
        List<FieldInfo> staticFields = this.getFieldsInfo(true);
        if (!staticFields.isEmpty()) {
            for (FieldInfo field : staticFields) {
                codeBuilder.append("  ").append((CharSequence)this.addFieldDecl(field)).append("\n");
            }
            codeBuilder.append("  static {\n");
            codeBuilder.append("    try {\n");
            for (String staticInitCode : this.staticInitCodes) {
                codeBuilder.append(CodeGenerator.indent(staticInitCode, 6)).append("\n");
            }
            codeBuilder.append("    } catch (Throwable e) {\n");
            codeBuilder.append("      e.printStackTrace();\n");
            codeBuilder.append("      throw new RuntimeException(e);\n");
            codeBuilder.append("    }\n");
            codeBuilder.append("  }\n");
        }
        if (!(instanceFields = this.getFieldsInfo(false)).isEmpty()) {
            codeBuilder.append('\n');
            for (FieldInfo field : instanceFields) {
                codeBuilder.append(CodeGenerator.indent(this.addFieldDecl(field).toString()));
            }
        }
        if (!this.constructors.isEmpty()) {
            codeBuilder.append('\n');
            this.constructors.forEach(constructor -> codeBuilder.append(CodeGenerator.indent(constructor)).append('\n'));
        }
        codeBuilder.append('\n');
        this.methods.values().forEach(method -> codeBuilder.append(CodeGenerator.indent(method)).append('\n'));
        codeBuilder.append('}');
        return codeBuilder.toString();
    }

    private StringBuilder addFieldDecl(FieldInfo field) {
        StringBuilder declare = new StringBuilder("private ");
        if (field.isStatic) {
            declare.append("static ");
        }
        if (field.isFinal) {
            declare.append("final ");
        }
        declare.append(field.type).append(" ").append(field.fieldName).append(";\n");
        return declare;
    }

    public void clearExprState() {
        this.exprState.clear();
    }

    public String optimizeMethodCode(String code) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Expression, ExprState> entry : this.exprState.entrySet()) {
            Expression.Reference reference;
            Expression expression = entry.getKey();
            ExprState value = entry.getValue();
            if (!(expression instanceof Expression.Reference) || !(reference = (Expression.Reference)expression).isFieldRef() || value.getAccessCount() <= 1) continue;
            String type = this.type(reference.type());
            String cacheVariable = StringUtils.format("${type} ${name} = this.${name};", "type", type, "name", reference.name());
            builder.append(cacheVariable).append('\n');
        }
        if (builder.length() > 0) {
            return builder.append(code).toString();
        }
        return code;
    }

    public boolean sourcePublicAccessible(Class<?> clz) {
        return this.sourcePublicAccessibleCache.computeIfAbsent(clz, CodeGenerator::sourcePublicAccessible);
    }

    public boolean sourcePkgLevelAccessible(Class<?> clz) {
        return this.sourcePkgLevelAccessibleCache.computeIfAbsent(clz, CodeGenerator::sourcePkgLevelAccessible);
    }

    static {
        JAVA_RESERVED_WORDS.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"));
        JAVA_RESERVED_WORDS = Collections.unmodifiableSet(JAVA_RESERVED_WORDS);
        nameConflicts = new ConcurrentHashMap<String, Map<String, Boolean>>();
    }
}

