/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;

public abstract class TypeParameter<X> {
    final TypeVariable<?> typeVariable;

    public TypeParameter() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(superclass + "isn't parameterized");
        }
        this.typeVariable = (TypeVariable)((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameter that = (TypeParameter)o;
        return Objects.equals(this.typeVariable, that.typeVariable);
    }

    public int hashCode() {
        return this.typeVariable != null ? this.typeVariable.hashCode() : 0;
    }

    public String toString() {
        return "TypeParameter{typeVariable=" + this.typeVariable + '}';
    }
}

