/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.AbstractCollectionSerializer;
import org.apache.fory.serializer.scala.RangeUtils$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.NumericRange;
import scala.math.Integral;

public class NumericRangeSerializer<A, T extends NumericRange<A>>
extends AbstractCollectionSerializer<T> {
    private final Fory fory;
    private final MethodHandle ctr;
    private final FieldAccessor getter;

    public NumericRangeSerializer(Fory fory, Class<T> cls) {
        this.fory = fory;
        super(fory, cls, false);
        this.ctr = RangeUtils$.MODULE$.lookupCache().get(cls);
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields());
        this.getter = FieldAccessor.createAccessor((Field)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)f -> {
            Class<?> clazz = f.getType();
            Class<Integral> clazz2 = Integral.class;
            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        }).get());
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Class<?> cls = value.start().getClass();
        ClassResolver resolver = this.fory.getClassResolver();
        ClassInfo classInfo = resolver.getClassInfo(cls);
        resolver.writeClassInfo(buffer, classInfo);
        Serializer<Object> serializer = classInfo.getSerializer();
        serializer.write(buffer, value.start());
        serializer.write(buffer, value.end());
        serializer.write(buffer, value.step());
        this.fory.writeRef(buffer, this.getter.get(value));
    }

    @Override
    public T read(MemoryBuffer buffer) {
        ClassResolver resolver = this.fory.getClassResolver();
        ClassInfo classInfo = resolver.readClassInfo(buffer);
        Serializer serializer = classInfo.getSerializer();
        Object start = serializer.read(buffer);
        Object end = serializer.read(buffer);
        Object step = serializer.read(buffer);
        return (T)this.ctr.invoke(start, end, step, this.fory.readRef(buffer));
    }

    @Override
    public T onCollectionRead(Collection<?> collection) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Collection<?> onCollectionWrite(MemoryBuffer memoryBuffer, T t2) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }
}

