/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.shim;

import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.ExceptionUtils;

public class ProtobufDispatcher {
    private static final Logger LOG;
    private static Class<?> pbByteStringClass;
    private static Class<? extends Serializer> pbByteStringSerializerClass;
    private static Class<?> pbMessageClass;
    private static Class<? extends Serializer> pbMessageSerializerClass;

    public static Class<? extends Serializer> getSerializerClass(Class<?> type) {
        if (pbMessageClass == null) {
            return null;
        }
        if (pbMessageSerializerClass == null) {
            LOG.warn("ProtobufSerializer not loaded, please add fory-extensions dependency.");
            return null;
        }
        if (pbMessageClass.isAssignableFrom(type)) {
            return pbMessageSerializerClass;
        }
        if (pbByteStringClass.isAssignableFrom(type)) {
            return pbByteStringSerializerClass;
        }
        return null;
    }

    static {
        block4: {
            LOG = LoggerFactory.getLogger(ProtobufDispatcher.class);
            try {
                pbMessageClass = ReflectionUtils.loadClass("com.google.protobuf.Message");
                pbByteStringClass = ReflectionUtils.loadClass("com.google.protobuf.ByteString");
            }
            catch (Exception e) {
                ExceptionUtils.ignore(e);
            }
            try {
                pbMessageSerializerClass = ReflectionUtils.loadClass(Serializer.class.getPackage().getName() + ".ProtobufSerializer");
                pbByteStringSerializerClass = ReflectionUtils.loadClass(Serializer.class.getPackage().getName() + ".ByteStringSerializer");
            }
            catch (Exception e) {
                ExceptionUtils.ignore(e);
                if (pbMessageClass == null) break block4;
                LOG.warn("ProtobufSerializer not loaded, please add fory-extensions dependency.");
            }
        }
    }
}

