/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw;

import org.openmole.tool.dtw.dtw.DTW;
import org.openmole.tool.dtw.dtw.LinearWindow;
import org.openmole.tool.dtw.dtw.TimeWarpInfo;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;
import org.openmole.tool.dtw.util.DistanceFunctionFactory;

public class BandTest {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            System.out.println("USAGE:  java BandTest timeSeries1 timeSeries2 radius [EuclideanDistance|ManhattanDistance|BinaryDistance]");
            System.exit(1);
        } else {
            TimeSeries timeSeries = new TimeSeries(stringArray[0], false, false, ',');
            TimeSeries timeSeries2 = new TimeSeries(stringArray[1], false, false, ',');
            DistanceFunction distanceFunction = stringArray.length < 4 ? DistanceFunctionFactory.getDistFnByName("EuclideanDistance") : DistanceFunctionFactory.getDistFnByName(stringArray[3]);
            TimeWarpInfo timeWarpInfo = DTW.getWarpInfoBetween(timeSeries, timeSeries2, new LinearWindow(timeSeries, timeSeries2, Integer.parseInt(stringArray[2])), distanceFunction);
            System.out.println("Warp Distance: " + timeWarpInfo.getDistance());
            System.out.println("Warp Path:     " + String.valueOf(timeWarpInfo.getPath()));
        }
    }
}

