/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw;

import org.openmole.tool.dtw.dtw.DTW;
import org.openmole.tool.dtw.dtw.TimeWarpInfo;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;
import org.openmole.tool.dtw.util.DistanceFunctionFactory;

public class DtwTest {
    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.out.println("USAGE:  java DtwTest timeSeries1 timeSeries2 [EuclideanDistance|ManhattanDistance|BinaryDistance]");
            System.exit(1);
        } else {
            TimeSeries timeSeries = new TimeSeries(stringArray[0], false, false, ',');
            TimeSeries timeSeries2 = new TimeSeries(stringArray[1], false, false, ',');
            DistanceFunction distanceFunction = stringArray.length < 3 ? DistanceFunctionFactory.getDistFnByName("EuclideanDistance") : DistanceFunctionFactory.getDistFnByName(stringArray[2]);
            TimeWarpInfo timeWarpInfo = DTW.getWarpInfoBetween(timeSeries, timeSeries2, distanceFunction);
            System.out.println("Warp Distance: " + timeWarpInfo.getDistance());
            System.out.println("Warp Path:     " + String.valueOf(timeWarpInfo.getPath()));
        }
    }
}

