/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openmole.tool.dtw.matrix.ColMajorCell;

public abstract class SearchWindow {
    private final int[] minValues;
    private final int[] maxValues;
    private final int maxJ;
    private int size;
    private int modCount;

    public SearchWindow(int n, int n2) {
        this.minValues = new int[n];
        this.maxValues = new int[n];
        Arrays.fill(this.minValues, -1);
        this.maxJ = n2 - 1;
        this.size = 0;
        this.modCount = 0;
    }

    public final boolean isInWindow(int n, int n2) {
        return n >= this.minI() && n <= this.maxI() && this.minValues[n] <= n2 && this.maxValues[n] >= n2;
    }

    public final int minI() {
        return 0;
    }

    public final int maxI() {
        return this.minValues.length - 1;
    }

    public final int minJ() {
        return 0;
    }

    public final int maxJ() {
        return this.maxJ;
    }

    public final int minJforI(int n) {
        return this.minValues[n];
    }

    public final int maxJforI(int n) {
        return this.maxValues[n];
    }

    public final int size() {
        return this.size;
    }

    public final Iterator iterator() {
        return new SearchWindowIterator(this);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.minI(); i <= this.maxI(); ++i) {
            stringBuffer.append("i=" + i + ", j=" + this.minValues[i] + "..." + this.maxValues[i]);
            if (i == this.maxI()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected int getModCount() {
        return this.modCount;
    }

    protected final void expandWindow(int n) {
        if (n > 0) {
            this.expandSearchWindow(1);
            this.expandSearchWindow(n - 1);
        }
    }

    private final void expandSearchWindow(int n) {
        if (n > 0) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2;
                int n3;
                int n4;
                ColMajorCell colMajorCell = (ColMajorCell)arrayList.get(i);
                if (colMajorCell.getCol() != this.minI() && colMajorCell.getRow() != this.maxJ()) {
                    n4 = colMajorCell.getCol() - n;
                    n3 = colMajorCell.getRow() + n;
                    if (n4 >= this.minI() && n3 <= this.maxJ()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = Math.max(this.minI() - n4, n3 - this.maxJ());
                        this.markVisited(n4 + n2, n3 - n2);
                    }
                }
                if (colMajorCell.getRow() != this.maxJ()) {
                    n4 = colMajorCell.getCol();
                    n3 = colMajorCell.getRow() + n;
                    if (n3 <= this.maxJ()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = n3 - this.maxJ();
                        this.markVisited(n4, n3 - n2);
                    }
                }
                if (colMajorCell.getCol() != this.maxI() && colMajorCell.getRow() != this.maxJ()) {
                    n4 = colMajorCell.getCol() + n;
                    n3 = colMajorCell.getRow() + n;
                    if (n4 <= this.maxI() && n3 <= this.maxJ()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = Math.max(n4 - this.maxI(), n3 - this.maxJ());
                        this.markVisited(n4 - n2, n3 - n2);
                    }
                }
                if (colMajorCell.getCol() != this.minI()) {
                    n4 = colMajorCell.getCol() - n;
                    n3 = colMajorCell.getRow();
                    if (n4 >= this.minI()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = this.minI() - n4;
                        this.markVisited(n4 + n2, n3);
                    }
                }
                if (colMajorCell.getCol() != this.maxI()) {
                    n4 = colMajorCell.getCol() + n;
                    n3 = colMajorCell.getRow();
                    if (n4 <= this.maxI()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = n4 - this.maxI();
                        this.markVisited(n4 - n2, n3);
                    }
                }
                if (colMajorCell.getCol() != this.minI() && colMajorCell.getRow() != this.minJ()) {
                    n4 = colMajorCell.getCol() - n;
                    n3 = colMajorCell.getRow() - n;
                    if (n4 >= this.minI() && n3 >= this.minJ()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = Math.max(this.minI() - n4, this.minJ() - n3);
                        this.markVisited(n4 + n2, n3 + n2);
                    }
                }
                if (colMajorCell.getRow() != this.minJ()) {
                    n4 = colMajorCell.getCol();
                    n3 = colMajorCell.getRow() - n;
                    if (n3 >= this.minJ()) {
                        this.markVisited(n4, n3);
                    } else {
                        n2 = this.minJ() - n3;
                        this.markVisited(n4, n3 + n2);
                    }
                }
                if (colMajorCell.getCol() == this.maxI() || colMajorCell.getRow() == this.minJ()) continue;
                n4 = colMajorCell.getCol() + n;
                n3 = colMajorCell.getRow() - n;
                if (n4 <= this.maxI() && n3 >= this.minJ()) {
                    this.markVisited(n4, n3);
                    continue;
                }
                n2 = Math.max(n4 - this.maxI(), this.minJ() - n3);
                this.markVisited(n4 - n2, n3 + n2);
            }
        }
    }

    protected final void markVisited(int n, int n2) {
        if (this.minValues[n] == -1) {
            this.minValues[n] = n2;
            this.maxValues[n] = n2;
            ++this.size;
            ++this.modCount;
        } else if (this.minValues[n] > n2) {
            this.size += this.minValues[n] - n2;
            this.minValues[n] = n2;
            ++this.modCount;
        } else if (this.maxValues[n] < n2) {
            this.size += n2 - this.maxValues[n];
            this.maxValues[n] = n2;
            ++this.modCount;
        }
    }

    private final class SearchWindowIterator
    implements Iterator {
        private int currentI;
        private int currentJ;
        private final SearchWindow window;
        private boolean hasMoreElements;
        private final int expectedModCount;

        private SearchWindowIterator(SearchWindow searchWindow2) {
            this.window = searchWindow2;
            this.hasMoreElements = this.window.size() > 0;
            this.currentI = this.window.minI();
            this.currentJ = this.window.minJ();
            this.expectedModCount = searchWindow2.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements;
        }

        public Object next() {
            if (SearchWindow.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasMoreElements) {
                throw new NoSuchElementException();
            }
            ColMajorCell colMajorCell = new ColMajorCell(this.currentI, this.currentJ);
            if (++this.currentJ > this.window.maxJforI(this.currentI)) {
                if (++this.currentI <= this.window.maxI()) {
                    this.currentJ = this.window.minJforI(this.currentI);
                } else {
                    this.hasMoreElements = false;
                }
            }
            return colMajorCell;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

