/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.Int$;
import scala.runtime.ModuleSerializationProxy;

public final class BigDecimalOperations$
implements Serializable {
    public static final BigDecimalOperations$ MODULE$ = new BigDecimalOperations$();

    private BigDecimalOperations$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BigDecimalOperations$.class);
    }

    public BigDecimal intPower(BigDecimal xVal, long exponentVal, int scale) {
        BigDecimal x = xVal;
        long exponent = exponentVal;
        if (exponent < 0L) {
            return BigDecimal.valueOf(1L).divide(this.intPower(x, -exponent, scale), scale, 6);
        }
        BigDecimal power = BigDecimal.valueOf(1L);
        while (exponent > 0L) {
            if ((exponent & 1L) == 1L) {
                power = power.multiply(x).setScale(scale, 6);
            }
            x = x.multiply(x).setScale(scale, 6);
            exponent >>= 1;
        }
        return power;
    }

    public BigDecimal intRoot(BigDecimal xVal, long index, int scale) {
        BigDecimal denominator;
        BigDecimal numerator;
        BigDecimal x = xVal;
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal i = BigDecimal.valueOf(index);
        BigDecimal im1 = BigDecimal.valueOf(index - 1L);
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        BigDecimal xPrev = null;
        x = x.divide(i, scale, 6);
        do {
            BigDecimal xToIm1 = this.intPower(x, index - 1L, sp1);
            BigDecimal xToI = x.multiply(xToIm1).setScale(sp1, 6);
            numerator = n.add(im1.multiply(xToI)).setScale(sp1, 6);
            denominator = i.multiply(xToIm1).setScale(sp1, 6);
            xPrev = x;
        } while ((x = numerator.divide(denominator, sp1, 1)).subtract(xPrev).abs().compareTo(tolerance) > 0);
        return x;
    }

    public BigDecimal exp(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.valueOf(1L);
        }
        if (x.signum() == -1) {
            return BigDecimal.valueOf(1L).divide(this.exp(x.negate(), scale), scale, 6);
        }
        BigDecimal xWhole = x.setScale(0, 1);
        if (xWhole.signum() == 0) {
            return this.expTaylor(x, scale);
        }
        BigDecimal xFraction = x.subtract(xWhole);
        BigDecimal z = BigDecimal.valueOf(1L).add(xFraction.divide(xWhole, scale, 6));
        BigDecimal t = this.expTaylor(z, scale);
        BigDecimal maxLong = BigDecimal.valueOf(Long.MAX_VALUE);
        BigDecimal result = BigDecimal.valueOf(1L);
        while (xWhole.compareTo(maxLong) >= 0) {
            result = result.multiply(this.intPower(t, Long.MAX_VALUE, scale)).setScale(scale, 6);
            xWhole = xWhole.subtract(maxLong);
        }
        return result.multiply(this.intPower(t, xWhole.longValue(), scale)).setScale(scale, 6);
    }

    private BigDecimal expTaylor(BigDecimal x, int scale) {
        BigDecimal factorial = BigDecimal.valueOf(1L);
        BigDecimal xPower = x;
        BigDecimal sumPrev = null;
        BigDecimal sum = x.add(BigDecimal.valueOf(1L));
        int i = 2;
        do {
            xPower = xPower.multiply(x).setScale(scale, 6);
            factorial = factorial.multiply(BigDecimal.valueOf(Int$.MODULE$.int2long(i)));
            BigDecimal term = xPower.divide(factorial, scale, 6);
            sumPrev = sum;
            sum = sum.add(term);
            ++i;
        } while (sum.compareTo(sumPrev) != 0);
        return sum;
    }

    public BigDecimal ln(BigDecimal x, int scale) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException("x <= 0");
        }
        int magnitude = x.toString().length() - x.scale() - 1;
        if (magnitude < 3) {
            return this.lnNewton(x, scale);
        }
        BigDecimal root = this.intRoot(x, Int$.MODULE$.int2long(magnitude), scale);
        BigDecimal lnRoot = this.lnNewton(root, scale);
        return BigDecimal.valueOf(Int$.MODULE$.int2long(magnitude)).multiply(lnRoot).setScale(scale, 6);
    }

    private BigDecimal lnNewton(BigDecimal xVal, int scale) {
        BigDecimal x = xVal;
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal term = null;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        do {
            BigDecimal eToX = this.exp(x, sp1);
            term = eToX.subtract(n).divide(eToX, sp1, 1);
            x = x.subtract(term);
        } while (term.compareTo(tolerance) > 0);
        return x.setScale(scale, 6);
    }

    public BigDecimal arctan(BigDecimal x, int scale) {
        if (x.abs().compareTo(BigDecimal.valueOf(1L)) >= 0) {
            throw new IllegalArgumentException("|x| >= 1");
        }
        if (x.signum() == -1) {
            return this.arctan(x.negate(), scale).negate();
        }
        return this.arctanTaylor(x, scale);
    }

    private BigDecimal arctanTaylor(BigDecimal x, int scale) {
        int sp1 = scale + 1;
        int i = 3;
        boolean addFlag = false;
        BigDecimal power = x;
        BigDecimal sum = x;
        BigDecimal term = null;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        do {
            power = power.multiply(x).multiply(x).setScale(sp1, 6);
            term = power.divide(BigDecimal.valueOf(Int$.MODULE$.int2long(i)), sp1, 6);
            sum = addFlag ? sum.add(term) : sum.subtract(term);
            i += 2;
            boolean bl = addFlag = !addFlag;
        } while (term.compareTo(tolerance) > 0);
        return sum;
    }

    public BigDecimal sqrt(BigDecimal x, int scale) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        BigInteger n = x.movePointRight(scale << 1).toBigInteger();
        int bits = n.bitLength() + 1 >> 1;
        BigInteger ix = n.shiftRight(bits);
        BigInteger ixPrev = null;
        do {
            ixPrev = ix;
        } while ((ix = ix.add(n.divide(ix)).shiftRight(1)).compareTo(ixPrev) != 0);
        return new BigDecimal(ix, scale);
    }
}

