/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.fileservice;

import java.io.File;
import java.io.Serializable;
import org.openmole.core.fileservice.AsynchronousDeleter;
import org.openmole.core.fileservice.FileService$;
import org.openmole.core.fileservice.FileServiceCache;
import org.openmole.core.fileservice.FileServiceGC;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.Preference;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.TmpDirectory$;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.hash.Hash;
import org.openmole.tool.hash.Hash$;
import org.openmole.tool.hash.HashType;
import org.openmole.tool.hash.HashType$;
import org.openmole.tool.thread.package$;
import scala.Function1;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.ref.WeakReference;
import scala.ref.WeakReference$;
import scala.runtime.ScalaRunTime$;
import squants.time.Time;

public class FileService {
    private final ListBuffer<File> deleteEmpty = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[0]));
    private final AsynchronousDeleter emptyDeleter = new AsynchronousDeleter((WeakReference<FileService>)WeakReference$.MODULE$.apply((Object)this));
    private final FileServiceGC gc = new FileServiceGC((WeakReference<FileService>)WeakReference$.MODULE$.apply((Object)this));

    public static ClearPreferenceLocation<Time> GCInterval() {
        return FileService$.MODULE$.GCInterval();
    }

    public static FileService apply(Preference preference, ThreadProvider threadProvider) {
        return FileService$.MODULE$.apply(preference, threadProvider);
    }

    public static ClearPreferenceLocation<Object> archiveCacheSize() {
        return FileService$.MODULE$.archiveCacheSize();
    }

    public static ClearPreferenceLocation<Time> archiveCacheTime() {
        return FileService$.MODULE$.archiveCacheTime();
    }

    public static ClearPreferenceLocation<Object> hashCacheSize() {
        return FileService$.MODULE$.hashCacheSize();
    }

    public static ClearPreferenceLocation<Time> hashCacheTime() {
        return FileService$.MODULE$.hashCacheTime();
    }

    public static void start(FileService fileService, Preference preference, ThreadProvider threadProvider) {
        FileService$.MODULE$.start(fileService, preference, threadProvider);
    }

    public static FileService stub() {
        return FileService$.MODULE$.stub();
    }

    public FileService(Preference preference) {
    }

    public ListBuffer<File> deleteEmpty() {
        return this.deleteEmpty;
    }

    public Hash hashNoCache(File file, HashType hashType, TmpDirectory x$3) {
        if (file.isDirectory()) {
            return (Hash)TmpDirectory$.MODULE$.withTmpFile((Function1 & Serializable)archive -> {
                package$package$.MODULE$.archive(file, archive, false, package$package$.MODULE$.archive$default$4(file));
                return Hash$.MODULE$.file(archive, hashType);
            }, x$3);
        }
        return Hash$.MODULE$.file(file, hashType);
    }

    public HashType hashNoCache$default$2() {
        return HashType$.Blake3;
    }

    public Hash hash(File file, HashType hashType, TmpDirectory newFile, FileServiceCache fileServiceCache) {
        return (Hash)fileServiceCache.hashCache().get((Object)Tuple2$.MODULE$.apply((Object)hashType, (Object)file.getCanonicalPath()), package$.MODULE$.function2Callable(() -> this.hash$$anonfun$1(file, newFile, fileServiceCache, hashType)));
    }

    public HashType hash$default$2() {
        return HashType$.Blake3;
    }

    public File archiveForDir(File directory, TmpDirectory newFile, FileServiceCache fileServiceCache) {
        return (File)fileServiceCache.archiveCache().get((Object)directory.getAbsolutePath(), package$.MODULE$.function2Callable(() -> this.archiveForDir$$anonfun$1(newFile, directory)));
    }

    public AsynchronousDeleter org$openmole$core$fileservice$FileService$$emptyDeleter() {
        return this.emptyDeleter;
    }

    public FileServiceGC org$openmole$core$fileservice$FileService$$gc() {
        return this.gc;
    }

    public File wrapRemoveOnGC(File file) {
        return new FileWithGC(file.getPath(), this);
    }

    public void deleteWhenEmpty(File directory) {
        if (directory.exists() && !directory.delete()) {
            ListBuffer<File> listBuffer = this.deleteEmpty();
            synchronized (listBuffer) {
                ListBuffer cfr_ignored_0 = (ListBuffer)this.deleteEmpty().$plus$eq((Object)directory);
            }
            return;
        }
    }

    public boolean asynchronousRemove(File file) {
        return this.org$openmole$core$fileservice$FileService$$emptyDeleter().asynchronousRemove(file);
    }

    private final Hash hash$1(File file$2, TmpDirectory newFile$1, FileServiceCache fileServiceCache$1, HashType hashType$2) {
        return Hash$.MODULE$.file(file$2.isDirectory() ? this.archiveForDir(file$2, newFile$1, fileServiceCache$1) : file$2, hashType$2);
    }

    private final Hash hash$$anonfun$1(File file$3, TmpDirectory newFile$3, FileServiceCache fileServiceCache$2, HashType hashType$3) {
        return this.hash$1(file$3, newFile$3, fileServiceCache$2, hashType$3);
    }

    private final File archive$1(TmpDirectory newFile$2, File directory$1) {
        File ret = TmpDirectory$.MODULE$.newFile("archive", ".tar", newFile$2);
        package$package$.MODULE$.archive(directory$1, ret, false, package$package$.MODULE$.archive$default$4(directory$1));
        return this.wrapRemoveOnGC(ret);
    }

    private final File archiveForDir$$anonfun$1(TmpDirectory newFile$4, File directory$2) {
        return this.archive$1(newFile$4, directory$2);
    }

    public static class FileWithGC
    extends File {
        private final FileService fileService;

        public FileWithGC(String path, FileService fileService) {
            this.fileService = fileService;
            super(path);
        }

        public void finalize() {
            this.fileService.asynchronousRemove(new File(this.getPath()));
        }
    }
}

