/*
 * Decompiled with CFR 0.152.
 */
package gridscale.ssh;

import gridscale.package;
import gridscale.ssh.FilePermission;
import gridscale.ssh.FilePermission$;
import gridscale.ssh.JobId;
import gridscale.ssh.JobId$;
import gridscale.ssh.SSH;
import gridscale.ssh.SSHJobDescription;
import gridscale.ssh.SSHJobDescription$;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public final class package$package$
implements Serializable {
    public static final package$package$ MODULE$ = new package$package$();

    private package$package$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$package$.class);
    }

    public JobId submit(SSHJobDescription description, SSH ssh) {
        Tuple2<String, String> tuple2 = SSHJobDescription$.MODULE$.jobScript(description, ssh);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String command = (String)tuple2._1();
        String jobId = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)command, (Object)jobId);
        String command2 = (String)tuple22._1();
        String jobId2 = (String)tuple22._2();
        ssh.launch(command2);
        return JobId$.MODULE$.apply(jobId2, description.workDirectory());
    }

    public package.ExecutionResult run(String command, boolean verbose, SSH ssh) {
        return ssh.execute(SSHJobDescription$.MODULE$.commandLine(command, verbose));
    }

    public boolean run$default$2() {
        return false;
    }

    public String stdOut(JobId jobId, SSH ssh) {
        return (String)this.readFile(SSHJobDescription$.MODULE$.outFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)_$2 -> Source$.MODULE$.fromInputStream(_$2, Codec$.MODULE$.fallbackSystemCodec()).mkString(), ssh);
    }

    public String stdErr(JobId jobId, SSH ssh) {
        return (String)this.readFile(SSHJobDescription$.MODULE$.errFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)_$3 -> Source$.MODULE$.fromInputStream(_$3, Codec$.MODULE$.fallbackSystemCodec()).mkString(), ssh);
    }

    public package.JobState state(JobId jobId, SSH ssh) {
        boolean bl = SSHJobDescription$.MODULE$.jobIsRunning(jobId, ssh);
        if (bl) {
            return package.JobState$.Running;
        }
        if (!bl) {
            boolean bl2 = this.exists(SSHJobDescription$.MODULE$.endCodeFile(jobId.workDirectory(), jobId.jobId()), ssh);
            if (bl2) {
                String content = (String)ssh.readFile(SSHJobDescription$.MODULE$.endCodeFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)is -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString());
                int exitCode = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(content), (Function1 & Serializable)_$4 -> RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$4))))));
                return SSHJobDescription$.MODULE$.translateState(exitCode);
            }
            if (!bl2) {
                return package.JobState$.Failed$.MODULE$.apply("Job is not running and has no end code file");
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public void clean(JobId job, SSH ssh) {
        String kill = "pid=`cat '" + SSHJobDescription$.MODULE$.pidFile(job.workDirectory(), job.jobId()) + "'` ; kill -9 $pid `ps --ppid $pid -o pid=`";
        String rm = "rm -rf '" + job.workDirectory() + "/" + job.jobId() + "'*";
        package.ExecutionResult k = ssh.execute(kill);
        ssh.execute(rm);
        int n = k.returnCode();
        if (0 == n || 1 == n) {
            return;
        }
        throw ssh.wrongReturnCode(ssh.server().toString(), kill, k);
    }

    public <T> T readFile(String path, Function1<InputStream, T> f, SSH ssh) {
        return ssh.readFile(path, f);
    }

    public void writeFile(Function0<InputStream> is, String path, SSH ssh) {
        ssh.writeFile(is, path);
    }

    public String home(SSH ssh) {
        return (String)ssh.withSFTP((Function1 & Serializable)_$5 -> (String)_$5.canonicalize(".").get());
    }

    public boolean exists(String path, SSH ssh) {
        return BoxesRunTime.unboxToBoolean(ssh.withSFTP((Function1 & Serializable)_$6 -> BoxesRunTime.unboxToBoolean((Object)_$6.exists(path).get())));
    }

    public Try<BoxedUnit> chmod(String path, Seq<FilePermission.FilePermission> perms, SSH ssh) {
        return (Try)ssh.withSFTP((Function1 & Serializable)_$7 -> _$7.chmod(path, FilePermission$.MODULE$.toMask((Set<FilePermission.FilePermission>)perms.toSet())));
    }

    public Vector<package.ListEntry> list(String path, SSH ssh) {
        return (Vector)((Try)ssh.withSFTP((Function1 & Serializable)_$8 -> _$8.ls(path, (Function1<String, Object>)(Function1 & Serializable)e -> {
            String string = e;
            String string2 = ".";
            if (string == null) {
                if (string2 != null) {
                    return true;
                }
            } else if (!string.equals(string2)) return true;
            String string3 = e;
            String string4 = "..";
            if (string3 == null) {
                if (string4 == null) return false;
                return true;
            } else if (string3.equals(string4)) return false;
            return true;
        }))).get();
    }

    public Try<BoxedUnit> makeDir(String path, SSH ssh) {
        return (Try)ssh.withSFTP((Function1 & Serializable)_$9 -> _$9.mkdir(path));
    }

    public void rmDir(String path, SSH ssh) {
        this.list(path, ssh).foreach((Function1)(JProcedure1 & Serializable)entry -> this.remove$1(path, ssh, (package.ListEntry)entry));
        ssh.withSFTP((Function1 & Serializable)_$10 -> _$10.rmdir(path));
    }

    public void rmFile(String path, SSH ssh) {
        ((Try)ssh.withSFTP((Function1 & Serializable)_$11 -> _$11.rm(path))).get();
    }

    public void mv(String from, String to, SSH ssh) {
        ((Try)ssh.withSFTP((Function1 & Serializable)_$12 -> _$12.rename(from, to))).get();
    }

    private final void remove$1(String path$10, SSH ssh$1, package.ListEntry entry) {
        String child = path$10 + "/" + entry.name();
        package.FileType fileType = entry.type();
        package.FileType fileType2 = package.FileType$.File;
        package.FileType fileType3 = fileType;
        if (!(fileType2 != null ? !fileType2.equals(fileType3) : fileType3 != null)) {
            this.rmFile(child, ssh$1);
            return;
        }
        package.FileType fileType4 = package.FileType$.Link;
        package.FileType fileType5 = fileType;
        if (!(fileType4 != null ? !fileType4.equals(fileType5) : fileType5 != null)) {
            this.rmFile(child, ssh$1);
            return;
        }
        package.FileType fileType6 = package.FileType$.Directory;
        package.FileType fileType7 = fileType;
        if (!(fileType6 != null ? !fileType6.equals(fileType7) : fileType7 != null)) {
            this.rmDir(child, ssh$1);
            return;
        }
        package.FileType fileType8 = package.FileType$.Unknown;
        package.FileType fileType9 = fileType;
        if (!(fileType8 != null ? !fileType8.equals(fileType9) : fileType9 != null)) {
            this.rmFile(child, ssh$1);
            return;
        }
        throw new MatchError((Object)fileType);
    }
}

