/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.stream;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import scala.Array$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;

public class GZipedInputStream
extends InputStream {
    private final InputStream is;
    private boolean end;
    private byte[] buffer;
    private int cur;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final GZIPOutputStream gzip;

    public GZipedInputStream(InputStream is) {
        this.is = is;
        this.end = false;
        this.buffer = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.cur = 0;
        this.byteArrayOutputStream = new ByteArrayOutputStream(1024);
        this.gzip = new GZIPOutputStream(this.byteArrayOutputStream());
        this.bufferizeByteArrayStream();
    }

    public boolean end() {
        return this.end;
    }

    public void end_$eq(boolean x$1) {
        this.end = x$1;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public void buffer_$eq(byte[] x$1) {
        this.buffer = x$1;
    }

    public int cur() {
        return this.cur;
    }

    public void cur_$eq(int x$1) {
        this.cur = x$1;
    }

    public ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    public GZIPOutputStream gzip() {
        return this.gzip;
    }

    @Override
    public int read() {
        int n;
        GZipedInputStream gZipedInputStream = this;
        synchronized (gZipedInputStream) {
            while (this.bufferEmpty() && !this.end()) {
                this.readFromInput();
            }
            n = !this.bufferEmpty() ? this.readBuffer() & 0xFF : -1;
        }
        return n;
    }

    @Override
    public void close() {
        this.is.close();
    }

    private void readFromInput() {
        byte[] localBuffer = new byte[1024];
        int r = this.is.read(localBuffer);
        if (r != -1) {
            this.gzip().write(localBuffer, 0, r);
            this.bufferizeByteArrayStream();
            return;
        }
        this.gzip().finish();
        this.bufferizeByteArrayStream();
        this.end_$eq(true);
    }

    private void bufferizeByteArrayStream() {
        this.gzip().flush();
        if (this.byteArrayOutputStream().size() > 0) {
            this.setBuffer(this.byteArrayOutputStream().toByteArray());
            this.byteArrayOutputStream().reset();
            return;
        }
    }

    private byte readBuffer() {
        byte res = this.buffer()[this.cur()];
        this.cur_$eq(this.cur() + 1);
        return res;
    }

    private boolean bufferEmpty() {
        Object object = Predef$.MODULE$.byteArrayOps(this.buffer());
        return this.cur() >= ArrayOps$.MODULE$.size$extension(object);
    }

    private void setBuffer(byte[] array) {
        this.buffer_$eq(this.byteArrayOutputStream().toByteArray());
        this.cur_$eq(0);
    }
}

