/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.stream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openmole.tool.stream.GZipedInputStream;
import org.openmole.tool.stream.package$;
import scala.Function0;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import squants.time.Time;

public final class package {
    public static int DefaultBufferSize() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public static InputStreamDecorator InputStreamDecorator(InputStream inputStream) {
        return package$.MODULE$.InputStreamDecorator(inputStream);
    }

    public static PrintStream NullPrintStream() {
        return package$.MODULE$.NullPrintStream();
    }

    public static OutputStreamDecorator OutputStreamDecorator(OutputStream outputStream) {
        return package$.MODULE$.OutputStreamDecorator(outputStream);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) {
        package$.MODULE$.copy(inputStream, outputStream);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, Time time, ThreadPoolExecutor threadPoolExecutor) {
        package$.MODULE$.copy(inputStream, outputStream, n, time, threadPoolExecutor);
    }

    public static InputStream inputStreamSequence(InputStream inputStream, Seq<InputStream> seq) {
        return package$.MODULE$.inputStreamSequence(inputStream, seq);
    }

    public static <C, T> T withClosable(Function0<C> function0, Function1<C, T> function1) {
        return package$.MODULE$.withClosable(function0, function1);
    }

    public static class InputStreamDecorator {
        private final InputStream is;

        public InputStreamDecorator(InputStream is) {
            this.is = is;
        }

        public byte[] toByteArray() {
            byte[] byArray;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.copy(os);
                byArray = os.toByteArray();
            }
            finally {
                this.is.close();
            }
            return byArray;
        }

        public void copy(OutputStream to) {
            package$.MODULE$.copy(this.is, to);
        }

        public void copy(File to, int maxRead, Time timeout, ThreadPoolExecutor pool) {
            package$.MODULE$.withClosable(() -> package$.org$openmole$tool$stream$package$InputStreamDecorator$$_$copy$$anonfun$7(to), (JProcedure1 & Serializable)_$4 -> this.copy((OutputStream)_$4, maxRead, timeout, pool));
        }

        public void copy(OutputStream to, int maxRead, Time timeout, ThreadPoolExecutor pool) {
            package$.MODULE$.copy(this.is, to, maxRead, timeout, pool);
        }

        public GZipedInputStream toGZiped() {
            return new GZipedInputStream(this.is);
        }

        public GZIPInputStream toGZ() {
            return new GZIPInputStream(this.is);
        }

        public long copy(File file, boolean replace) {
            return Files.copy(this.is, file.toPath(), (CopyOption[])((StandardCopyOption[])Arrays$.MODULE$.seqToArray(replace ? (Seq)((SeqOps)new .colon.colon((Object)StandardCopyOption.REPLACE_EXISTING, (List)Nil$.MODULE$)) : (Seq)((SeqOps)Nil$.MODULE$), StandardCopyOption.class)));
        }

        public boolean copy$default$2() {
            return true;
        }

        public String mkString() {
            String string;
            try {
                string = Source$.MODULE$.fromInputStream(this.is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            }
            finally {
                this.is.close();
            }
            return string;
        }
    }

    public static class OutputStreamDecorator {
        private final OutputStream os;

        public OutputStreamDecorator(OutputStream os) {
            this.os = os;
        }

        public void flushClose() {
            try {
                this.os.flush();
            }
            finally {
                this.os.close();
            }
        }

        public GZIPOutputStream toGZ() {
            return new GZIPOutputStream(this.os);
        }

        public void append(String content) {
            new PrintWriter(this.os).append(content).flush();
        }

        public void appendLine(String line) {
            this.append(line + "\n");
        }
    }

    public static class ReaderRunnable
    implements Callable<Object> {
        private final byte[] buffer;
        private final InputStream from;
        private final int maxRead;

        public ReaderRunnable(byte[] buffer, InputStream from, int maxRead) {
            this.buffer = buffer;
            this.from = from;
            this.maxRead = maxRead;
        }

        @Override
        public int call() {
            return this.from.read(this.buffer, 0, this.maxRead);
        }
    }

    public static class WriterRunnable
    implements Callable<BoxedUnit> {
        private final byte[] buffer;
        private final OutputStream to;
        private final int amount;

        public WriterRunnable(byte[] buffer, OutputStream to, int amount) {
            this.buffer = buffer;
            this.to = to;
            this.amount = amount;
        }

        @Override
        public void call() {
            this.to.write(this.buffer, 0, this.amount);
            this.to.flush();
        }
    }
}

