/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.communication.message;

import java.io.File;
import java.io.Serializable;
import org.openmole.core.communication.message.FileMessage;
import org.openmole.core.communication.message.FileMessage$;
import org.openmole.core.communication.message.ReplicatedFile;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.TmpDirectory$;
import org.openmole.tool.archive.ArchiveType;
import org.openmole.tool.archive.ArchiveType$;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.file.package$;
import org.openmole.tool.hash.Hash$;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ReplicatedFile$
implements Mirror.Product,
Serializable {
    public static final ReplicatedFile$ MODULE$ = new ReplicatedFile$();

    private ReplicatedFile$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ReplicatedFile$.class);
    }

    public ReplicatedFile apply(String originalPath, String name, boolean directory, String hash, String path, int mode) {
        return new ReplicatedFile(originalPath, name, directory, hash, path, mode);
    }

    public ReplicatedFile unapply(ReplicatedFile x$1) {
        return x$1;
    }

    public FileMessage toFileMessage(ReplicatedFile r) {
        return FileMessage$.MODULE$.apply(r);
    }

    public File download(ReplicatedFile replicatedFile, Function2<String, File, BoxedUnit> download, boolean verifyHash, TmpDirectory newFile, FileService fileService) {
        File file;
        File localDirectory = TmpDirectory$.MODULE$.makeNewDir("replica", newFile);
        try {
            try {
                File dl;
                File file2;
                if (replicatedFile.directory()) {
                    File cache = package$.MODULE$.FileDecorator(localDirectory).newFile("archive", ".tgz");
                    download.apply((Object)replicatedFile.path(), (Object)cache);
                    this.verify$1(verifyHash, replicatedFile, cache);
                    File local = package$.MODULE$.FileDecorator(localDirectory).$div(replicatedFile.name());
                    ArchiveType archiveType = ArchiveType$.Tar;
                    boolean bl = package$package$.MODULE$.extract$default$3(cache);
                    package$package$.MODULE$.extract(cache, local, bl, archiveType);
                    cache.delete();
                    package$.MODULE$.FileDecorator(local).mode_$eq(replicatedFile.mode());
                    file2 = local;
                } else {
                    File cache = package$.MODULE$.FileDecorator(localDirectory).$div(replicatedFile.name());
                    download.apply((Object)replicatedFile.path(), (Object)cache);
                    this.verify$1(verifyHash, replicatedFile, cache);
                    package$.MODULE$.FileDecorator(cache).mode_$eq(replicatedFile.mode());
                    file2 = cache;
                }
                file = dl = file2;
            }
            catch (Throwable t) {
                package$.MODULE$.FileDecorator(localDirectory).recursiveDelete();
                throw t;
            }
        }
        finally {
            fileService.deleteWhenEmpty(localDirectory);
        }
        return file;
    }

    public boolean download$default$3(ReplicatedFile replicatedFile) {
        return false;
    }

    public ReplicatedFile upload(File file, Function1<File, String> upload, TmpDirectory x$3) {
        File file2;
        boolean isDir = file.isDirectory();
        if (isDir) {
            File ret = TmpDirectory$.MODULE$.newFile("archive", ".tar", x$3);
            package$package$.MODULE$.archive(file, ret, package$package$.MODULE$.archive$default$3(file), package$package$.MODULE$.archive$default$4(file));
            file2 = ret;
        } else {
            file2 = file;
        }
        File toReplicate = file2;
        int mode = package$.MODULE$.FileDecorator(file).mode();
        String hash = Hash$.MODULE$.file(toReplicate, Hash$.MODULE$.file$default$2()).toString();
        String uploaded = (String)upload.apply((Object)toReplicate);
        return this.apply(file.getPath(), file.getName(), isDir, hash, uploaded, mode);
    }

    public ReplicatedFile fromProduct(Product x$0) {
        String string = (String)x$0.productElement(0);
        String string2 = (String)x$0.productElement(1);
        boolean bl = BoxesRunTime.unboxToBoolean((Object)x$0.productElement(2));
        String string3 = (String)x$0.productElement(3);
        String string4 = (String)x$0.productElement(4);
        int n = BoxesRunTime.unboxToInt((Object)x$0.productElement(5));
        return new ReplicatedFile(string, string2, bl, string3, string4, n);
    }

    private final void verify$1(boolean verifyHash$1, ReplicatedFile replicatedFile$1, File cache) {
        if (verifyHash$1) {
            String cacheHash;
            String string = cacheHash = Hash$.MODULE$.file(cache, Hash$.MODULE$.file$default$2()).toString();
            String string2 = replicatedFile$1.hash();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InternalProcessingError("Hash is incorrect for file " + replicatedFile$1.originalPath() + " replicated at " + replicatedFile$1.path(), InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
    }
}

