/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.AmperesPerMeter$;
import squants.electro.AmperesPerSquareMeter$;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent$;
import squants.electro.ElectricCurrentDensity;
import squants.electro.ElectricCurrentUnit;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance;
import squants.electro.Inductance;
import squants.electro.MagneticFieldStrength;
import squants.electro.MagneticFlux;
import squants.electro.Milliamperes$;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Area;
import squants.space.Length;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

public final class ElectricCurrent
extends Quantity<ElectricCurrent>
implements TimeDerivative<ElectricCharge> {
    private final double value;
    private final ElectricCurrentUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ElectricCurrent$.class, "0bitmap$1");

    public static Try<ElectricCurrent> apply(Object object) {
        return ElectricCurrent$.MODULE$.apply(object);
    }

    public static <A> ElectricCurrent apply(A a, ElectricCurrentUnit electricCurrentUnit, Numeric<A> numeric) {
        return ElectricCurrent$.MODULE$.apply(a, electricCurrentUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ElectricCurrent$.MODULE$.dimensionImplicit();
    }

    public static String dimensionSymbol() {
        return ElectricCurrent$.MODULE$.dimensionSymbol();
    }

    public static String name() {
        return ElectricCurrent$.MODULE$.name();
    }

    public static Try<ElectricCurrent> parseString(String string) {
        return ElectricCurrent$.MODULE$.parseString(string);
    }

    public static <N> Try<ElectricCurrent> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricCurrent$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ElectricCurrent$.MODULE$.primaryUnit();
    }

    public static SiBaseUnit siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ElectricCurrent>> symbolToUnit(String string) {
        return ElectricCurrent$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ElectricCurrent$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ElectricCurrent$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ElectricCurrent(double value, ElectricCurrentUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricCurrentUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ElectricCurrent> dimension() {
        return ElectricCurrent$.MODULE$;
    }

    @Override
    public ElectricCharge timeIntegrated() {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toAmperes()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public ElectricPotential $times(ElectricalResistance that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(ElectricPotential that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(Inductance that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance $div(ElectricPotential that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFieldStrength $div(Length that) {
        return AmperesPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrentDensity $div(Area that) {
        return AmperesPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toAmperes() {
        return this.to(Amperes$.MODULE$);
    }

    public double toMilliamperes() {
        return this.to(Milliamperes$.MODULE$);
    }
}

