/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import squants.Platform$;
import squants.Ratio;
import squants.market.Currency;
import squants.market.CurrencyExchangeRate$;
import squants.market.Money;

public class CurrencyExchangeRate
implements Ratio<Money, Money>,
Product,
Serializable {
    private final Money base;
    private final Money counter;

    public static CurrencyExchangeRate apply(Money money, Money money2) {
        return CurrencyExchangeRate$.MODULE$.apply(money, money2);
    }

    public static CurrencyExchangeRate fromProduct(Product product) {
        return CurrencyExchangeRate$.MODULE$.fromProduct(product);
    }

    public static CurrencyExchangeRate unapply(CurrencyExchangeRate currencyExchangeRate) {
        return CurrencyExchangeRate$.MODULE$.unapply(currencyExchangeRate);
    }

    public CurrencyExchangeRate(Money base, Money counter) {
        this.base = base;
        this.counter = counter;
        Currency currency = base.currency();
        Currency currency2 = counter.currency();
        Predef$.MODULE$.require(currency == null ? currency2 != null : !((Object)currency).equals(currency2), CurrencyExchangeRate::$init$$$anonfun$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CurrencyExchangeRate)) return false;
        CurrencyExchangeRate currencyExchangeRate = (CurrencyExchangeRate)object;
        Money money = this.base();
        Money money2 = currencyExchangeRate.base();
        if (money == null) {
            if (money2 != null) {
                return false;
            }
        } else if (!((Object)money).equals(money2)) return false;
        Money money3 = this.counter();
        Money money4 = currencyExchangeRate.counter();
        if (money3 == null) {
            if (money4 != null) {
                return false;
            }
        } else if (!((Object)money3).equals(money4)) return false;
        if (!currencyExchangeRate.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof CurrencyExchangeRate;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "CurrencyExchangeRate";
    }

    public Object productElement(int n) {
        Money money;
        int n2 = n;
        if (0 == n2) {
            money = this._1();
        } else if (1 == n2) {
            money = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return money;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "base";
        } else if (1 == n2) {
            string = "counter";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    @Override
    public Money base() {
        return this.base;
    }

    @Override
    public Money counter() {
        return this.counter;
    }

    public double rate() {
        return this.counter().amount().$div(this.base().amount()).toDouble();
    }

    public Money convert(Money money) {
        Money money2;
        Currency currency = money.currency();
        Currency currency2 = this.base().currency();
        Currency currency3 = currency;
        if (!(currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null)) {
            money2 = this.convertToCounter(money);
        } else {
            Currency currency4 = this.counter().currency();
            Currency currency5 = currency;
            if (!(currency4 != null ? !((Object)currency4).equals(currency5) : currency5 != null)) {
                money2 = this.convertToBase(money);
            } else {
                throw new IllegalArgumentException("The currency of money must match the currency of base or counter");
            }
        }
        return money2;
    }

    public Money $times(Money money) {
        return this.convert(money);
    }

    @Override
    public Money convertToBase(Money m) {
        return this.base().$times(m.$div(this.counter(), m.$div$default$2(this.counter())));
    }

    @Override
    public Money convertToCounter(Money m) {
        return this.counter().$times(m.$div(this.base(), m.$div$default$2(this.base())));
    }

    public String toString() {
        return "" + this.base().currency().code() + "/" + this.counter().currency().code() + " " + Platform$.MODULE$.crossFormat(this.rate());
    }

    public CurrencyExchangeRate copy(Money base, Money counter) {
        return new CurrencyExchangeRate(base, counter);
    }

    public Money copy$default$1() {
        return this.base();
    }

    public Money copy$default$2() {
        return this.counter();
    }

    public Money _1() {
        return this.base();
    }

    public Money _2() {
        return this.counter();
    }

    private static final String $init$$$anonfun$1() {
        return "Can not create Exchange Rate on matching currencies";
    }
}

