/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import scala.Option;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import squants.market.AUD$;
import squants.market.BTC$;
import squants.market.CAD$;
import squants.market.CHF$;
import squants.market.ETH$;
import squants.market.EUR$;
import squants.market.GBP$;
import squants.market.HKD$;
import squants.market.JPY$;
import squants.market.LTC$;
import squants.market.Money;
import squants.market.Money$;
import squants.market.MoneyContext;
import squants.market.MoneyConversions$;
import squants.market.NAD$;
import squants.market.NOK$;
import squants.market.NZD$;
import squants.market.SEK$;
import squants.market.TRY$;
import squants.market.USD$;
import squants.market.XAG$;
import squants.market.XAU$;
import squants.market.ZAR$;

public final class MoneyConversions {
    public static <A> MoneyConversions<A> MoneyConversions(A a, Numeric<A> numeric) {
        return MoneyConversions$.MODULE$.MoneyConversions(a, numeric);
    }

    public static Money dollar() {
        return MoneyConversions$.MODULE$.dollar();
    }

    public static Money euro() {
        return MoneyConversions$.MODULE$.euro();
    }

    public static MoneyConversions<BigDecimal> fromDouble(double d) {
        return MoneyConversions$.MODULE$.fromDouble(d);
    }

    public static MoneyConversions<BigDecimal> fromLong(long l) {
        return MoneyConversions$.MODULE$.fromLong(l);
    }

    public static Money yen() {
        return MoneyConversions$.MODULE$.yen();
    }

    public static class MoneyConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> MoneyConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Money money(MoneyContext context) {
            return Money$.MODULE$.apply(this.n, context.defaultCurrency(), this.num);
        }

        public Money XAU() {
            return Money$.MODULE$.apply(this.n, XAU$.MODULE$, this.num);
        }

        public Money XAG() {
            return Money$.MODULE$.apply(this.n, XAG$.MODULE$, this.num);
        }

        public Money USD() {
            return Money$.MODULE$.apply(this.n, USD$.MODULE$, this.num);
        }

        public Money dollars() {
            return this.USD();
        }

        public Money cents() {
            return Money$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.num.toDouble(this.n) / 100.0)), USD$.MODULE$, Numeric.DoubleIsFractional$.MODULE$);
        }

        public Money EUR() {
            return Money$.MODULE$.apply(this.n, EUR$.MODULE$, this.num);
        }

        public Money euros() {
            return this.EUR();
        }

        public Money JPY() {
            return Money$.MODULE$.apply(this.n, JPY$.MODULE$, this.num);
        }

        public Money yen() {
            return this.JPY();
        }

        public Money GBP() {
            return Money$.MODULE$.apply(this.n, GBP$.MODULE$, this.num);
        }

        public Money poundSterling() {
            return this.GBP();
        }

        public Money CHF() {
            return Money$.MODULE$.apply(this.n, CHF$.MODULE$, this.num);
        }

        public Money swissFrancs() {
            return this.CHF();
        }

        public Money AUD() {
            return Money$.MODULE$.apply(this.n, AUD$.MODULE$, this.num);
        }

        public Money CAD() {
            return Money$.MODULE$.apply(this.n, CAD$.MODULE$, this.num);
        }

        public Money SEK() {
            return Money$.MODULE$.apply(this.n, SEK$.MODULE$, this.num);
        }

        public Money HKD() {
            return Money$.MODULE$.apply(this.n, HKD$.MODULE$, this.num);
        }

        public Money NOK() {
            return Money$.MODULE$.apply(this.n, NOK$.MODULE$, this.num);
        }

        public Money NZD() {
            return Money$.MODULE$.apply(this.n, NZD$.MODULE$, this.num);
        }

        public Money BTC() {
            return Money$.MODULE$.apply(this.n, BTC$.MODULE$, this.num);
        }

        public Money bitcoin() {
            return this.BTC();
        }

        public Money ETH() {
            return Money$.MODULE$.apply(this.n, ETH$.MODULE$, this.num);
        }

        public Money ether() {
            return this.ETH();
        }

        public Money LTC() {
            return Money$.MODULE$.apply(this.n, LTC$.MODULE$, this.num);
        }

        public Money litecoin() {
            return this.LTC();
        }

        public Money ZAR() {
            return Money$.MODULE$.apply(this.n, ZAR$.MODULE$, this.num);
        }

        public Money NAD() {
            return Money$.MODULE$.apply(this.n, NAD$.MODULE$, this.num);
        }

        public Money TRY() {
            return Money$.MODULE$.apply(this.n, TRY$.MODULE$, this.num);
        }
    }

    public static class MoneyNumeric
    implements Numeric<Money> {
        private final MoneyContext mc;

        public MoneyNumeric(MoneyContext mc) {
            this.mc = mc;
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
            Numeric.$init$((Numeric)this);
        }

        public Money plus(Money x, Money y) {
            return x.$plus(y, this.mc);
        }

        public Money minus(Money x, Money y) {
            return x.$minus(y, this.mc);
        }

        public Money times(Money x, Money y) {
            throw new UnsupportedOperationException("Numeric.times not supported for Quantities");
        }

        public Money negate(Money x) {
            return (Money)x.unary_$minus();
        }

        public Money fromInt(int x) {
            return this.mc.defaultCurrency().apply(BoxesRunTime.boxToInteger((int)x), (Numeric)Numeric.IntIsIntegral$.MODULE$);
        }

        public int toInt(Money x) {
            return (int)x.value();
        }

        public long toLong(Money x) {
            return (long)x.value();
        }

        public float toFloat(Money x) {
            return (float)x.value();
        }

        public double toDouble(Money x) {
            return x.value();
        }

        public int compare(Money x, Money y) {
            return x.value() > y.value() ? 1 : (x.value() < y.value() ? -1 : 0);
        }

        public Option<Money> parseString(String str) {
            return Money$.MODULE$.apply(str, this.mc).toOption();
        }

        public String toString() {
            return "MoneyNumeric(" + this.mc + ")";
        }
    }
}

