/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.mass.Mass;
import squants.motion.Acceleration$;
import squants.motion.AccelerationUnit;
import squants.motion.EarthGravities$;
import squants.motion.FeetPerSecondSquared$;
import squants.motion.Force;
import squants.motion.Jerk;
import squants.motion.MetersPerSecond$;
import squants.motion.MetersPerSecondCubed$;
import squants.motion.MetersPerSecondSquared$;
import squants.motion.MillimetersPerSecondSquared$;
import squants.motion.Newtons$;
import squants.motion.UsMilesPerHourSquared$;
import squants.motion.Velocity;
import squants.space.Length;
import squants.time.SecondTimeDerivative;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

public final class Acceleration
extends Quantity<Acceleration>
implements TimeDerivative<Velocity>,
SecondTimeDerivative<Length>,
TimeIntegral<Jerk> {
    private final double value;
    private final AccelerationUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Acceleration$.class, "0bitmap$1");

    public static Try<Acceleration> apply(Object object) {
        return Acceleration$.MODULE$.apply(object);
    }

    public static <A> Acceleration apply(A a, AccelerationUnit accelerationUnit, Numeric<A> numeric) {
        return Acceleration$.MODULE$.apply(a, accelerationUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Acceleration$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Acceleration$.MODULE$.name();
    }

    public static Try<Acceleration> parseString(String string) {
        return Acceleration$.MODULE$.parseString(string);
    }

    public static <N> Try<Acceleration> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Acceleration$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Acceleration$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Acceleration$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Acceleration>> symbolToUnit(String string) {
        return Acceleration$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Acceleration$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Acceleration$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Acceleration(double value, AccelerationUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public AccelerationUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Acceleration> dimension() {
        return Acceleration$.MODULE$;
    }

    @Override
    public Velocity timeIntegrated() {
        return MetersPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toMetersPerSecondSquared()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Jerk timeDerived() {
        return MetersPerSecondCubed$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toMetersPerSecondSquared()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $times(Mass that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMetersPerSecondSquared() * that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Length $times(TimeSquared that) {
        return (Length)((TimeDerivative)((Object)this.$times(that.time1()))).$times(that.time2());
    }

    public double toFeetPerSecondSquared() {
        return this.to(FeetPerSecondSquared$.MODULE$);
    }

    public double toMillimetersPerSecondSquared() {
        return this.to(MillimetersPerSecondSquared$.MODULE$);
    }

    public double toMetersPerSecondSquared() {
        return this.to(MetersPerSecondSquared$.MODULE$);
    }

    public double toUsMilesPerHourSquared() {
        return this.to(UsMilesPerHourSquared$.MODULE$);
    }

    public double toEarthGravities() {
        return this.to(EarthGravities$.MODULE$);
    }

    public Tuple2<Time, Velocity> analyze(Length distance) {
        Time timeToDistance = ((Length)distance.$times(2.0)).$div(this).squareRoot();
        Velocity finalVelocity = (Velocity)this.$times(timeToDistance);
        return Tuple2$.MODULE$.apply((Object)timeToDistance, (Object)finalVelocity);
    }

    public Tuple2<Length, Velocity> analyze(Time accelerationTime) {
        Velocity finalVelocity = (Velocity)this.$times(accelerationTime);
        Length distance = (Length)this.$times(accelerationTime.squared()).$times(0.5);
        return Tuple2$.MODULE$.apply((Object)distance, (Object)finalVelocity);
    }

    public Tuple2<Time, Length> analyze(Velocity velocity) {
        Time timeToVelocity = velocity.$div(this);
        Length distance = (Length)this.$times(timeToVelocity.squared()).$times(0.5);
        return Tuple2$.MODULE$.apply((Object)timeToVelocity, (Object)distance);
    }
}

