/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv4Address$Classes$;
import com.comcast.ip4s.Ipv4Address$Classes$Private$;
import com.comcast.ip4s.Ipv4AddressPlatform;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import java.io.Serializable;
import java.net.Inet4Address;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Ipv4Address
extends IpAddress
implements Ipv4AddressPlatform {
    private final byte[] bytes;

    public static Ipv4Address MulticastRangeEnd() {
        return Ipv4Address$.MODULE$.MulticastRangeEnd();
    }

    public static Ipv4Address MulticastRangeStart() {
        return Ipv4Address$.MODULE$.MulticastRangeStart();
    }

    public static Ipv4Address SourceSpecificMulticastRangeEnd() {
        return Ipv4Address$.MODULE$.SourceSpecificMulticastRangeEnd();
    }

    public static Ipv4Address SourceSpecificMulticastRangeStart() {
        return Ipv4Address$.MODULE$.SourceSpecificMulticastRangeStart();
    }

    public static Option<Ipv4Address> fromBytes(byte[] byArray) {
        return Ipv4Address$.MODULE$.fromBytes(byArray);
    }

    public static Ipv4Address fromBytes(int n, int n2, int n3, int n4) {
        return Ipv4Address$.MODULE$.fromBytes(n, n2, n3, n4);
    }

    public static Ipv4Address fromInet4Address(Inet4Address inet4Address) {
        return Ipv4Address$.MODULE$.fromInet4Address(inet4Address);
    }

    public static Ipv4Address fromLong(long l) {
        return Ipv4Address$.MODULE$.fromLong(l);
    }

    public static Option<Ipv4Address> fromString(String string) {
        return Ipv4Address$.MODULE$.fromString(string);
    }

    public static Ipv4Address mask(int n) {
        return Ipv4Address$.MODULE$.mask(n);
    }

    public Ipv4Address(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public <A> A fold(Function1<Ipv4Address, A> v4, Function1<Ipv6Address, A> v6) {
        return (A)v4.apply((Object)this);
    }

    @Override
    public Ipv4Address transform(Function1<Ipv4Address, Ipv4Address> v4, Function1<Ipv6Address, Ipv6Address> v6) {
        return (Ipv4Address)v4.apply((Object)this);
    }

    @Override
    public String toDefaultString() {
        return new StringBuilder(3).append(this.bytes()[0] & 0xFF).append(".").append(this.bytes()[1] & 0xFF).append(".").append(this.bytes()[2] & 0xFF).append(".").append(this.bytes()[3] & 0xFF).toString();
    }

    @Override
    public String toUriString() {
        return this.toDefaultString();
    }

    @Override
    public Ipv4Address next() {
        return Ipv4Address$.MODULE$.fromLong(this.toLong() + 1L);
    }

    @Override
    public Ipv4Address previous() {
        return Ipv4Address$.MODULE$.fromLong(this.toLong() - 1L);
    }

    public long toLong() {
        byte[] bs = this.bytes();
        LongRef result = LongRef.create((long)0L);
        Object object = Predef$.MODULE$.byteArrayOps(bs);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long l;
            result$1.elem = l = result$1.elem << 8 | (long)(0xFF & bs[i]);
        });
        return result.elem;
    }

    @Override
    public boolean isMulticast() {
        return this.$greater$eq(Ipv4Address$.MODULE$.MulticastRangeStart()) && this.$less$eq(Ipv4Address$.MODULE$.MulticastRangeEnd());
    }

    @Override
    public boolean isSourceSpecificMulticast() {
        return this.$greater$eq(Ipv4Address$.MODULE$.SourceSpecificMulticastRangeStart()) && this.$less$eq(Ipv4Address$.MODULE$.SourceSpecificMulticastRangeEnd());
    }

    @Override
    public boolean isLoopback() {
        return BoxesRunTime.unboxToBoolean((Object)Ipv4Address$Classes$.MODULE$.Loopback().contains().apply((Object)this));
    }

    @Override
    public boolean isLinkLocal() {
        return BoxesRunTime.unboxToBoolean((Object)Ipv4Address$Classes$.MODULE$.LinkLocal().contains().apply((Object)this));
    }

    @Override
    public boolean isPrivate() {
        return BoxesRunTime.unboxToBoolean((Object)Ipv4Address$Classes$Private$.MODULE$.A().contains().apply((Object)this)) || BoxesRunTime.unboxToBoolean((Object)Ipv4Address$Classes$Private$.MODULE$.B().contains().apply((Object)this)) || BoxesRunTime.unboxToBoolean((Object)Ipv4Address$Classes$Private$.MODULE$.C().contains().apply((Object)this));
    }

    public Ipv6Address toCompatV6() {
        byte[] compat2 = new byte[16];
        compat2[12] = this.bytes()[0];
        compat2[13] = this.bytes()[1];
        compat2[14] = this.bytes()[2];
        compat2[15] = this.bytes()[3];
        return (Ipv6Address)Ipv6Address$.MODULE$.fromBytes(compat2).get();
    }

    public Ipv6Address toMappedV6() {
        byte[] mapped = new byte[16];
        mapped[10] = (byte)255;
        mapped[11] = (byte)255;
        mapped[12] = this.bytes()[0];
        mapped[13] = this.bytes()[1];
        mapped[14] = this.bytes()[2];
        mapped[15] = this.bytes()[3];
        return (Ipv6Address)Ipv6Address$.MODULE$.fromBytes(mapped).get();
    }

    public Ipv4Address masked(Ipv4Address mask) {
        return Ipv4Address$.MODULE$.fromLong(this.toLong() & mask.toLong());
    }

    public Ipv4Address maskedLast(Ipv4Address mask) {
        return Ipv4Address$.MODULE$.fromLong(this.toLong() & mask.toLong() | mask.toLong() ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

