/*
 * Decompiled with CFR 0.152.
 */
package fs2.interop.flow;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.interop.flow.StreamSubscription$;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class StreamSubscription<F, A>
implements Flow.Subscription {
    private final Stream<F, A> stream;
    private final Flow.Subscriber<A> subscriber;
    private final AtomicLong requests;
    private final AtomicReference<Function0<BoxedUnit>> resume;
    private final AtomicReference<Function0<BoxedUnit>> canceled;
    private final Async<F> F;

    public static <F, A> StreamSubscription<F, A> apply(Stream<F, A> stream, Flow.Subscriber<A> subscriber, Async<F> async) {
        return StreamSubscription$.MODULE$.apply(stream, subscriber, async);
    }

    public static <F, A> Stream<F, Nothing$> subscribe(Stream<F, A> stream, Flow.Subscriber<A> subscriber, Async<F> async) {
        return StreamSubscription$.MODULE$.subscribe(stream, subscriber, async);
    }

    public StreamSubscription(Stream<F, A> stream, Flow.Subscriber<A> subscriber, AtomicLong requests, AtomicReference<Function0<BoxedUnit>> resume, AtomicReference<Function0<BoxedUnit>> canceled, Async<F> F) {
        this.stream = stream;
        this.subscriber = subscriber;
        this.requests = requests;
        this.resume = resume;
        this.canceled = canceled;
        this.F = F;
    }

    private void onError(Throwable ex) {
        this.cancel();
        this.subscriber.onError(ex);
    }

    private void onComplete() {
        this.cancel();
        this.subscriber.onComplete();
    }

    public Stream<F, Nothing$> run() {
        Function1 & Serializable subscriptionPipe = (Function1 & Serializable)in -> {
            Pull pull = Pull$.MODULE$.StreamPullOps(this.go$1((Stream)in));
            return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
        };
        Stream<F, Nothing$> events = this.stream.through(subscriptionPipe).chunks().foreach((Function1 & Serializable)chunk -> this.F.delay((Function0 & Serializable)() -> {
            this.$anonfun$2$$anonfun$1((Chunk)chunk);
            return BoxedUnit.UNIT;
        })).onFinalizeCase((Function1<Resource.ExitCase, Object>)(Function1 & Serializable)x$1 -> {
            Resource.ExitCase exitCase = x$1;
            cats.effect.package$.MODULE$.Resource();
            if (Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase)) {
                return this.F.delay((Function0 & Serializable)() -> {
                    this.$anonfun$3$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            if (exitCase instanceof Resource.ExitCase$.Errored) {
                Throwable throwable;
                cats.effect.package$.MODULE$.Resource();
                Resource.ExitCase$.Errored errored = Resource.ExitCase$.Errored$.MODULE$.unapply((Resource.ExitCase$.Errored)exitCase);
                Throwable ex = throwable = errored._1();
                return this.F.delay((Function0 & Serializable)() -> {
                    this.$anonfun$3$$anonfun$2(ex);
                    return BoxedUnit.UNIT;
                });
            }
            cats.effect.package$.MODULE$.Resource();
            if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                return this.F.unit();
            }
            throw new MatchError((Object)exitCase);
        }, this.F);
        Object cancellation = this.F.asyncCheckAttempt((Function1 & Serializable)cb -> this.F.delay(() -> this.$anonfun$4$$anonfun$1(cb)));
        return events.mergeHaltBoth(Stream$.MODULE$.exec(cancellation), this.F).onFinalizeCase((Function1<Resource.ExitCase, Object>)(Function1 & Serializable)x$1 -> {
            Resource.ExitCase exitCase = x$1;
            cats.effect.package$.MODULE$.Resource();
            if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                return this.F.delay((Function0 & Serializable)() -> {
                    this.run$$anonfun$1$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            return this.F.unit();
        }, this.F);
    }

    @Override
    public final void cancel() {
        Function0 cancelCB = this.canceled.getAndSet(null);
        if (cancelCB != null) {
            cancelCB.apply$mcV$sp();
            return;
        }
    }

    @Override
    public final void request(long n) {
        if (this.canceled.get() != null) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException(new StringBuilder(29).append("Invalid number of elements [").append(n).append("]").toString()));
                return;
            }
            this.requests.updateAndGet(r -> {
                long result = r + n;
                if (result < 0L) {
                    return Long.MAX_VALUE;
                }
                return result;
            });
            this.resume.getAndSet(StreamSubscription$.fs2$interop$flow$StreamSubscription$$$Sentinel).apply$mcV$sp();
            return;
        }
    }

    private final long go$1$$anonfun$1() {
        return this.requests.getAndSet(0L);
    }

    private final Either go$1$$anonfun$2$$anonfun$1$$anonfun$1(Function1 cb$1) {
        this.resume.set((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cb$1.apply((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()))));
        if (this.requests.get() > 0L) {
            this.resume.set(StreamSubscription$.fs2$interop$flow$StreamSubscription$$$Sentinel);
            return EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
        }
        return package$.MODULE$.Left().apply((Object)Some$.MODULE$.apply(this.F.unit()));
    }

    private final Pull go$1$$anonfun$2$$anonfun$2(Stream s$2) {
        return this.go$1(s$2);
    }

    private final /* synthetic */ Pull go$1$$anonfun$2(Stream s$1, long n) {
        if (n == Long.MAX_VALUE) {
            Stream stream = Stream$.MODULE$.InvariantOps(s$1);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream$ToPull$.MODULE$.echo$extension(stream2);
        }
        if (n == 0L) {
            return Pull$.MODULE$.eval(this.F.asyncCheckAttempt((Function1 & Serializable)cb -> this.F.delay(() -> this.go$1$$anonfun$2$$anonfun$1$$anonfun$1(cb)))).$greater$greater(() -> this.go$1$$anonfun$2$$anonfun$2(s$1));
        }
        Stream stream = Stream$.MODULE$.InvariantOps(s$1);
        Stream stream3 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream$ToPull$.MODULE$.take$extension(stream3, n).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            if (option instanceof Some) {
                Stream rem = (Stream)((Some)option).value();
                return this.go$1(rem);
            }
            throw new MatchError((Object)option);
        });
    }

    private final Pull go$1(Stream s2) {
        return Pull$.MODULE$.eval(this.F.delay(this::go$1$$anonfun$1)).flatMap((Function1 & Serializable)n -> this.go$1$$anonfun$2(s2, BoxesRunTime.unboxToLong((Object)n)));
    }

    private final void $anonfun$2$$anonfun$1(Chunk chunk$1) {
        chunk$1.foreach((JProcedure1 & Serializable)x$0 -> this.subscriber.onNext(x$0));
    }

    private final void $anonfun$3$$anonfun$1() {
        this.onComplete();
    }

    private final void $anonfun$3$$anonfun$2(Throwable ex$1) {
        this.onError(ex$1);
    }

    private final Either $anonfun$4$$anonfun$1(Function1 cb$3) {
        if (!this.canceled.compareAndSet(StreamSubscription$.fs2$interop$flow$StreamSubscription$$$Sentinel, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cb$3.apply((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()))))) {
            return EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
        }
        return package$.MODULE$.Left().apply((Object)Some$.MODULE$.apply(this.F.unit()));
    }

    private final void run$$anonfun$1$$anonfun$1() {
        this.onError(new CancellationException("StreamSubscription.run was canceled"));
    }
}

