/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Functor;
import cats.effect.kernel.Clock;
import cats.kernel.Hash;
import cats.kernel.Order;
import cats.parse.Parser;
import cats.parse.Parser$;
import cats.parse.Parser0;
import cats.parse.Rfc5234$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.http4s.HttpDate;
import org.http4s.ParseFailure;
import org.http4s.ParseResult$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class HttpDate$
implements Serializable {
    private static final long MinEpochSecond;
    private static final long MaxEpochSecond;
    private static final Hash catsOrderForHttp4sHttpDate;
    private static final HttpDate MinValue;
    private static final HttpDate MaxValue;
    private static final HttpDate Epoch;
    private static final Parser imfFixdate;
    private static final Parser parser;
    private static final Ordering stdLibOrderingInstance;
    public static final HttpDate$ MODULE$;

    private HttpDate$() {
    }

    static {
        MODULE$ = new HttpDate$();
        MinEpochSecond = -2208988800L;
        MaxEpochSecond = 253402300799L;
        catsOrderForHttp4sHttpDate = (Hash)new Order<HttpDate>(){

            public int compare(HttpDate x, HttpDate y) {
                return Predef$.MODULE$.long2Long(x.epochSecond()).compareTo(Predef$.MODULE$.long2Long(y.epochSecond()));
            }

            public int hash(HttpDate x) {
                return x.hashCode();
            }
        };
        MinValue = MODULE$.unsafeFromEpochSecond(MinEpochSecond);
        MaxValue = MODULE$.unsafeFromEpochSecond(MaxEpochSecond);
        Epoch = MODULE$.unsafeFromEpochSecond(0L);
        Parser.Soft dayName = ((Parser)((List)((List)new .colon.colon((Object)"Mon", (List)new .colon.colon((Object)"Tue", (List)new .colon.colon((Object)"Wed", (List)new .colon.colon((Object)"Thu", (List)new .colon.colon((Object)"Fri", (List)new .colon.colon((Object)"Sat", (List)new .colon.colon((Object)"Sun", (List)Nil$.MODULE$)))))))).map((Function1 & Serializable)str -> Parser$.MODULE$.string(str)).zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Parser s2 = (Parser)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return Parser$.MODULE$.string(s2).as((Object)BoxesRunTime.boxToInteger((int)i));
            }
            throw new MatchError((Object)tuple2);
        }).reduceLeft((Function2 & Serializable)(_$4, _$5) -> _$4.orElse(_$5))).soft();
        Parser day = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$6)));
        Parser month = (Parser)((List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}))).zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String s2 = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return Parser$.MODULE$.string(s2).as((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
            }
            throw new MatchError((Object)tuple2);
        }).reduceLeft((Function2 & Serializable)(_$7, _$8) -> _$7.orElse(_$8));
        Parser year = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).$tilde((Parser0)Rfc5234$.MODULE$.digit()).$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$9 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$9)));
        Parser date1 = day.$less$times((Parser0)Rfc5234$.MODULE$.sp()).$tilde((Parser0)month.$less$times((Parser0)Rfc5234$.MODULE$.sp())).$tilde((Parser0)year);
        Parser hour = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$10 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$10)));
        Parser minute = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$11 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$11)));
        Parser second = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$12 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$12)));
        Parser colon2 = Parser$.MODULE$.char(':');
        Parser timeOfDay = hour.$less$times((Parser0)colon2).$tilde((Parser0)minute.$less$times((Parser0)colon2)).$tilde((Parser0)second);
        imfFixdate = dayName.$less$times((Parser0)Parser$.MODULE$.string(", ")).$tilde((Parser0)date1.$less$times((Parser0)Rfc5234$.MODULE$.sp())).$tilde((Parser0)timeOfDay.$less$times((Parser0)Parser$.MODULE$.string(" GMT"))).mapFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22;
                Tuple2 tuple23;
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple24 != null && (tuple23 = (Tuple2)tuple24._2()) != null && (tuple22 = (Tuple2)tuple23._1()) != null) {
                    Tuple2 tuple26;
                    int day = tuple22._1$mcI$sp();
                    int month = tuple22._2$mcI$sp();
                    int year = BoxesRunTime.unboxToInt((Object)tuple23._2());
                    if (tuple25 != null && (tuple26 = (Tuple2)tuple25._1()) != null) {
                        int hour = tuple26._1$mcI$sp();
                        int min2 = tuple26._2$mcI$sp();
                        int sec = BoxesRunTime.unboxToInt((Object)tuple25._2());
                        return this.mkHttpDate(year, month, day, hour, min2, sec);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Parser twoDigit = Rfc5234$.MODULE$.digit().$tilde((Parser0)Rfc5234$.MODULE$.digit()).string().map((Function1 & Serializable)_$13 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$13)));
        Parser date2 = day.$less$times((Parser0)Parser$.MODULE$.char('-')).$tilde((Parser0)month.$less$times((Parser0)Parser$.MODULE$.char('-'))).$tilde((Parser0)twoDigit);
        Parser dayNameL = (Parser)((List)new .colon.colon((Object)"Monday", (List)new .colon.colon((Object)"Tuesday", (List)new .colon.colon((Object)"Wednesday", (List)new .colon.colon((Object)"Thursday", (List)new .colon.colon((Object)"Friday", (List)new .colon.colon((Object)"Saturday", (List)new .colon.colon((Object)"Sunday", (List)Nil$.MODULE$)))))))).map((Function1 & Serializable)str -> Parser$.MODULE$.string(str)).reduceLeft((Function2 & Serializable)(_$14, _$15) -> _$14.orElse(_$15));
        Parser rfc850Date = dayNameL.$less$times((Parser0)Parser$.MODULE$.string(", ")).$tilde((Parser0)date2.$less$times((Parser0)Rfc5234$.MODULE$.sp())).$tilde((Parser0)timeOfDay.$less$times((Parser0)Parser$.MODULE$.string(" GMT"))).mapFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22;
                Tuple2 tuple23;
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple24 != null && (tuple23 = (Tuple2)tuple24._2()) != null && (tuple22 = (Tuple2)tuple23._1()) != null) {
                    Tuple2 tuple26;
                    int day = tuple22._1$mcI$sp();
                    int month = tuple22._2$mcI$sp();
                    int year = BoxesRunTime.unboxToInt((Object)tuple23._2());
                    if (tuple25 != null && (tuple26 = (Tuple2)tuple25._1()) != null) {
                        int hour = tuple26._1$mcI$sp();
                        int min2 = tuple26._2$mcI$sp();
                        int sec = BoxesRunTime.unboxToInt((Object)tuple25._2());
                        int wrapYear = year < 70 ? year + 2000 : year + 1900;
                        return this.mkHttpDate(wrapYear, month, day, hour, min2, sec);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Parser oneDigit = Rfc5234$.MODULE$.digit().map((Function1 & Serializable)_$16 -> this.$anonfun$5(BoxesRunTime.unboxToChar((Object)_$16)));
        Parser date3 = month.$less$times((Parser0)Rfc5234$.MODULE$.sp()).$tilde((Parser0)twoDigit.orElse(Rfc5234$.MODULE$.sp().$times$greater((Parser0)oneDigit)));
        Parser asctimeDate = dayName.$less$times((Parser0)Rfc5234$.MODULE$.sp()).$tilde((Parser0)date3.$less$times((Parser0)Rfc5234$.MODULE$.sp())).$tilde((Parser0)timeOfDay.$less$times((Parser0)Rfc5234$.MODULE$.sp())).$tilde((Parser0)year).mapFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Tuple2 tuple23;
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple24 != null && (tuple23 = (Tuple2)tuple24._2()) != null) {
                    Tuple2 tuple26;
                    int month = tuple23._1$mcI$sp();
                    int day = tuple23._2$mcI$sp();
                    if (tuple25 != null && (tuple26 = (Tuple2)tuple25._1()) != null) {
                        int hour = tuple26._1$mcI$sp();
                        int min2 = tuple26._2$mcI$sp();
                        int sec = BoxesRunTime.unboxToInt((Object)tuple25._2());
                        int year = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        return this.mkHttpDate(year, month, day, hour, min2, sec);
                    }
                }
            }
            throw new MatchError((Object)tuple22);
        });
        Parser obsDate = rfc850Date.orElse(asctimeDate);
        parser = MODULE$.imfFixdate().orElse(obsDate);
        stdLibOrderingInstance = ((Order)MODULE$.catsOrderForHttp4sHttpDate()).toOrdering();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpDate$.class);
    }

    public Hash<HttpDate> catsOrderForHttp4sHttpDate() {
        return catsOrderForHttp4sHttpDate;
    }

    public HttpDate MinValue() {
        return MinValue;
    }

    public HttpDate MaxValue() {
        return MaxValue;
    }

    public HttpDate now() {
        return this.unsafeFromInstant(Instant.now());
    }

    public <F> Object current(Functor<F> evidence$1, Clock<F> evidence$2) {
        return package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Clock().apply(evidence$2).realTime(), evidence$1).map((Function1 & Serializable)v -> MODULE$.unsafeFromEpochSecond(v.toSeconds()));
    }

    public HttpDate Epoch() {
        return Epoch;
    }

    public Either<ParseFailure, HttpDate> fromString(String s2) {
        return ParseResult$.MODULE$.fromParser(this.parser(), (Function0<String>)((Function0 & Serializable)HttpDate$::fromString$$anonfun$1), s2);
    }

    public HttpDate unsafeFromString(String s2) {
        return (HttpDate)this.fromString(s2).fold((Function1 & Serializable)_$2 -> {
            throw _$2;
        }, (Function1 & Serializable)x -> (HttpDate)Predef$.MODULE$.identity(x));
    }

    public Either<ParseFailure, HttpDate> fromEpochSecond(long epochSecond) {
        if (epochSecond < MinEpochSecond || epochSecond > MaxEpochSecond) {
            return ParseResult$.MODULE$.fail("Invalid HTTP date", new StringBuilder(61).append(epochSecond).append(" out of range for HTTP date. Must be between ").append(MinEpochSecond).append(" and ").append(MaxEpochSecond).append(", inclusive").toString());
        }
        return ParseResult$.MODULE$.success(new HttpDate(epochSecond));
    }

    public HttpDate unsafeFromEpochSecond(long epochSecond) {
        return (HttpDate)this.fromEpochSecond(epochSecond).fold((Function1 & Serializable)_$3 -> {
            throw _$3;
        }, (Function1 & Serializable)x -> (HttpDate)Predef$.MODULE$.identity(x));
    }

    public Either<ParseFailure, HttpDate> fromInstant(Instant instant) {
        return this.fromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public HttpDate unsafeFromInstant(Instant instant) {
        return this.unsafeFromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public Either<ParseFailure, HttpDate> fromZonedDateTime(ZonedDateTime dateTime) {
        return this.fromInstant(dateTime.toInstant());
    }

    public HttpDate unsafeFromZonedDateTime(ZonedDateTime dateTime) {
        return this.unsafeFromInstant(dateTime.toInstant());
    }

    private Option<HttpDate> mkHttpDate(int year, int month, int day, int hour, int min2, int sec) {
        None$ none$;
        try {
            ZonedDateTime dt = ZonedDateTime.of(year, month, day, hour, min2, sec, 0, ZoneOffset.UTC);
            none$ = Some$.MODULE$.apply((Object)this.unsafeFromZonedDateTime(dt));
        }
        catch (DateTimeException dateTimeException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Parser<HttpDate> imfFixdate() {
        return imfFixdate;
    }

    public Parser<HttpDate> parser() {
        return parser;
    }

    public Ordering<HttpDate> stdLibOrderingInstance() {
        return stdLibOrderingInstance;
    }

    private final /* synthetic */ int $anonfun$5(char _$16) {
        return _$16 - 48;
    }

    private static final String fromString$$anonfun$1() {
        return "Invalid HTTP date";
    }
}

