/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Contravariant;
import cats.Show;
import cats.kernel.Hash;
import cats.kernel.Order;
import com.comcast.ip4s.Hostname;
import com.comcast.ip4s.Hostname$;
import com.comcast.ip4s.IpAddress;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.http4s.HttpCodec;
import org.http4s.ParseFailure;
import org.http4s.Query;
import org.http4s.QueryOps;
import org.http4s.Uri$;
import org.http4s.Uri$Authority$;
import org.http4s.Uri$Host$;
import org.http4s.Uri$Ipv4Address$;
import org.http4s.Uri$Ipv6Address$;
import org.http4s.Uri$Path$;
import org.http4s.Uri$Path$Segment$;
import org.http4s.Uri$Path$SegmentEncoder$;
import org.http4s.Uri$RegName$;
import org.http4s.Uri$Scheme$;
import org.http4s.Uri$UserInfo$;
import org.http4s.internal.CharPredicate;
import org.http4s.internal.package$;
import org.http4s.util.Renderable;
import org.http4s.util.Renderable$;
import org.http4s.util.Renderer;
import org.http4s.util.Writer;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public final class Uri
implements QueryOps,
Renderable,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Uri.class.getDeclaredField("renderString$lzy1"));
    private final Option scheme;
    private final Option authority;
    private final Path path;
    private final Query query;
    private final Option fragment;
    private volatile Object renderString$lzy1;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Uri$.class.getDeclaredField("SkipEncodeInPath$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Uri$.class.getDeclaredField("toSkip$lzy1"));

    public static CharPredicate Unreserved() {
        return Uri$.MODULE$.Unreserved();
    }

    public static Uri apply(Option<Scheme> option, Option<Authority> option2, Path path, Query query, Option<String> option3) {
        return Uri$.MODULE$.apply(option, option2, path, query, option3);
    }

    public static Show<Uri> catsInstancesForHttp4sUri() {
        return Uri$.MODULE$.catsInstancesForHttp4sUri();
    }

    public static String decode(String string, Charset charset, boolean bl, Function1<Object, Object> function1) {
        return Uri$.MODULE$.decode(string, charset, bl, function1);
    }

    public static String encode(String string, Charset charset, boolean bl, Function1<Object, Object> function1) {
        return Uri$.MODULE$.encode(string, charset, bl, function1);
    }

    public static Uri fromProduct(Product product) {
        return Uri$.MODULE$.fromProduct(product);
    }

    public static Either<ParseFailure, Uri> fromString(String string) {
        return Uri$.MODULE$.fromString(string);
    }

    public static String pathEncode(String string, Charset charset) {
        return Uri$.MODULE$.pathEncode(string, charset);
    }

    public static Path removeDotSegments(Path path) {
        return Uri$.MODULE$.removeDotSegments(path);
    }

    public static Either<ParseFailure, Uri> requestTarget(String string) {
        return Uri$.MODULE$.requestTarget(string);
    }

    public static Uri unapply(Uri uri) {
        return Uri$.MODULE$.unapply(uri);
    }

    public static Uri unsafeFromString(String string) {
        return Uri$.MODULE$.unsafeFromString(string);
    }

    public static Option<Scheme> $lessinit$greater$default$1() {
        return Uri$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Authority> $lessinit$greater$default$2() {
        return Uri$.MODULE$.$lessinit$greater$default$2();
    }

    public static Charset decode$default$2() {
        return Uri$.MODULE$.decode$default$2();
    }

    public static Charset encode$default$2() {
        return Uri$.MODULE$.encode$default$2();
    }

    public static Charset pathEncode$default$2() {
        return Uri$.MODULE$.pathEncode$default$2();
    }

    public static Path $lessinit$greater$default$3() {
        return Uri$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean decode$default$3() {
        return Uri$.MODULE$.decode$default$3();
    }

    public static boolean encode$default$3() {
        return Uri$.MODULE$.encode$default$3();
    }

    public static Query $lessinit$greater$default$4() {
        return Uri$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function1<Object, Object> decode$default$4() {
        return Uri$.MODULE$.decode$default$4();
    }

    public static Function1<Object, Object> encode$default$4() {
        return Uri$.MODULE$.encode$default$4();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return Uri$.MODULE$.$lessinit$greater$default$5();
    }

    public Uri(Option<Scheme> scheme, Option<Authority> authority, Path path, Query query, Option<String> fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Uri)) return false;
        Uri uri = (Uri)object;
        Option<Scheme> option = this.scheme();
        Option<Scheme> option2 = uri.scheme();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Authority> option3 = this.authority();
        Option<Authority> option4 = uri.authority();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Path path = this.path();
        Path path2 = uri.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Query query = this.query();
        Query query2 = uri.query();
        if (query == null) {
            if (query2 != null) {
                return false;
            }
        } else if (!((Object)query).equals(query2)) return false;
        Option<String> option5 = this.fragment();
        Option<String> option6 = uri.fragment();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Uri;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Uri";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "scheme";
            }
            case 1: {
                return "authority";
            }
            case 2: {
                return "path";
            }
            case 3: {
                return "query";
            }
            case 4: {
                return "fragment";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Scheme> scheme() {
        return this.scheme;
    }

    public Option<Authority> authority() {
        return this.authority;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public Query query() {
        return this.query;
    }

    public Option<String> fragment() {
        return this.fragment;
    }

    public Uri withPath(String path) {
        Path path2 = Uri$Path$.MODULE$.unsafeFromString(path);
        Option<Scheme> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        Query query = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        return this.copy(option, option2, path2, query, option3);
    }

    public Uri withPath(Path path) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), path, this.copy$default$4(), this.copy$default$5());
    }

    public Uri withFragment(String fragment) {
        Option option = Option$.MODULE$.apply((Object)fragment);
        Option<Scheme> option2 = this.copy$default$1();
        Option<Authority> option3 = this.copy$default$2();
        Path path = this.copy$default$3();
        Query query = this.copy$default$4();
        return this.copy(option2, option3, path, query, (Option<String>)option);
    }

    public Uri withoutFragment() {
        Option option = Option$.MODULE$.empty();
        Option<Scheme> option2 = this.copy$default$1();
        Option<Authority> option3 = this.copy$default$2();
        Path path = this.copy$default$3();
        Query query = this.copy$default$4();
        return this.copy(option2, option3, path, query, (Option<String>)option);
    }

    public Uri addSegment(String newSegment) {
        return this.addSegment(newSegment, Uri$Path$SegmentEncoder$.MODULE$.stringSegmentEncoder());
    }

    public <A> Uri addSegment(A newSegment, Path.SegmentEncoder<A> evidence$1) {
        Path path = this.path().$div(newSegment, evidence$1);
        Option<Scheme> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        Query query = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        return this.copy(option, option2, path, query, option3);
    }

    public Uri $div(String newSegment) {
        return this.addSegment(newSegment, Uri$Path$SegmentEncoder$.MODULE$.stringSegmentEncoder());
    }

    public <A> Uri $div(A newSegment, Path.SegmentEncoder<A> evidence$1) {
        return this.addSegment(newSegment, evidence$1);
    }

    public Uri addPath(String morePath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])morePath.split("/"));
        Path path = (Path)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)this.path(), (Function2 & Serializable)(p, segment) -> p.addSegment(segment, Uri$Path$SegmentEncoder$.MODULE$.stringSegmentEncoder()));
        Option<Scheme> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        Query query = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        return this.copy(option, option2, path, query, option3);
    }

    public Option<Host> host() {
        return this.authority().map((Function1 & Serializable)_$1 -> _$1.host());
    }

    public Option<Object> port() {
        return this.authority().flatMap((Function1 & Serializable)_$2 -> _$2.port());
    }

    public Option<UserInfo> userInfo() {
        return this.authority().flatMap((Function1 & Serializable)_$3 -> _$3.userInfo());
    }

    public Uri resolve(Uri relative) {
        return Uri$.MODULE$.resolve(this, relative);
    }

    public Map<String, Seq<String>> multiParams() {
        return this.query().multiParams();
    }

    public Map<String, String> params() {
        return this.query().params();
    }

    @Override
    public String renderString() {
        Object object = this.renderString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.renderString$lzyINIT1();
    }

    private Object renderString$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.renderString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Renderable.renderString$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.renderString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Writer render(Writer writer) {
        block13: {
            block11: {
                block12: {
                    var2_2 = this;
                    if (var2_2 == null) ** GOTO lbl-1000
                    var3_3 = Uri$.MODULE$.unapply(var2_2);
                    var4_4 = var3_3._1();
                    var5_5 = var3_3._2();
                    var6_6 = var3_3._3();
                    var7_7 = var3_3._4();
                    var8_8 = var3_3._5();
                    if (!(var4_4 instanceof Some)) break block11;
                    s = var9_9 = (Scheme)((Some)var4_4).value();
                    if (!(var5_5 instanceof Some)) break block12;
                    a = (Authority)((Some)var5_5).value();
                    v0 /* !! */  = Uri.renderScheme$1(writer, s).$less$less("//").$less$less(a, Renderable$.MODULE$.renderableInst());
                    break block13;
                }
                s = var9_9;
                if (!None$.MODULE$.equals(var5_5)) break block11;
                v0 /* !! */  = Uri.renderScheme$1(writer, s);
                break block13;
            }
            if (!None$.MODULE$.equals(var4_4)) ** GOTO lbl-1000
            if (var5_5 instanceof Some) {
                a = (Authority)((Some)var5_5).value();
                v0 /* !! */  = writer.$less$less("//").$less$less(a, Renderable$.MODULE$.renderableInst());
            } else if (None$.MODULE$.equals(var5_5)) {
                v0 /* !! */  = BoxedUnit.UNIT;
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var2_2);
            }
        }
        var14_14 = this;
        if (var14_14 != null) {
            var15_15 = Uri$.MODULE$.unapply(var14_14);
            var16_16 = var15_15._1();
            var17_17 = var15_15._2();
            var18_18 = var15_15._3();
            var19_19 = var15_15._4();
            var20_20 = var15_15._5();
            if (var17_17 instanceof Some && (p = var18_18).nonEmpty() && !p.absolute()) {
                v1 = writer.$less$less("/").$less$less(p, Renderable$.MODULE$.renderableInst());
            } else if (None$.MODULE$.equals(var16_16) && None$.MODULE$.equals(var17_17)) {
                p = var18_18;
                v1 = !p.absolute() && BoxesRunTime.unboxToBoolean((Object)p.segments().headOption().fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, render$$anonfun$1(), ()Z)(), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, render$$anonfun$2(org.http4s.Uri$Path$Segment ), (Lorg/http4s/Uri$Path$Segment;)Z)())) ? writer.$less$less("./").$less$less(p, Renderable$.MODULE$.renderableInst()) : writer.$less$less(p, Renderable$.MODULE$.renderableInst());
            } else {
                p = var18_18;
                v1 = writer.$less$less(p, Renderable$.MODULE$.renderableInst());
            }
        } else {
            throw new MatchError((Object)var14_14);
        }
        if (this.query().nonEmpty()) {
            writer.$less$less('?').$less$less(this.query(), Renderable$.MODULE$.renderableInst());
        }
        this.fragment().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, render$$anonfun$3(org.http4s.util.Writer java.lang.String ), (Ljava/lang/String;)Lorg/http4s/util/Writer;)((Writer)writer));
        return writer;
    }

    @Override
    public Uri self() {
        return this;
    }

    @Override
    public Uri replaceQuery(Query query) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), query, this.copy$default$5());
    }

    public Uri toOriginForm() {
        Path path = this.path().toAbsolute();
        Option<Scheme> option = Uri$.MODULE$.$lessinit$greater$default$1();
        Option<Authority> option2 = Uri$.MODULE$.$lessinit$greater$default$2();
        Option<String> option3 = Uri$.MODULE$.$lessinit$greater$default$5();
        return Uri$.MODULE$.apply(option, option2, path, this.query(), option3);
    }

    public Uri copy(Option<Scheme> scheme, Option<Authority> authority, Path path, Query query, Option<String> fragment) {
        return new Uri(scheme, authority, path, query, fragment);
    }

    public Option<Scheme> copy$default$1() {
        return this.scheme();
    }

    public Option<Authority> copy$default$2() {
        return this.authority();
    }

    public Path copy$default$3() {
        return this.path();
    }

    public Query copy$default$4() {
        return this.query();
    }

    public Option<String> copy$default$5() {
        return this.fragment();
    }

    public Option<Scheme> _1() {
        return this.scheme();
    }

    public Option<Authority> _2() {
        return this.authority();
    }

    public Path _3() {
        return this.path();
    }

    public Query _4() {
        return this.query();
    }

    public Option<String> _5() {
        return this.fragment();
    }

    private static final Writer renderScheme$1(Writer writer$1, Scheme s2) {
        return writer$1.$less$less(s2, Uri$Scheme$.MODULE$.http4sInstancesForScheme()).$less$less(':');
    }

    private static final boolean render$$anonfun$1() {
        return false;
    }

    private static final /* synthetic */ boolean render$$anonfun$2(Path.Segment _$4) {
        return _$4.toString().contains(":");
    }

    private static final /* synthetic */ Writer render$$anonfun$3(Writer writer$2, String f) {
        return writer$2.$less$less('#').$less$less(Uri$.MODULE$.encode(f, Uri$.MODULE$.encode$default$2(), false, Uri$.MODULE$.encode$default$4()));
    }

    public static final class Authority
    implements Renderable,
    Product,
    Serializable {
        private final Option userInfo;
        private final Host host;
        private final Option port;

        public static Authority apply(Option<UserInfo> option, Host host, Option<Object> option2) {
            return Uri$Authority$.MODULE$.apply(option, host, option2);
        }

        public static Show<Authority> catsInstancesForHttp4sAuthority() {
            return Uri$Authority$.MODULE$.catsInstancesForHttp4sAuthority();
        }

        public static Authority fromProduct(Product product) {
            return Uri$Authority$.MODULE$.fromProduct(product);
        }

        public static Authority unapply(Authority authority) {
            return Uri$Authority$.MODULE$.unapply(authority);
        }

        public static Option<UserInfo> $lessinit$greater$default$1() {
            return Uri$Authority$.MODULE$.$lessinit$greater$default$1();
        }

        public static Host $lessinit$greater$default$2() {
            return Uri$Authority$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Object> $lessinit$greater$default$3() {
            return Uri$Authority$.MODULE$.$lessinit$greater$default$3();
        }

        public Authority(Option<UserInfo> userInfo, Host host, Option<Object> port) {
            this.userInfo = userInfo;
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Authority)) return false;
            Authority authority = (Authority)object;
            Option<UserInfo> option = this.userInfo();
            Option<UserInfo> option2 = authority.userInfo();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Host host = this.host();
            Host host2 = authority.host();
            if (host == null) {
                if (host2 != null) {
                    return false;
                }
            } else if (!host.equals(host2)) return false;
            Option<Object> option3 = this.port();
            Option<Object> option4 = authority.port();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Authority;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Authority";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "userInfo";
                }
                case 1: {
                    return "host";
                }
                case 2: {
                    return "port";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<UserInfo> userInfo() {
            return this.userInfo;
        }

        public Host host() {
            return this.host;
        }

        public Option<Object> port() {
            return this.port;
        }

        @Override
        public Writer render(Writer writer) {
            Authority authority = this;
            if (authority != null) {
                Authority authority2 = Uri$Authority$.MODULE$.unapply(authority);
                Option<UserInfo> option = authority2._1();
                Host host = authority2._2();
                Option<Object> option2 = authority2._3();
                if (option instanceof Some) {
                    UserInfo userInfo;
                    UserInfo u = userInfo = (UserInfo)((Some)option).value();
                    Host h = host;
                    if (None$.MODULE$.equals(option2)) {
                        return writer.$less$less(u, (Renderer)Uri$UserInfo$.MODULE$.http4sInstancesForUserInfo()).$less$less('@').$less$less(h, Renderable$.MODULE$.renderableInst());
                    }
                    UserInfo u2 = userInfo;
                    Host h2 = host;
                    if (option2 instanceof Some) {
                        int p = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                        return writer.$less$less(u2, (Renderer)Uri$UserInfo$.MODULE$.http4sInstancesForUserInfo()).$less$less('@').$less$less(h2, Renderable$.MODULE$.renderableInst()).$less$less(':').$less$less(p);
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    Host h = host;
                    if (option2 instanceof Some) {
                        int p = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                        return writer.$less$less(h, Renderable$.MODULE$.renderableInst()).$less$less(':').$less$less(p);
                    }
                }
                Host h = host;
                return writer.$less$less(h, Renderable$.MODULE$.renderableInst());
            }
            throw new MatchError((Object)authority);
        }

        public Authority copy(Option<UserInfo> userInfo, Host host, Option<Object> port) {
            return new Authority(userInfo, host, port);
        }

        public Option<UserInfo> copy$default$1() {
            return this.userInfo();
        }

        public Host copy$default$2() {
            return this.host();
        }

        public Option<Object> copy$default$3() {
            return this.port();
        }

        public Option<UserInfo> _1() {
            return this.userInfo();
        }

        public Host _2() {
            return this.host();
        }

        public Option<Object> _3() {
            return this.port();
        }
    }

    public static interface Host
    extends Renderable {
        public static Show<Host> catsInstancesForHttp4sUriHost() {
            return Uri$Host$.MODULE$.catsInstancesForHttp4sUriHost();
        }

        public static Host fromIp4sHost(com.comcast.ip4s.Host host) {
            return Uri$Host$.MODULE$.fromIp4sHost(host);
        }

        public static Host fromIpAddress(IpAddress ipAddress) {
            return Uri$Host$.MODULE$.fromIpAddress(ipAddress);
        }

        public static Either<ParseFailure, Host> fromString(String string) {
            return Uri$Host$.MODULE$.fromString(string);
        }

        public static int ordinal(Host host) {
            return Uri$Host$.MODULE$.ordinal(host);
        }

        public static Host unsafeFromString(String string) {
            return Uri$Host$.MODULE$.unsafeFromString(string);
        }

        public String value();

        public static Writer render$(Host $this, Writer writer) {
            return $this.render(writer);
        }

        @Override
        default public Writer render(Writer writer) {
            Host host = this;
            if (host instanceof RegName) {
                CIString cIString;
                RegName regName = Uri$RegName$.MODULE$.unapply((RegName)host);
                CIString n = cIString = regName._1();
                return writer.$less$less(Uri$.MODULE$.encode(n.toString(), Uri$.MODULE$.encode$default$2(), Uri$.MODULE$.encode$default$3(), Uri$.MODULE$.encode$default$4()));
            }
            if (host instanceof Ipv4Address) {
                Ipv4Address a = (Ipv4Address)host;
                return writer.$less$less(a.value());
            }
            if (host instanceof Ipv6Address) {
                Ipv6Address a = (Ipv6Address)host;
                return writer.$less$less('[').$less$less(a, (Renderer)Uri$Ipv6Address$.MODULE$.http4sInstancesForIpv6Address()).$less$less(']');
            }
            throw new MatchError((Object)host);
        }

        public static Option toIpAddress$(Host $this) {
            return $this.toIpAddress();
        }

        default public Option<IpAddress> toIpAddress() {
            Host host = this;
            if (host instanceof Ipv4Address) {
                com.comcast.ip4s.Ipv4Address ipv4Address;
                Ipv4Address ipv4Address2 = Uri$Ipv4Address$.MODULE$.unapply((Ipv4Address)host);
                com.comcast.ip4s.Ipv4Address a = ipv4Address = ipv4Address2._1();
                return Some$.MODULE$.apply((Object)a);
            }
            if (host instanceof Ipv6Address) {
                com.comcast.ip4s.Ipv6Address ipv6Address;
                Ipv6Address ipv6Address2 = Uri$Ipv6Address$.MODULE$.unapply((Ipv6Address)host);
                com.comcast.ip4s.Ipv6Address a = ipv6Address = ipv6Address2._1();
                return Some$.MODULE$.apply((Object)a);
            }
            if (host instanceof RegName) {
                RegName regName = Uri$RegName$.MODULE$.unapply((RegName)host);
                CIString cIString = regName._1();
                return None$.MODULE$;
            }
            throw new MatchError((Object)host);
        }
    }

    public static final class Ipv4Address
    implements Host,
    Ordered<Ipv4Address>,
    Serializable,
    Product {
        private final com.comcast.ip4s.Ipv4Address address;

        public static Ipv4Address apply(com.comcast.ip4s.Ipv4Address ipv4Address) {
            return Uri$Ipv4Address$.MODULE$.apply(ipv4Address);
        }

        public static Either<ParseFailure, Ipv4Address> fromByteArray(byte[] byArray) {
            return Uri$Ipv4Address$.MODULE$.fromByteArray(byArray);
        }

        public static Ipv4Address fromBytes(byte by, byte by2, byte by3, byte by4) {
            return Uri$Ipv4Address$.MODULE$.fromBytes(by, by2, by3, by4);
        }

        public static Ipv4Address fromInet4Address(Inet4Address inet4Address) {
            return Uri$Ipv4Address$.MODULE$.fromInet4Address(inet4Address);
        }

        public static Ipv4Address fromProduct(Product product) {
            return Uri$Ipv4Address$.MODULE$.fromProduct(product);
        }

        public static Either<ParseFailure, Ipv4Address> fromString(String string) {
            return Uri$Ipv4Address$.MODULE$.fromString(string);
        }

        public static Show<Ipv4Address> http4sInstancesForIpv4Address() {
            return Uri$Ipv4Address$.MODULE$.http4sInstancesForIpv4Address();
        }

        public static Ipv4Address unapply(Ipv4Address ipv4Address) {
            return Uri$Ipv4Address$.MODULE$.unapply(ipv4Address);
        }

        public static Ipv4Address unsafeFromString(String string) {
            return Uri$Ipv4Address$.MODULE$.unsafeFromString(string);
        }

        public Ipv4Address(com.comcast.ip4s.Ipv4Address address) {
            this.address = address;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ipv4Address)) return false;
            Ipv4Address ipv4Address = (Ipv4Address)object;
            com.comcast.ip4s.Ipv4Address ipv4Address2 = this.address();
            com.comcast.ip4s.Ipv4Address ipv4Address3 = ipv4Address.address();
            if (ipv4Address2 != null) {
                if (!((Object)ipv4Address2).equals(ipv4Address3)) return false;
                return true;
            }
            if (ipv4Address3 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Ipv4Address;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Ipv4Address";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public com.comcast.ip4s.Ipv4Address address() {
            return this.address;
        }

        @Override
        public String toString() {
            return new StringBuilder(13).append("Ipv4Address(").append(this.value()).append(")").toString();
        }

        public int compare(Ipv4Address that) {
            return this.address().compare(that.address());
        }

        public byte[] toByteArray() {
            return this.address().toBytes();
        }

        public Inet4Address toInet4Address() {
            return this.address().toInetAddress();
        }

        @Override
        public String value() {
            return this.address().toString();
        }

        public Ipv4Address copy(com.comcast.ip4s.Ipv4Address address) {
            return new Ipv4Address(address);
        }

        public com.comcast.ip4s.Ipv4Address copy$default$1() {
            return this.address();
        }

        public com.comcast.ip4s.Ipv4Address _1() {
            return this.address();
        }
    }

    public static final class Ipv6Address
    implements Host,
    Ordered<Ipv6Address>,
    Serializable,
    Product {
        private final com.comcast.ip4s.Ipv6Address address;

        public static Ipv6Address apply(com.comcast.ip4s.Ipv6Address ipv6Address) {
            return Uri$Ipv6Address$.MODULE$.apply(ipv6Address);
        }

        public static Either<ParseFailure, Ipv6Address> fromByteArray(byte[] byArray) {
            return Uri$Ipv6Address$.MODULE$.fromByteArray(byArray);
        }

        public static Ipv6Address fromInet6Address(Inet6Address inet6Address) {
            return Uri$Ipv6Address$.MODULE$.fromInet6Address(inet6Address);
        }

        public static Ipv6Address fromProduct(Product product) {
            return Uri$Ipv6Address$.MODULE$.fromProduct(product);
        }

        public static Ipv6Address fromShorts(short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9) {
            return Uri$Ipv6Address$.MODULE$.fromShorts(s2, s3, s4, s5, s6, s7, s8, s9);
        }

        public static Either<ParseFailure, Ipv6Address> fromString(String string) {
            return Uri$Ipv6Address$.MODULE$.fromString(string);
        }

        public static Show<Ipv6Address> http4sInstancesForIpv6Address() {
            return Uri$Ipv6Address$.MODULE$.http4sInstancesForIpv6Address();
        }

        public static Ipv6Address unapply(Ipv6Address ipv6Address) {
            return Uri$Ipv6Address$.MODULE$.unapply(ipv6Address);
        }

        public static Ipv6Address unsafeFromString(String string) {
            return Uri$Ipv6Address$.MODULE$.unsafeFromString(string);
        }

        public Ipv6Address(com.comcast.ip4s.Ipv6Address address) {
            this.address = address;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ipv6Address)) return false;
            Ipv6Address ipv6Address = (Ipv6Address)object;
            com.comcast.ip4s.Ipv6Address ipv6Address2 = this.address();
            com.comcast.ip4s.Ipv6Address ipv6Address3 = ipv6Address.address();
            if (ipv6Address2 != null) {
                if (!((Object)ipv6Address2).equals(ipv6Address3)) return false;
                return true;
            }
            if (ipv6Address3 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Ipv6Address;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Ipv6Address";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public com.comcast.ip4s.Ipv6Address address() {
            return this.address;
        }

        public int compare(Ipv6Address that) {
            return this.address().compare(that.address());
        }

        public byte[] toByteArray() {
            return this.address().toBytes();
        }

        public InetAddress toInetAddress() {
            return this.address().toInetAddress();
        }

        @Override
        public String value() {
            return this.address().toString();
        }

        public Ipv6Address copy(com.comcast.ip4s.Ipv6Address address) {
            return new Ipv6Address(address);
        }

        public com.comcast.ip4s.Ipv6Address copy$default$1() {
            return this.address();
        }

        public com.comcast.ip4s.Ipv6Address _1() {
            return this.address();
        }
    }

    public static final class Path
    implements Renderable {
        private final Vector segments;
        private final boolean absolute;
        private final boolean endsWithSlash;
        private final String renderString;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Uri$Path$.class.getDeclaredField("Asterisk$lzy1"));

        public static Path Asterisk() {
            return Uri$Path$.MODULE$.Asterisk();
        }

        public static Path Root() {
            return Uri$Path$.MODULE$.Root();
        }

        public static Path apply(Vector<Segment> vector, boolean bl, boolean bl2) {
            return Uri$Path$.MODULE$.apply(vector, bl, bl2);
        }

        public static Path empty() {
            return Uri$Path$.MODULE$.empty();
        }

        public static Path fromString(String string) {
            return Uri$Path$.MODULE$.fromString(string);
        }

        public static Order<Path> http4sInstancesForPath() {
            return Uri$Path$.MODULE$.http4sInstancesForPath();
        }

        public static Hash<Path> http4sInstancesForPathBinCompat() {
            return Uri$Path$.MODULE$.http4sInstancesForPathBinCompat();
        }

        public static Path unsafeFromString(String string) {
            return Uri$Path$.MODULE$.unsafeFromString(string);
        }

        public static boolean apply$default$2() {
            return Uri$Path$.MODULE$.apply$default$2();
        }

        public static boolean apply$default$3() {
            return Uri$Path$.MODULE$.apply$default$3();
        }

        public Path(Vector<Segment> segments, boolean absolute, boolean endsWithSlash) {
            this.segments = segments;
            this.absolute = absolute;
            this.endsWithSlash = endsWithSlash;
            this.renderString = Renderable.renderString$(this);
        }

        public Vector<Segment> segments() {
            return this.segments;
        }

        public boolean absolute() {
            return this.absolute;
        }

        public boolean endsWithSlash() {
            return this.endsWithSlash;
        }

        public boolean isEmpty() {
            return this.segments().isEmpty();
        }

        public boolean nonEmpty() {
            return this.segments().nonEmpty();
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof Path) {
                Path p = (Path)object;
                return this.doEquals(p);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean doEquals(Path path) {
            Vector<Segment> vector = this.segments();
            Vector<Segment> vector2 = path.segments();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (path.absolute() != this.absolute()) return false;
            if (path.endsWithSlash() != this.endsWithSlash()) return false;
            return true;
        }

        public int hashCode() {
            int hash2 = Uri$Path$.org$http4s$Uri$Path$$$hashSeed;
            hash2 = MurmurHash3$.MODULE$.mix(hash2, Statics.anyHash(this.segments()));
            hash2 = MurmurHash3$.MODULE$.mix(hash2, Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.absolute())));
            hash2 = MurmurHash3$.MODULE$.mix(hash2, Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.endsWithSlash())));
            return MurmurHash3$.MODULE$.finalizeHash(hash2, 3);
        }

        @Override
        public Writer render(Writer writer) {
            String start = this.absolute() ? "/" : "";
            writer.$less$less(start).$less$less(this.segments().iterator().mkString("/"));
            if (this.endsWithSlash() && this.segments().nonEmpty()) {
                return writer.$less$less("/");
            }
            return writer;
        }

        @Override
        public String renderString() {
            return this.renderString;
        }

        @Override
        public String toString() {
            return this.renderString();
        }

        public Path $div(Segment segment) {
            return this.addSegment(segment);
        }

        public <A> Path $div(A segment, SegmentEncoder<A> evidence$1) {
            return this.addSegment(segment, evidence$1);
        }

        public Path addSegment(Segment segment) {
            Vector segments = (Vector)this.segments().$colon$plus((Object)segment);
            boolean endsWithSlash = segment.isEmpty() ? this.endsWithSlash() : false;
            return Uri$Path$.MODULE$.apply((Vector<Segment>)segments, this.absolute() || this.segments().isEmpty(), endsWithSlash);
        }

        public <A> Path addSegment(A segment, SegmentEncoder<A> encoder) {
            return this.addSegment(encoder.toSegment(segment));
        }

        /*
         * Unable to fully structure code
         */
        public Path addSegments(Seq<Segment> value) {
            block3: {
                if (value.isEmpty()) {
                    return this;
                }
                segments = (Vector)this.segments().$plus$plus(value);
                var4_3 = value;
                v0 = scala.package$.MODULE$.Nil();
                var5_4 = var4_3;
                if (!(v0 == null ? var5_4 != null : v0.equals(var5_4) == false)) ** GOTO lbl-1000
                if (var4_3 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(var6_5 = scala.package$.MODULE$.Seq().unapplySeq(var4_3), 1) != 0) ** GOTO lbl-1000
                var7_6 = (Segment)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(var6_5, 0);
                v1 = Uri$Path$Segment$.MODULE$.empty();
                var8_7 = var7_6;
                if (v1 != null) break block3;
                if (var8_7 == null) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            if (v1.equals(var8_7)) lbl-1000:
            // 3 sources

            {
                v2 = this.endsWithSlash();
            } else lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
            endsWithSlash = v2;
            return Uri$Path$.MODULE$.apply((Vector<Segment>)segments, this.absolute() != false || this.segments().isEmpty() != false, endsWithSlash);
        }

        public Path normalize() {
            return Uri$Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().filterNot(Uri$::org$http4s$Uri$Path$$_$normalize$$anonfun$1)), Uri$Path$.MODULE$.apply$default$2(), Uri$Path$.MODULE$.apply$default$3());
        }

        public Path merge(Path path) {
            Vector merge = this.isEmpty() || this.endsWithSlash() ? this.segments() : this.segments().init();
            return Uri$Path$.MODULE$.apply((Vector<Segment>)((Vector)merge.$plus$plus(path.segments())), this.absolute(), path.endsWithSlash());
        }

        public Path concat(Path path) {
            return Uri$Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().$plus$plus(path.segments())), this.absolute() || this.isEmpty() && path.absolute(), path.endsWithSlash() || path.isEmpty() && this.endsWithSlash());
        }

        public boolean startsWith(Path path) {
            return this.segments().startsWith(path.segments(), this.segments().startsWith$default$2());
        }

        public boolean startsWithString(String path) {
            return this.startsWith(Uri$Path$.MODULE$.unsafeFromString(path));
        }

        public Option<Object> indexOf(Path prefix) {
            return this.findSplit(prefix);
        }

        public Option<Object> indexOfString(String path) {
            return this.findSplit(Uri$Path$.MODULE$.unsafeFromString(path));
        }

        public Option<Object> findSplit(Path prefix) {
            if (this.startsWith(prefix)) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)prefix.segments().size()));
            }
            return None$.MODULE$;
        }

        public Option<Object> findSplitOfString(String path) {
            return this.findSplit(Uri$Path$.MODULE$.unsafeFromString(path));
        }

        public Tuple2<Path, Path> splitAt(int idx) {
            if (idx <= 0) {
                return Tuple2$.MODULE$.apply((Object)Uri$Path$.MODULE$.empty(), (Object)this);
            }
            if (idx < this.segments().size()) {
                Tuple2 tuple2 = this.segments().splitAt(idx);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector start = (Vector)tuple2._1();
                Vector end = (Vector)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)start, (Object)end);
                Vector start2 = (Vector)tuple22._1();
                Vector end2 = (Vector)tuple22._2();
                return Tuple2$.MODULE$.apply((Object)Uri$Path$.MODULE$.apply((Vector<Segment>)start2, this.absolute(), Uri$Path$.MODULE$.apply$default$3()), (Object)Uri$Path$.MODULE$.apply((Vector<Segment>)end2, true, this.endsWithSlash()));
            }
            if (idx == this.segments().size()) {
                return Tuple2$.MODULE$.apply((Object)Uri$Path$.MODULE$.apply(this.segments(), this.absolute(), Uri$Path$.MODULE$.apply$default$3()), (Object)(this.endsWithSlash() ? Uri$Path$.MODULE$.Root() : Uri$Path$.MODULE$.empty()));
            }
            return Tuple2$.MODULE$.apply((Object)this, (Object)Uri$Path$.MODULE$.empty());
        }

        private Path copy(Vector<Segment> segments, boolean absolute, boolean endsWithSlash) {
            return Uri$Path$.MODULE$.apply(segments, absolute, endsWithSlash);
        }

        private Vector<Segment> copy$default$1() {
            return this.segments();
        }

        private boolean copy$default$2() {
            return this.absolute();
        }

        private boolean copy$default$3() {
            return this.endsWithSlash();
        }

        public Path dropEndsWithSlash() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), false);
        }

        public Path addEndsWithSlash() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), true);
        }

        public Path toAbsolute() {
            return this.copy(this.copy$default$1(), true, this.copy$default$3());
        }

        public Path toRelative() {
            return this.copy(this.copy$default$1(), false, this.copy$default$3());
        }

        public static final class Segment {
            private final String encoded;
            private final String toString;

            public static <A> Function1<String, A> andThen(Function1<Segment, A> function1) {
                return Uri$Path$Segment$.MODULE$.andThen(function1);
            }

            public static Segment apply(String string) {
                return Uri$Path$Segment$.MODULE$.apply(string);
            }

            public static double apply$mcDD$sp(double d) {
                return Uri$Path$Segment$.MODULE$.apply$mcDD$sp(d);
            }

            public static double apply$mcDF$sp(float f) {
                return Uri$Path$Segment$.MODULE$.apply$mcDF$sp(f);
            }

            public static double apply$mcDI$sp(int n) {
                return Uri$Path$Segment$.MODULE$.apply$mcDI$sp(n);
            }

            public static double apply$mcDJ$sp(long l) {
                return Uri$Path$Segment$.MODULE$.apply$mcDJ$sp(l);
            }

            public static float apply$mcFD$sp(double d) {
                return Uri$Path$Segment$.MODULE$.apply$mcFD$sp(d);
            }

            public static float apply$mcFF$sp(float f) {
                return Uri$Path$Segment$.MODULE$.apply$mcFF$sp(f);
            }

            public static float apply$mcFI$sp(int n) {
                return Uri$Path$Segment$.MODULE$.apply$mcFI$sp(n);
            }

            public static float apply$mcFJ$sp(long l) {
                return Uri$Path$Segment$.MODULE$.apply$mcFJ$sp(l);
            }

            public static int apply$mcID$sp(double d) {
                return Uri$Path$Segment$.MODULE$.apply$mcID$sp(d);
            }

            public static int apply$mcIF$sp(float f) {
                return Uri$Path$Segment$.MODULE$.apply$mcIF$sp(f);
            }

            public static int apply$mcII$sp(int n) {
                return Uri$Path$Segment$.MODULE$.apply$mcII$sp(n);
            }

            public static int apply$mcIJ$sp(long l) {
                return Uri$Path$Segment$.MODULE$.apply$mcIJ$sp(l);
            }

            public static long apply$mcJD$sp(double d) {
                return Uri$Path$Segment$.MODULE$.apply$mcJD$sp(d);
            }

            public static long apply$mcJF$sp(float f) {
                return Uri$Path$Segment$.MODULE$.apply$mcJF$sp(f);
            }

            public static long apply$mcJI$sp(int n) {
                return Uri$Path$Segment$.MODULE$.apply$mcJI$sp(n);
            }

            public static long apply$mcJJ$sp(long l) {
                return Uri$Path$Segment$.MODULE$.apply$mcJJ$sp(l);
            }

            public static void apply$mcVD$sp(double d) {
                Uri$Path$Segment$.MODULE$.apply$mcVD$sp(d);
            }

            public static void apply$mcVF$sp(float f) {
                Uri$Path$Segment$.MODULE$.apply$mcVF$sp(f);
            }

            public static void apply$mcVI$sp(int n) {
                Uri$Path$Segment$.MODULE$.apply$mcVI$sp(n);
            }

            public static void apply$mcVJ$sp(long l) {
                Uri$Path$Segment$.MODULE$.apply$mcVJ$sp(l);
            }

            public static boolean apply$mcZD$sp(double d) {
                return Uri$Path$Segment$.MODULE$.apply$mcZD$sp(d);
            }

            public static boolean apply$mcZF$sp(float f) {
                return Uri$Path$Segment$.MODULE$.apply$mcZF$sp(f);
            }

            public static boolean apply$mcZI$sp(int n) {
                return Uri$Path$Segment$.MODULE$.apply$mcZI$sp(n);
            }

            public static boolean apply$mcZJ$sp(long l) {
                return Uri$Path$Segment$.MODULE$.apply$mcZJ$sp(l);
            }

            public static <A> Function1<A, Segment> compose(Function1<A, String> function1) {
                return Uri$Path$Segment$.MODULE$.compose(function1);
            }

            public static Segment empty() {
                return Uri$Path$Segment$.MODULE$.empty();
            }

            public static Order<Segment> http4sInstancesForSegment() {
                return Uri$Path$Segment$.MODULE$.http4sInstancesForSegment();
            }

            public Segment(String encoded) {
                this.encoded = encoded;
                this.toString = encoded;
            }

            public String encoded() {
                return this.encoded;
            }

            public boolean isEmpty() {
                return this.encoded().isEmpty();
            }

            public boolean equals(Object obj) {
                Object object = obj;
                if (object instanceof Segment) {
                    Segment s2 = (Segment)object;
                    String string = s2.encoded();
                    String string2 = this.encoded();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                return false;
            }

            public int hashCode() {
                return this.encoded().hashCode();
            }

            public String decoded(Charset charset, boolean plusIsSpace, Function1<Object, Object> toSkip) {
                return Uri$.MODULE$.decode(this.encoded(), charset, plusIsSpace, toSkip);
            }

            public Charset decoded$default$1() {
                return StandardCharsets.UTF_8;
            }

            public boolean decoded$default$2() {
                return false;
            }

            public Function1<Object, Object> decoded$default$3() {
                return Uri$::org$http4s$Uri$Path$Segment$$_$decoded$default$3$$anonfun$adapted$1;
            }

            public String toString() {
                return this.toString;
            }
        }

        public static interface SegmentEncoder<A>
        extends Serializable {
            public static <A> SegmentEncoder<A> apply(SegmentEncoder<A> segmentEncoder) {
                return Uri$Path$SegmentEncoder$.MODULE$.apply(segmentEncoder);
            }

            public static SegmentEncoder<BigDecimal> bigDecimalSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.bigDecimalSegmentEncoder();
            }

            public static SegmentEncoder<BigInt> bigIntSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.bigIntSegmentEncoder();
            }

            public static SegmentEncoder<Object> booleanSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.booleanSegmentEncoder();
            }

            public static SegmentEncoder<Object> byteSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.byteSegmentEncoder();
            }

            public static SegmentEncoder<Object> charSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.charSegmentEncoder();
            }

            public static Contravariant<SegmentEncoder> contravariantInstance() {
                return Uri$Path$SegmentEncoder$.MODULE$.contravariantInstance();
            }

            public static SegmentEncoder<Object> doubleSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.doubleSegmentEncoder();
            }

            public static SegmentEncoder<Object> floatSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.floatSegmentEncoder();
            }

            public static <A> SegmentEncoder<A> fromShow(Show<A> show) {
                return Uri$Path$SegmentEncoder$.MODULE$.fromShow(show);
            }

            public static <A> SegmentEncoder<A> fromToString() {
                return Uri$Path$SegmentEncoder$.MODULE$.fromToString();
            }

            public static <A> SegmentEncoder<A> instance(Function1<A, Segment> function1) {
                return Uri$Path$SegmentEncoder$.MODULE$.instance(function1);
            }

            public static SegmentEncoder<Object> intSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.intSegmentEncoder();
            }

            public static SegmentEncoder<Object> longSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.longSegmentEncoder();
            }

            public static SegmentEncoder<Segment> segmentSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.segmentSegmentEncoder();
            }

            public static SegmentEncoder<Object> shortSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.shortSegmentEncoder();
            }

            public static SegmentEncoder<String> stringSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.stringSegmentEncoder();
            }

            public static SegmentEncoder<UUID> uuidSegmentEncoder() {
                return Uri$Path$SegmentEncoder$.MODULE$.uuidSegmentEncoder();
            }

            public Segment toSegment(A var1);

            public static SegmentEncoder contramap$(SegmentEncoder $this, Function1 f) {
                return $this.contramap(f);
            }

            default public <B> SegmentEncoder<B> contramap(Function1<B, A> f) {
                return b -> this.toSegment(f.apply(b));
            }
        }
    }

    public static final class RegName
    implements Renderable,
    Host,
    Product,
    Serializable {
        private final CIString host;

        public static RegName apply(CIString cIString) {
            return Uri$RegName$.MODULE$.apply(cIString);
        }

        public static RegName apply(String string) {
            return Uri$RegName$.MODULE$.apply(string);
        }

        public static Show<RegName> catsInstancesForHttp4sUriRegName() {
            return Uri$RegName$.MODULE$.catsInstancesForHttp4sUriRegName();
        }

        public static RegName fromHostname(Hostname hostname) {
            return Uri$RegName$.MODULE$.fromHostname(hostname);
        }

        public static RegName fromProduct(Product product) {
            return Uri$RegName$.MODULE$.fromProduct(product);
        }

        public static RegName unapply(RegName regName) {
            return Uri$RegName$.MODULE$.unapply(regName);
        }

        public RegName(CIString host) {
            this.host = host;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegName)) return false;
            RegName regName = (RegName)object;
            CIString cIString = this.host();
            CIString cIString2 = regName.host();
            if (cIString != null) {
                if (!((Object)cIString).equals(cIString2)) return false;
                return true;
            }
            if (cIString2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RegName;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RegName";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "host";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public CIString host() {
            return this.host;
        }

        @Override
        public String value() {
            return this.host().toString();
        }

        public Option<Hostname> toHostname() {
            return Hostname$.MODULE$.fromString(this.host().toString());
        }

        public RegName copy(CIString host) {
            return new RegName(host);
        }

        public CIString copy$default$1() {
            return this.host();
        }

        public CIString _1() {
            return this.host();
        }
    }

    public static final class Scheme
    implements Ordered<Scheme> {
        private final String value;
        private int hash;

        public static Either<ParseFailure, Scheme> fromString(String string) {
            return Uri$Scheme$.MODULE$.fromString(string);
        }

        public static Scheme http() {
            return Uri$Scheme$.MODULE$.http();
        }

        public static HttpCodec<Scheme> http4sInstancesForScheme() {
            return Uri$Scheme$.MODULE$.http4sInstancesForScheme();
        }

        public static Order<Scheme> http4sOrderForScheme() {
            return Uri$Scheme$.MODULE$.http4sOrderForScheme();
        }

        public static Show<Scheme> http4sShowForScheme() {
            return Uri$Scheme$.MODULE$.http4sShowForScheme();
        }

        public static Scheme https() {
            return Uri$Scheme$.MODULE$.https();
        }

        public static Either<ParseFailure, Scheme> parse(String string) {
            return Uri$Scheme$.MODULE$.parse(string);
        }

        public static Scheme unsafeFromString(String string) {
            return Uri$Scheme$.MODULE$.unsafeFromString(string);
        }

        public Scheme(String value) {
            this.value = value;
            Ordered.$init$((Ordered)this);
            this.hash = 0;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof Scheme) {
                Scheme that = (Scheme)object;
                return this.value().equalsIgnoreCase(that.value());
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = package$.MODULE$.hashLower(this.value());
            }
            return this.hash;
        }

        public String toString() {
            return new StringBuilder(8).append("Scheme(").append(this.value()).append(")").toString();
        }

        public int compare(Scheme other) {
            return this.value().compareToIgnoreCase(other.value());
        }
    }

    public static final class UserInfo
    implements Ordered<UserInfo>,
    Product,
    Serializable {
        private final String username;
        private final Option password;

        public static UserInfo apply(String string, Option<String> option) {
            return Uri$UserInfo$.MODULE$.apply(string, option);
        }

        public static UserInfo fromProduct(Product product) {
            return Uri$UserInfo$.MODULE$.fromProduct(product);
        }

        public static Either<ParseFailure, UserInfo> fromString(String string) {
            return Uri$UserInfo$.MODULE$.fromString(string);
        }

        public static Either<ParseFailure, UserInfo> fromStringWithCharset(String string, Charset charset) {
            return Uri$UserInfo$.MODULE$.fromStringWithCharset(string, charset);
        }

        public static Show<UserInfo> http4sInstancesForUserInfo() {
            return Uri$UserInfo$.MODULE$.http4sInstancesForUserInfo();
        }

        public static UserInfo unapply(UserInfo userInfo) {
            return Uri$UserInfo$.MODULE$.unapply(userInfo);
        }

        public UserInfo(String username, Option<String> password) {
            this.username = username;
            this.password = password;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UserInfo)) return false;
            UserInfo userInfo = (UserInfo)object;
            String string = this.username();
            String string2 = userInfo.username();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.password();
            Option<String> option2 = userInfo.password();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UserInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UserInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "username";
            }
            if (1 == n2) {
                return "password";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String username() {
            return this.username;
        }

        public Option<String> password() {
            return this.password;
        }

        public int compare(UserInfo that) {
            int n = this.username().compareTo(that.username());
            if (0 == n) {
                return scala.package$.MODULE$.Ordering().Option((Ordering)Ordering.String$.MODULE$).compare(this.password(), that.password());
            }
            int cmp = n;
            return cmp;
        }

        public UserInfo copy(String username, Option<String> password) {
            return new UserInfo(username, password);
        }

        public String copy$default$1() {
            return this.username();
        }

        public Option<String> copy$default$2() {
            return this.password();
        }

        public String _1() {
            return this.username();
        }

        public Option<String> _2() {
            return this.password();
        }
    }
}

