/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio1;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.RejectedExecutionException;
import org.http4s.blaze.channel.ChannelHead;
import org.http4s.blaze.channel.nio1.NIO1ClientChannel;
import org.http4s.blaze.channel.nio1.NIO1HeadStage$;
import org.http4s.blaze.channel.nio1.NIO1HeadStage$Complete$;
import org.http4s.blaze.channel.nio1.NIO1HeadStage$Incomplete$;
import org.http4s.blaze.channel.nio1.NIO1HeadStage$WriteError$;
import org.http4s.blaze.channel.nio1.Selectable;
import org.http4s.blaze.channel.nio1.SelectorLoop;
import org.http4s.blaze.pipeline.Command$Disconnected$;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.util.BufferTools$;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class NIO1HeadStage
extends ChannelHead
implements Selectable {
    public final NIO1ClientChannel org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch;
    public final SelectorLoop org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop;
    public final SelectionKey org$http4s$blaze$channel$nio1$NIO1HeadStage$$key;
    public Throwable org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason;
    public Promise<ByteBuffer> org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise;
    public int org$http4s$blaze$channel$nio1$NIO1HeadStage$$readSize;
    public ByteBuffer[] org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData;
    public Promise<BoxedUnit> org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise;

    public NIO1HeadStage(NIO1ClientChannel ch, SelectorLoop selectorLoop, SelectionKey key) {
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch = ch;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop = selectorLoop;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key = key;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason = null;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise = null;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readSize = -1;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData = null;
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise = null;
    }

    @Override
    public String name() {
        return "NIO1 ByteBuffer Head Stage";
    }

    @Override
    public final void opsReady(ByteBuffer scratch) {
        int readyOps = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.readyOps();
        if ((readyOps & 1) != 0) {
            this.readReady(scratch);
        }
        if ((readyOps & 4) != 0) {
            this.writeReady(scratch);
            return;
        }
    }

    private void readReady(ByteBuffer scratch) {
        this.unsetOp(1);
        if (this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise != null) {
            Try<BoxedUnit> try_ = NIO1HeadStage$.MODULE$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$performRead(this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch, scratch, this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readSize);
            if (try_ instanceof Success) {
                ByteBuffer buffer = BufferTools$.MODULE$.copyBuffer(scratch);
                Promise<ByteBuffer> p = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise;
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise = null;
                p.success((Object)buffer);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                Promise<ByteBuffer> p = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise;
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise = null;
                p.failure(this.checkError(e));
                return;
            }
            throw new MatchError(try_);
        }
    }

    private void writeReady(ByteBuffer scratch) {
        ByteBuffer[] buffers = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData;
        WriteResult writeResult = NIO1HeadStage$.MODULE$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$performWrite(this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch, scratch, buffers);
        if (NIO1HeadStage$Complete$.MODULE$.equals(writeResult)) {
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData = null;
            this.unsetOp(4);
            Promise<BoxedUnit> p = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise;
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise = null;
            if (p != null) {
                p.tryComplete(NIO1HeadStage$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$CachedSuccess);
                return;
            }
            return;
        }
        if (NIO1HeadStage$Incomplete$.MODULE$.equals(writeResult)) {
            BufferTools$.MODULE$.dropEmpty(buffers);
            return;
        }
        if (writeResult instanceof WriteError) {
            Exception exception;
            WriteError writeError = NIO1HeadStage$WriteError$.MODULE$.unapply((WriteError)writeResult);
            Exception t = exception = writeError._1();
            this.unsetOp(4);
            Promise<BoxedUnit> p = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise;
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise = null;
            if (p != null) {
                p.failure((Throwable)t);
                return;
            }
            return;
        }
        throw new MatchError((Object)writeResult);
    }

    @Override
    public final Future<ByteBuffer> readRequest(int size) {
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(45).append("NIOHeadStage received a read request of size ").append(size).toString());
        }
        Promise p = Promise$.MODULE$.apply();
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop.executeTask(new SelectorLoop.LoopRunnable(p, size, this){
            private final Promise p$1;
            private final int size$1;
            private final /* synthetic */ NIO1HeadStage $outer;
            {
                this.p$1 = p$3;
                this.size$1 = size$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop);
            }

            public void run(ByteBuffer scratchBuffer) {
                if (this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason != null) {
                    this.p$1.failure(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason);
                    return;
                }
                if (this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise == null) {
                    Try<BoxedUnit> try_ = NIO1HeadStage$.MODULE$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$performRead(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch, scratchBuffer, this.size$1);
                    if (try_ instanceof Success) {
                        if (scratchBuffer.remaining() > 0) {
                            ByteBuffer data = BufferTools$.MODULE$.copyBuffer(scratchBuffer);
                            this.p$1.success((Object)data);
                            return;
                        }
                        this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readSize = this.size$1;
                        this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise = this.p$1;
                        this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$setOp(1);
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        this.p$1.failure(this.$outer.checkError(e));
                        return;
                    }
                    throw new MatchError(try_);
                }
                this.p$1.failure((Throwable)new IllegalStateException("Cannot have more than one pending read request"));
            }
        });
        return p.future();
    }

    @Override
    public final Future<BoxedUnit> writeRequest(ByteBuffer data) {
        return this.writeRequest((Seq<ByteBuffer>)package$.MODULE$.Nil().$colon$colon((Object)data));
    }

    @Override
    public final Future<BoxedUnit> writeRequest(Seq<ByteBuffer> data) {
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(29).append("NIO1HeadStage Write Request: ").append(data).toString());
        }
        Promise p = Promise$.MODULE$.apply();
        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop.executeTask(new SelectorLoop.LoopRunnable(p, data, this){
            private final Promise p$2;
            private final Seq data$1;
            private final /* synthetic */ NIO1HeadStage $outer;
            {
                this.p$2 = p$4;
                this.data$1 = data$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop);
            }

            public void run(ByteBuffer scratch) {
                if (this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason != null) {
                    this.p$2.failure(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason);
                    return;
                }
                if (this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise == null) {
                    ByteBuffer[] writes = (ByteBuffer[])this.data$1.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class));
                    if (!BufferTools$.MODULE$.checkEmpty(writes)) {
                        WriteResult writeResult = NIO1HeadStage$.MODULE$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$performWrite(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch, scratch, writes);
                        if (NIO1HeadStage$Complete$.MODULE$.equals(writeResult)) {
                            this.p$2.tryComplete(NIO1HeadStage$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$CachedSuccess);
                            return;
                        }
                        if (NIO1HeadStage$Incomplete$.MODULE$.equals(writeResult)) {
                            BufferTools$.MODULE$.dropEmpty(writes);
                            this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise = this.p$2;
                            this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData = writes;
                            this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$setOp(4);
                            this.p$2.future();
                            return;
                        }
                        if (writeResult instanceof WriteError) {
                            Exception exception;
                            WriteError writeError = NIO1HeadStage$WriteError$.MODULE$.unapply((WriteError)writeResult);
                            Exception t = exception = writeError._1();
                            this.p$2.failure((Throwable)t);
                            return;
                        }
                        throw new MatchError((Object)writeResult);
                    }
                    this.p$2.complete(NIO1HeadStage$.org$http4s$blaze$channel$nio1$NIO1HeadStage$$$CachedSuccess);
                    return;
                }
                IllegalStateException t = new IllegalStateException("Cannot have more than one pending write request");
                this.p$2.failure((Throwable)t);
            }
        });
        return p.future();
    }

    @Override
    public final void close(Option<Throwable> cause) {
        this.doClosePipeline(cause);
    }

    @Override
    public final void doClosePipeline(Option<Throwable> cause) {
        try {
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$selectorLoop.executeTask(new Runnable(cause, this){
                private final Option cause$1;
                private final /* synthetic */ NIO1HeadStage $outer;
                {
                    this.cause$1 = cause$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    Throwable throwable;
                    Option option;
                    Logger Logger_this = this.$outer.logger();
                    if (Logger_this.isTraceEnabled()) {
                        Logger_this.trace(new StringBuilder(47).append("closeWithError(").append(this.cause$1).append("); readPromise: ").append(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise).append(", writePromise: ").append(this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise).toString());
                    }
                    if ((option = this.cause$1) instanceof Some) {
                        Throwable ex = (Throwable)((Some)option).value();
                        Logger Logger_this2 = this.$outer.logger();
                        if (Logger_this2.isErrorEnabled()) {
                            Logger_this2.error("Abnormal NIO1HeadStage termination", (Throwable)this.cause$1.get());
                        }
                        throwable = ex;
                    } else if (None$.MODULE$.equals(option)) {
                        throwable = Command$EOF$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Command$EOF$ c = throwable;
                    if (this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.isValid()) {
                        this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.interestOps(0);
                    }
                    this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.attach(null);
                    this.$outer.org$http4s$blaze$channel$nio1$NIO1HeadStage$$_$doClose$1(c);
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Event loop closed. Closing in current thread.", (Throwable)e);
            }
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$_$doClose$1((Throwable)cause.getOrElse(NIO1HeadStage::doClosePipeline$$anonfun$1));
        }
    }

    private void unsetOp(int op) {
        try {
            int ops = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.interestOps();
            if ((ops & op) != 0) {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.interestOps(ops & ~op);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.close((Option<Throwable>)None$.MODULE$);
        }
    }

    public void org$http4s$blaze$channel$nio1$NIO1HeadStage$$setOp(int op) {
        try {
            int ops = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.interestOps();
            if ((ops & op) == 0) {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$key.interestOps(ops | op);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.close((Option<Throwable>)None$.MODULE$);
        }
    }

    public final void org$http4s$blaze$channel$nio1$NIO1HeadStage$$_$doClose$1(Throwable t) {
        block8: {
            if (this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason == null) {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason = t;
            } else {
                Throwable throwable = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason;
                Command$EOF$ command$EOF$ = Command$EOF$.MODULE$;
                if (throwable == null ? command$EOF$ != null : !throwable.equals(command$EOF$)) {
                    Throwable throwable2 = this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason;
                    Throwable throwable3 = t;
                    if (throwable2 == null ? throwable3 != null : !throwable2.equals(throwable3)) {
                        this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$closedReason.addSuppressed(t);
                    }
                }
            }
            if (this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise != null) {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise.tryFailure(t);
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$readPromise = null;
            }
            if (this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise != null) {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise.tryFailure(t);
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writePromise = null;
            }
            this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$writeData = null;
            try {
                this.org$http4s$blaze$channel$nio1$NIO1HeadStage$$ch.close();
            }
            catch (IOException ex) {
                Logger Logger_this = this.logger();
                if (!Logger_this.isWarnEnabled()) break block8;
                Logger_this.warn("Unexpected IOException during channel close", (Throwable)ex);
            }
        }
        this.sendInboundCommand(Command$Disconnected$.MODULE$);
    }

    private static final Throwable doClosePipeline$$anonfun$1() {
        return Command$EOF$.MODULE$;
    }

    public static class WriteError
    implements WriteResult,
    Product,
    Serializable {
        private final Exception t;

        public static WriteError apply(Exception exception) {
            return NIO1HeadStage$WriteError$.MODULE$.apply(exception);
        }

        public static WriteError fromProduct(Product product) {
            return NIO1HeadStage$WriteError$.MODULE$.fromProduct(product);
        }

        public static WriteError unapply(WriteError writeError) {
            return NIO1HeadStage$WriteError$.MODULE$.unapply(writeError);
        }

        public WriteError(Exception t) {
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteError)) return false;
            WriteError writeError = (WriteError)object;
            Exception exception = this.t();
            Exception exception2 = writeError.t();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!writeError.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "WriteError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Exception t() {
            return this.t;
        }

        public WriteError copy(Exception t) {
            return new WriteError(t);
        }

        public Exception copy$default$1() {
            return this.t();
        }

        public Exception _1() {
            return this.t();
        }
    }

    public static interface WriteResult {
    }
}

