/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio1;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.ChannelOptions$;
import org.http4s.blaze.channel.ServerChannelGroup;
import org.http4s.blaze.channel.SocketConnection;
import org.http4s.blaze.channel.nio1.FixedSelectorPool;
import org.http4s.blaze.channel.nio1.NIO1SocketServerGroup;
import org.http4s.blaze.channel.nio1.SelectorLoopPool;
import org.http4s.blaze.channel.package$;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.util.BasicThreadFactory$;
import scala.Function1;
import scala.concurrent.Future;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;

public final class NIO1SocketServerGroup$
implements Serializable {
    private static final int DefaultBufferSize;
    private static final AtomicInteger acceptorNumber;
    private static final AtomicInteger workerNumber;
    public static final NIO1SocketServerGroup$ MODULE$;

    private NIO1SocketServerGroup$() {
    }

    static {
        MODULE$ = new NIO1SocketServerGroup$();
        DefaultBufferSize = 65536;
        acceptorNumber = new AtomicInteger(0);
        workerNumber = new AtomicInteger(0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NIO1SocketServerGroup$.class);
    }

    private ThreadFactory defaultAcceptorThreadFactory() {
        int id = acceptorNumber.getAndIncrement();
        return BasicThreadFactory$.MODULE$.apply(new StringBuilder(15).append("blaze-acceptor-").append(id).toString(), false);
    }

    private ThreadFactory defaultWorkerThreadFactory() {
        int id = workerNumber.getAndIncrement();
        return BasicThreadFactory$.MODULE$.apply(new StringBuilder(13).append("blaze-worker-").append(id).toString(), false);
    }

    public ServerChannelGroup create(SelectorLoopPool acceptorPool, SelectorLoopPool workerPool, ChannelOptions channelOptions, int maxConnections) {
        return new NIO1SocketServerGroup(acceptorPool, workerPool, channelOptions, maxConnections);
    }

    public ChannelOptions create$default$3() {
        return ChannelOptions$.MODULE$.DefaultOptions();
    }

    public int create$default$4() {
        return package$.MODULE$.DefaultMaxConnections();
    }

    public ServerChannelGroup fixed(int workerThreads, int bufferSize, ChannelOptions channelOptions, ThreadFactory selectorThreadFactory, int acceptorThreads, ThreadFactory acceptorThreadFactory, int maxConnections) {
        FixedSelectorPool acceptorPool = new FixedSelectorPool(acceptorThreads, 1, acceptorThreadFactory);
        FixedSelectorPool workerPool = new FixedSelectorPool(workerThreads, bufferSize, selectorThreadFactory);
        ServerChannelGroup underlying = this.create(acceptorPool, workerPool, channelOptions, maxConnections);
        return new ServerChannelGroup(underlying, workerPool, acceptorPool){
            private final ServerChannelGroup underlying$1;
            private final FixedSelectorPool workerPool$1;
            private final FixedSelectorPool acceptorPool$1;
            {
                this.underlying$1 = underlying$2;
                this.workerPool$1 = workerPool$2;
                this.acceptorPool$1 = acceptorPool$2;
            }

            public void closeGroup() {
                this.underlying$1.closeGroup();
                this.workerPool$1.close();
                this.acceptorPool$1.close();
            }

            public Try bind(InetSocketAddress address, Function1 service) {
                return this.underlying$1.bind(address, (Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>>)service);
            }
        };
    }

    public int fixed$default$1() {
        return package$.MODULE$.DefaultPoolSize();
    }

    public int fixed$default$2() {
        return DefaultBufferSize;
    }

    public ChannelOptions fixed$default$3() {
        return ChannelOptions$.MODULE$.DefaultOptions();
    }

    public ThreadFactory fixed$default$4() {
        return this.defaultWorkerThreadFactory();
    }

    public int fixed$default$5() {
        return 1;
    }

    public ThreadFactory fixed$default$6() {
        return this.defaultAcceptorThreadFactory();
    }

    public int fixed$default$7() {
        return package$.MODULE$.DefaultMaxConnections();
    }
}

