/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio1;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.http4s.blaze.channel.nio1.NIO1Channel;
import org.http4s.blaze.channel.nio1.Selectable;
import org.http4s.blaze.internal.compat$;
import org.http4s.blaze.util.TaskQueue;
import org.http4s.blaze.util.TaskQueue$Closed$;
import org.http4s.blaze.util.TaskQueue$Enqueued$;
import org.http4s.blaze.util.TaskQueue$FirstEnqueued$;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

public final class SelectorLoop
implements Executor,
ExecutionContext {
    public final Selector org$http4s$blaze$channel$nio1$SelectorLoop$$selector;
    private final int bufferSize;
    private volatile boolean isClosed;
    public final ByteBuffer org$http4s$blaze$channel$nio1$SelectorLoop$$scratch;
    private final AtomicBoolean once;
    public final Logger org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
    private final TaskQueue taskQueue;
    public final Thread org$http4s$blaze$channel$nio1$SelectorLoop$$thread;
    private final String threadName;

    public SelectorLoop(Selector selector, int bufferSize, ThreadFactory threadFactory) {
        this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector = selector;
        this.bufferSize = bufferSize;
        ExecutionContext.$init$((ExecutionContext)this);
        Predef$.MODULE$.require(bufferSize > 0, () -> SelectorLoop.$init$$$anonfun$1(bufferSize));
        this.isClosed = false;
        this.org$http4s$blaze$channel$nio1$SelectorLoop$$scratch = ByteBuffer.allocateDirect(bufferSize);
        this.once = new AtomicBoolean(false);
        this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger = LoggerFactory.getLogger((String)"org.http4s.blaze.channel.nio1.SelectorLoop");
        this.taskQueue = new TaskQueue();
        this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread = threadFactory.newThread(new Runnable(this){
            private final /* synthetic */ SelectorLoop $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$http4s$blaze$channel$nio1$SelectorLoop$$runLoop();
            }
        });
        this.threadName = this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread.getName();
        this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread.start();
    }

    public void close() {
        if (this.once.compareAndSet(false, true)) {
            this.isClosed = true;
            Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info(new StringBuilder(27).append("Shutting down SelectorLoop ").append(this.threadName).toString());
            }
            this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.wakeup();
            return;
        }
    }

    public void executeTask(Runnable runnable) throws RejectedExecutionException {
        Thread thread = Thread.currentThread();
        Thread thread2 = this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread;
        if (thread == null ? thread2 != null : !thread.equals(thread2)) {
            this.enqueueTask(runnable);
            return;
        }
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                this.reportFailure(t);
            }
            throw throwable;
        }
    }

    public void enqueueTask(Runnable runnable) throws RejectedExecutionException {
        TaskQueue.Result result = this.taskQueue.enqueueTask(runnable);
        if (TaskQueue$Enqueued$.MODULE$.equals(result)) {
            return;
        }
        if (TaskQueue$FirstEnqueued$.MODULE$.equals(result)) {
            this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.wakeup();
            return;
        }
        if (TaskQueue$Closed$.MODULE$.equals(result)) {
            throw new RejectedExecutionException("This SelectorLoop is closed.");
        }
        throw new MatchError((Object)result);
    }

    @Override
    public void execute(Runnable runnable) throws RejectedExecutionException {
        this.enqueueTask(runnable);
    }

    public void reportFailure(Throwable cause) {
        Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error(new StringBuilder(42).append("Exception executing task in selector loop ").append(this.threadName).toString(), cause);
            return;
        }
    }

    public void initChannel(NIO1Channel ch, Function1<SelectionKey, Selectable> mkStage) {
        this.enqueueTask(new Runnable(ch, mkStage, this){
            private final NIO1Channel ch$1;
            private final Function1 mkStage$1;
            private final /* synthetic */ SelectorLoop $outer;
            {
                this.ch$1 = ch$2;
                this.mkStage$1 = mkStage$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                if (!this.$outer.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.isOpen()) {
                    this.ch$1.close();
                    return;
                }
                try {
                    Predef$.MODULE$.require(!this.ch$1.selectableChannel().isBlocking(), SelectorLoop::org$http4s$blaze$channel$nio1$SelectorLoop$$anon$2$$_$run$$anonfun$1);
                    SelectionKey key = this.ch$1.selectableChannel().register(this.$outer.org$http4s$blaze$channel$nio1$SelectorLoop$$selector, 0);
                    Selectable head = (Selectable)this.mkStage$1.apply((Object)key);
                    key.attach(head);
                    Logger Logger_this = this.$outer.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("Channel initialized.");
                    }
                }
                catch (Throwable throwable) {
                    block8: {
                        Throwable throwable2;
                        block7: {
                            block6: {
                                Option option;
                                throwable2 = throwable;
                                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) break block6;
                                Throwable throwable3 = (Throwable)option.get();
                                break block7;
                            }
                            if (!(throwable2 instanceof ControlThrowable)) break block8;
                        }
                        Throwable t = throwable2;
                        Logger Logger_this = this.$outer.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                        if (Logger_this.isErrorEnabled()) {
                            Logger_this.error("Caught error during channel init.", t);
                        }
                        this.ch$1.close();
                    }
                    throw throwable;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$blaze$channel$nio1$SelectorLoop$$anon$2$$_$run$$anonfun$1()}, serializedLambda);
            }
        });
    }

    public void org$http4s$blaze$channel$nio1$SelectorLoop$$runLoop() {
        boolean cleanShutdown = true;
        try {
            while (!this.isClosed) {
                int selected = this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.select();
                this.taskQueue.executeTasks();
                if (selected <= 0) continue;
                this.processKeys(this.org$http4s$blaze$channel$nio1$SelectorLoop$$scratch, this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.selectedKeys());
            }
        }
        catch (ClosedSelectorException e) {
            Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Selector unexpectedly closed", (Throwable)e);
            }
            cleanShutdown = false;
            this.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Unhandled exception in selector loop", t);
                }
                cleanShutdown = false;
                this.close();
            }
            throw throwable;
        }
        this.killSelector(cleanShutdown);
        this.taskQueue.close();
    }

    private void processKeys(ByteBuffer scratch, Set<SelectionKey> selectedKeys) {
        Iterator<SelectionKey> it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey k = it.next();
            it.remove();
            Selectable selectable = this.getAttachment(k);
            try {
                if (k.isValid()) {
                    if (selectable != null) {
                        selectable.opsReady(scratch);
                        continue;
                    }
                    k.cancel();
                    Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                    if (!Logger_this.isErrorEnabled()) continue;
                    Logger_this.error("Illegal state: selector key had null attachment.");
                    continue;
                }
                if (selectable == null) continue;
                selectable.close((Option<Throwable>)None$.MODULE$);
            }
            catch (Throwable throwable) {
                block14: {
                    Throwable throwable2;
                    block13: {
                        block12: {
                            Option option;
                            throwable2 = throwable;
                            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) break block12;
                            Throwable throwable3 = (Throwable)option.get();
                            break block13;
                        }
                        if (!(throwable2 instanceof ControlThrowable)) break block14;
                    }
                    Throwable t = throwable2;
                    Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error performing channel operations. Closing channel.", t);
                    }
                    try {
                        selectable.close((Option<Throwable>)Some$.MODULE$.apply((Object)t));
                        continue;
                    }
                    catch (Throwable throwable4) {
                        Option option;
                        Throwable throwable5 = throwable4;
                        if (throwable5 != null && !(option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            Throwable throwable6;
                            Throwable t2 = throwable6 = (Throwable)option.get();
                            Logger Logger_this2 = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                            if (!Logger_this2.isErrorEnabled()) continue;
                            Logger_this2.error("Fatal error shutting down pipeline", t2);
                            continue;
                        }
                        throw throwable4;
                    }
                }
                throw throwable;
            }
        }
    }

    private void killSelector(boolean cleanShutdown) {
        try {
            if (!this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.keys().isEmpty()) {
                None$ none$;
                boolean bl = cleanShutdown;
                if (bl) {
                    none$ = None$.MODULE$;
                } else if (!bl) {
                    none$ = Some$.MODULE$.apply((Object)new ShutdownChannelGroupException());
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                None$ ex = none$;
                compat$.MODULE$.CollectionConverters().SetHasAsScala(this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.keys()).asScala().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> this.killSelector$$anonfun$1((Option)ex, arg_0)));
            }
            this.org$http4s$blaze$channel$nio1$SelectorLoop$$selector.close();
        }
        catch (Throwable throwable) {
            block11: {
                Throwable throwable2;
                block10: {
                    block9: {
                        Option option;
                        throwable2 = throwable;
                        if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) break block9;
                        Throwable throwable3 = (Throwable)option.get();
                        break block10;
                    }
                    if (!(throwable2 instanceof ControlThrowable)) break block11;
                }
                Throwable t = throwable2;
                Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn("Killing selector resulted in an exception", t);
                }
            }
            throw throwable;
        }
    }

    private Selectable getAttachment(SelectionKey key) {
        AssertionError ex;
        block2: {
            Object object = key.attachment();
            if (object == null) {
                return null;
            }
            if (object instanceof Selectable) {
                Selectable s2 = (Selectable)object;
                return s2;
            }
            Object other = object;
            ex = package$.MODULE$.bug(new StringBuilder(17).append("Unexpected type: ").append(other.getClass().getName()).toString());
            Logger Logger_this = this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
            if (!Logger_this.isErrorEnabled()) break block2;
            Logger_this.error(((Throwable)((Object)ex)).getMessage(), (Throwable)((Object)ex));
        }
        throw ex;
    }

    private static final Object $init$$$anonfun$1(int bufferSize$1) {
        return new StringBuilder(21).append("Invalid buffer size: ").append(bufferSize$1).toString();
    }

    public static final Object org$http4s$blaze$channel$nio1$SelectorLoop$$anon$2$$_$run$$anonfun$1() {
        return "Can only register non-blocking channels";
    }

    private final /* synthetic */ void killSelector$$anonfun$1(Option ex$1, SelectionKey k) {
        try {
            Selectable head = this.getAttachment(k);
            if (head != null) {
                head.close((Option<Throwable>)ex$1);
            }
        }
        catch (IOException iOException) {}
    }

    public abstract class LoopRunnable
    implements Runnable {
        public LoopRunnable() {
            if (SelectorLoop.this == null) {
                throw new NullPointerException();
            }
        }

        public abstract void run(ByteBuffer var1);

        @Override
        public final void run() {
            Thread currentThread;
            Thread thread = currentThread = Thread.currentThread();
            Thread thread2 = SelectorLoop.this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread;
            if (!(thread != null ? !thread.equals(thread2) : thread2 != null)) {
                this.run(SelectorLoop.this.org$http4s$blaze$channel$nio1$SelectorLoop$$scratch);
                return;
            }
            String msg = new StringBuilder(52).append("Task rejected: executed RunWithScratch in incorrect ").append(new StringBuilder(28).append("thread: ").append(currentThread).append(". Expected thread: ").append(SelectorLoop.this.org$http4s$blaze$channel$nio1$SelectorLoop$$thread).append(".").toString()).toString();
            IllegalStateException ex = new IllegalStateException(msg);
            Logger Logger_this = SelectorLoop.this.org$http4s$blaze$channel$nio1$SelectorLoop$$logger;
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error(msg, (Throwable)ex);
                return;
            }
        }

        public final /* synthetic */ SelectorLoop org$http4s$blaze$channel$nio1$SelectorLoop$LoopRunnable$$$outer() {
            return SelectorLoop.this;
        }
    }
}

