/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.ImmutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings$;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$;
import org.http4s.blaze.http.http2.SettingsDecoder$SettingsFrame$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Execution$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class PriorKnowledgeHandshaker<T>
implements TailStage<ByteBuffer> {
    private Logger logger;
    private Head _prevStage;
    private final ImmutableHttp2Settings localSettings;

    public PriorKnowledgeHandshaker(ImmutableHttp2Settings localSettings) {
        this.localSettings = localSettings;
        Stage.$init$(this);
        Tail.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    public final ExecutionContext ec() {
        return Execution$.MODULE$.trampoline();
    }

    @Override
    public String name() {
        return new StringBuilder(2).append(this.getClass().getSimpleName()).append("(").append(this.localSettings).append(")").toString();
    }

    public abstract Future<ByteBuffer> handlePreface();

    public abstract Future<T> handshakeComplete(MutableHttp2Settings var1, ByteBuffer var2);

    public final Future<T> handshake() {
        block0: {
            Logger Logger_this = this.logger();
            if (!Logger_this.isDebugEnabled()) break block0;
            Logger_this.debug("Beginning handshake.");
        }
        return this.handlePreface().flatMap((Function1 & Serializable)bytes -> this.handleSettings((ByteBuffer)bytes), this.ec()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MutableHttp2Settings settings = (MutableHttp2Settings)tuple2._1();
                ByteBuffer acc = (ByteBuffer)tuple2._2();
                return this.handshakeComplete(settings, acc);
            }
            throw new MatchError((Object)tuple2);
        }, this.ec());
    }

    private Future<Tuple2<MutableHttp2Settings, ByteBuffer>> handleSettings(ByteBuffer bytes) {
        return this.sendSettings().flatMap((Function1 & Serializable)_$1 -> this.readSettings(bytes), this.ec());
    }

    private Future<BoxedUnit> sendSettings() {
        ByteBuffer settingsBuffer = FrameSerializer$.MODULE$.mkSettingsFrame(this.localSettings.toSeq());
        return this.channelWrite(settingsBuffer);
    }

    private Future<Tuple2<MutableHttp2Settings, ByteBuffer>> readSettings(ByteBuffer acc) {
        Option<Object> option;
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(36).append("receiving settings. Available data: ").append(acc).toString());
        }
        if ((option = this.getFrameSize(acc)) instanceof Some) {
            int n;
            int size = n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            if (this.localSettings.maxFrameSize() + bits$.MODULE$.HeaderSize() < size) {
                Http2SessionException ex = Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(63).append("While waiting for initial settings frame, encountered frame of ").append(new StringBuilder(32).append("size ").append(size).append(" exceeded MAX_FRAME_SIZE (").append(this.localSettings.maxFrameSize()).append(")").toString()).toString());
                Logger Logger_this2 = this.logger();
                if (Logger_this2.isInfoEnabled()) {
                    Logger_this2.info("Received SETTINGS frame that was to large", (Throwable)ex);
                }
                return this.sendGoAway(ex);
            }
            int frameSize = n;
            if (acc.remaining() < frameSize) {
                return this.insufficientData$1(acc);
            }
        }
        if (None$.MODULE$.equals(option)) {
            return this.insufficientData$1(acc);
        }
        if (option instanceof Some) {
            SettingsDecoder.SettingsFrame settingsFrame;
            int size = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            ByteBuffer settingsBuffer = BufferTools$.MODULE$.takeSlice(acc, size);
            Either<Http2Exception, SettingsDecoder.SettingsFrame> either = SettingsDecoder$.MODULE$.decodeSettingsFrame(settingsBuffer);
            if (either instanceof Right && (settingsFrame = (SettingsDecoder.SettingsFrame)((Right)either).value()) != null) {
                SettingsDecoder.SettingsFrame settingsFrame2 = SettingsDecoder$SettingsFrame$.MODULE$.unapply(settingsFrame);
                Option<Seq<Http2Settings.Setting>> option2 = settingsFrame2._1();
                if (option2 instanceof Some) {
                    Seq newSettings = (Seq)((Some)option2).value();
                    MutableHttp2Settings remoteSettings = MutableHttp2Settings$.MODULE$.default();
                    Option<Http2Exception> option3 = remoteSettings.updateSettings((Seq<Http2Settings.Setting>)newSettings);
                    if (None$.MODULE$.equals(option3)) {
                        Logger Logger_this3 = this.logger();
                        if (Logger_this3.isDebugEnabled()) {
                            Logger_this3.debug(new StringBuilder(46).append("Successfully received settings frame. Current ").append(new StringBuilder(17).append("remote settings: ").append(remoteSettings).toString()).toString());
                        }
                        return this.sendSettingsAck().map((Function1 & Serializable)_$2 -> {
                            MutableHttp2Settings mutableHttp2Settings = (MutableHttp2Settings)Predef$.MODULE$.ArrowAssoc((Object)remoteSettings);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mutableHttp2Settings, (Object)acc);
                        }, this.ec());
                    }
                    if (option3 instanceof Some) {
                        Http2Exception ex = (Http2Exception)((Some)option3).value();
                        Logger Logger_this4 = this.logger();
                        if (Logger_this4.isInfoEnabled()) {
                            Logger_this4.info("Received SETTINGS frame but failed to update.", (Throwable)ex);
                        }
                        return this.channelWrite(FrameSerializer$.MODULE$.mkGoAwayFrame(0, ex)).flatMap((Function1 & Serializable)_$3 -> Future$.MODULE$.failed((Throwable)ex), this.ec());
                    }
                    throw new MatchError(option3);
                }
                if (None$.MODULE$.equals(option2)) {
                    Logger Logger_this5 = this.logger();
                    if (Logger_this5.isInfoEnabled()) {
                        Logger_this5.info("Received a SETTINGS ack frame which is a protocol error. Shutting down.");
                    }
                    Http2SessionException ex = Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received a SETTINGS ack before receiving remote settings");
                    return this.sendGoAway(ex);
                }
            }
            if (either instanceof Left) {
                Http2Exception http2Exception = (Http2Exception)((Left)either).value();
                return this.sendGoAway(http2Exception);
            }
            throw new MatchError(either);
        }
        throw new MatchError(option);
    }

    private Future<Nothing$> sendGoAway(Http2Exception http2Exception) {
        ByteBuffer reply = FrameSerializer$.MODULE$.mkGoAwayFrame(0, http2Exception);
        return this.channelWrite(reply).flatMap((Function1 & Serializable)_$4 -> {
            this.closePipeline((Option)None$.MODULE$);
            return Future$.MODULE$.failed((Throwable)http2Exception);
        }, this.ec());
    }

    private Future<BoxedUnit> sendSettingsAck() {
        ByteBuffer ackSettings = FrameSerializer$.MODULE$.mkSettingsAckFrame();
        return this.channelWrite(ackSettings);
    }

    private Option<Object> getFrameSize(ByteBuffer buffer) {
        if (buffer.remaining() < bits$.MODULE$.HeaderSize()) {
            return None$.MODULE$;
        }
        buffer.mark();
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        buffer.reset();
        if (len == -1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(len + bits$.MODULE$.HeaderSize())));
    }

    private final Future insufficientData$1(ByteBuffer acc$1) {
        block0: {
            Logger Logger_this = this.logger();
            if (!Logger_this.isDebugEnabled()) break block0;
            Logger_this.debug(new StringBuilder(43).append("Insufficient data. Current representation: ").append(BufferTools$.MODULE$.hexString(acc$1, 256)).toString());
        }
        return this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).flatMap((Function1 & Serializable)buff -> this.readSettings(BufferTools$.MODULE$.concatBuffers(acc$1, (ByteBuffer)buff)), this.ec());
    }
}

