/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.ConnectionImpl;
import org.http4s.blaze.http.http2.FlowStrategy;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.ImmutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.PriorKnowledgeHandshaker;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.stages.BasicTail;
import org.http4s.blaze.pipeline.stages.OneMessageStage;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.StageTools$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Try;

public final class ServerPriorKnowledgeHandshaker
extends PriorKnowledgeHandshaker<BoxedUnit> {
    private final ImmutableHttp2Settings localSettings;
    private final FlowStrategy flowStrategy;
    private final Function1<Object, LeafBuilder<StreamFrame>> nodeBuilder;

    public ServerPriorKnowledgeHandshaker(ImmutableHttp2Settings localSettings, FlowStrategy flowStrategy, Function1<Object, LeafBuilder<StreamFrame>> nodeBuilder) {
        this.localSettings = localSettings;
        this.flowStrategy = flowStrategy;
        this.nodeBuilder = nodeBuilder;
        super(localSettings);
    }

    @Override
    public void stageStartup() {
        ServerPriorKnowledgeHandshaker serverPriorKnowledgeHandshaker = this;
        synchronized (serverPriorKnowledgeHandshaker) {
            Stage.stageStartup$(this);
            this.handshake().onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Failed to received prelude", ex);
                    }
                    this.closePipeline((Option)None$.MODULE$);
                    return;
                }
            }, this.ec());
        }
    }

    @Override
    public Future<BoxedUnit> handshakeComplete(MutableHttp2Settings remoteSettings, ByteBuffer data) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.handshakeComplete$$anonfun$1(remoteSettings, data);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    @Override
    public Future<ByteBuffer> handlePreface() {
        return StageTools$.MODULE$.accumulateAtLeast(bits$.MODULE$.PrefaceString().length(), this).flatMap((Function1 & Serializable)buf -> {
            Http2SessionException ex;
            block1: {
                ByteBuffer prelude;
                ByteBuffer byteBuffer = prelude = BufferTools$.MODULE$.takeSlice((ByteBuffer)buf, bits$.MODULE$.PrefaceString().length());
                ByteBuffer byteBuffer2 = bits$.MODULE$.getPrefaceBuffer();
                if (!(byteBuffer != null ? !((Object)byteBuffer).equals(byteBuffer2) : byteBuffer2 != null)) {
                    return Future$.MODULE$.successful(buf);
                }
                String preludeString = StandardCharsets.UTF_8.decode(prelude).toString();
                String msg = new StringBuilder(17).append("Invalid prelude: ").append(preludeString).toString();
                ex = Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg);
                Logger Logger_this = this.logger();
                if (!Logger_this.isErrorEnabled()) break block1;
                Logger_this.error(msg, (Throwable)ex);
            }
            return Future$.MODULE$.failed((Throwable)ex);
        }, this.ec());
    }

    private void installHttp2ServerStage(MutableHttp2Settings remoteSettings, ByteBuffer remainder) {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(35).append("Installing pipeline with settings: ").append(remoteSettings).toString());
        }
        BasicTail<ByteBuffer> tail = new BasicTail<ByteBuffer>("http2ServerTail");
        LeafBuilder<Object> newTail = LeafBuilder$.MODULE$.apply(tail);
        if (remainder.hasRemaining()) {
            newTail = newTail.prepend(new OneMessageStage<ByteBuffer>(remainder));
        }
        this.replaceTail((LeafBuilder)newTail, true);
        new ConnectionImpl(tail, this.localSettings, remoteSettings, this.flowStrategy, (Option<Function1<Object, LeafBuilder<StreamFrame>>>)Some$.MODULE$.apply(this.nodeBuilder), Execution$.MODULE$.trampoline());
    }

    private final void handshakeComplete$$anonfun$1(MutableHttp2Settings remoteSettings$1, ByteBuffer data$1) {
        this.installHttp2ServerStage(remoteSettings$1, data$1);
    }
}

